/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.dto.GaiEmbeddingData;
import kd.ai.gai.dto.GaiRepoData;
import kd.ai.gai.dto.GaiRepoFileData;
import kd.ai.gai.dto.GaiRepoSearchData;
import kd.ai.gai.helper.RagHelper;
import kd.ai.gai.mservice.GaiRagService;
import kd.ai.gai.pojo.GaiRagSearchParams;
import kd.ai.gai.pojo.GaiRepoAddFileParams;
import kd.ai.gai.pojo.GaiRepoCreateParams;
import kd.ai.gai.pojo.GaiRepoDelFileParams;
import kd.ai.gai.util.GaiMServiceUtils;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiRagServiceImpl
implements GaiRagService {
    private static final Log logger = LogFactory.getLog(GaiRagServiceImpl.class);
    private static final String METHOD_DESC = "\u5fae\u670d\u52a1";

    public Map<String, Object> createRepo(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoCreateParams params = (GaiRepoCreateParams)JsonUtil.fromJson((String)paramsJson, GaiRepoCreateParams.class);
            RepoDataInfo repo = RagHelper.createRepo(METHOD_DESC, params);
            Object convertResult = GaiMServiceUtils.pojoToObject(repo.getRepoId());
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryRepoInfo(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoData repoDTO = RagHelper.queryRepoInfo(METHOD_DESC, repoId);
            Object convertResult = GaiMServiceUtils.pojoToObject(repoDTO);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryRepoFilesInfo(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            List<GaiRepoFileData> repoFilesInfos = RagHelper.queryRepoFilesInfo(METHOD_DESC, repoId);
            Object convertResult = GaiMServiceUtils.pojoToObject(repoFilesInfos);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryIndexMethod() {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            List<GaiEmbeddingData> gaiEmbeddings = RagHelper.queryIndexMethod(METHOD_DESC);
            Object convertResult = GaiMServiceUtils.pojoToObject(gaiEmbeddings);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> addRepoFiles(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoAddFileParams params = (GaiRepoAddFileParams)JsonUtil.fromJson((String)paramsJson, GaiRepoAddFileParams.class);
            boolean success = RagHelper.addRepoFiles(METHOD_DESC, params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> deleteRepoById(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            boolean success = RagHelper.deleteRepoById(METHOD_DESC, repoId);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> deleteRepoFiles(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoDelFileParams params = (GaiRepoDelFileParams)JsonUtil.fromJson((String)paramsJson, GaiRepoDelFileParams.class);
            boolean success = RagHelper.deleteRepoFiles(METHOD_DESC, params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> search(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRagSearchParams searchParams = (GaiRagSearchParams)JsonUtil.fromJson((String)paramsJson, GaiRagSearchParams.class);
            List<GaiRepoSearchData> datas = RagHelper.search(METHOD_DESC, searchParams);
            Object convertResult = GaiMServiceUtils.pojoToObject(datas);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    private Map<String, Object> buildErrorResult(String requestId, Throwable e) {
        ErrorCode errorCode;
        Map resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)e).getErrorCode()) ? MserviceResultHelper.buildErr((String)requestId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR)) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR);
        logger.error("\u3010GPT-\u5fae\u670d\u52a1\u63a5\u53e3\u3011\u5f02\u5e38\uff0crequestId:{},errMsg:{}", new Object[]{requestId, JSON.toJSONString((Object)resp), e});
        return resp;
    }
}

