/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.mservice.GaiService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiServiceImpl
implements GaiService {
    private static final Log logger = LogFactory.getLog(GaiServiceImpl.class);
    private static final Random random = new SecureRandom();

    public void selectProcessInSideBar(long processId, String rootPageId, String assistant) {
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 selectProcessInSideBar : processId: {},rootPageId: {},assistant: {}", new Object[]{processId, rootPageId, assistant});
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        String taskId = random.nextLong() + "";
        WebSocketService.pushChat(null, (String)context.getAssistantPageId(), (String)taskId, (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)context.getChatSessionId(), (String)assistant);
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        gaiInitConfig.setSelectedProcessId(processId + "");
        gaiInitConfig.setSwitchSide(Boolean.TRUE);
        gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        logger.info("user {} GAIAGTREE:{}", (Object)context.getUserId(), (Object)GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        WebSocketService.pushChangeConfig(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (GaiInitConfig)gaiInitConfig);
    }

    public void startProcessInSideBar(long processId, String rootPageId, Map<String, String> paramMap) {
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 startProcessInSideBar : processId: {},rootPageId: {}", (Object)processId, (Object)rootPageId);
        this.startProcess(processId, rootPageId, paramMap, null);
    }

    public void startProcessInSideBar(long processId, String rootPageId, Map<String, String> paramMap, String userInput) {
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 startProcessInSideBar : processId: {},rootPageId: {}", (Object)processId, (Object)rootPageId);
        this.startProcess(processId, rootPageId, paramMap, userInput);
    }

    public void sideBarInit(String rootPageId, String gaiInitConfigJson) {
        Process process;
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 sideBarInit : gaiInitConfigJson: {},rootPageId: {}", (Object)gaiInitConfigJson, (Object)rootPageId);
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)gaiInitConfigJson)) {
            throw new KDBizException(Errors.M_SERVICE_ERROR, new Object[0]);
        }
        GaiInitConfig gaiInitConfig = (GaiInitConfig)JSON.parseObject((String)gaiInitConfigJson, GaiInitConfig.class);
        String startProcessNumber = gaiInitConfig.getStartProcessNumber();
        if (!StringUtils.isEmpty((CharSequence)startProcessNumber)) {
            this.startProcess(startProcessNumber, rootPageId, gaiInitConfig.getStartParams());
        } else {
            String startProcessId = gaiInitConfig.getStartProcessId();
            if (!StringUtils.isEmpty((CharSequence)startProcessId)) {
                this.startProcess(Long.parseLong(startProcessId), rootPageId, gaiInitConfig.getStartParams(), null);
            }
        }
        String selectProcessNumber = gaiInitConfig.getSelectedProcessNumber();
        if (!StringUtils.isEmpty((CharSequence)selectProcessNumber) && (process = ProcessService.getProcessByNumber((String)selectProcessNumber)) != null) {
            gaiInitConfig.setStartProcessId(process.getId() + "");
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        logger.info("user2 {} GAIAGTREE:{}", (Object)context.getUserId(), (Object)GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        WebSocketService.pushChangeConfig(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (GaiInitConfig)gaiInitConfig);
    }

    private void startProcess(String processNumber, String rootPageId, Map<String, String> paramMap) {
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        ThreadUtils.execute(() -> GaiUtils.startProcess((String)processNumber, (Context)context, (Map)paramMap, null));
    }

    private void startProcess(long processId, String rootPageId, Map<String, String> paramMap, String userInput) {
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        ThreadUtils.execute(() -> GaiUtils.startProcess((long)processId, (Context)context, (Map)paramMap, (String)userInput));
    }
}

