/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.openapi;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.UUID;
import kd.ai.gai.core.trace.MonitorServiceHelper;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.entity.EventLog;
import kd.ai.gai.core.trace.entity.EventLogResult;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.entity.StepLogResult;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.StringUtils;

@ApiController(value="gai", desc="\u76d1\u63a7\u65e5\u5fd7")
@ApiMapping(value="/monitor")
public class MonitorServiceController
implements Serializable {
    private static final Log logger = LogFactory.getLog(MonitorServiceController.class);

    @ApiPostMapping(value="/saveStepLog", desc="GPT Step\u65e5\u5fd7\u63a5\u53e3")
    public CustomApiResult<@ApiResponseBody StepLogResult> saveStepLog(@ApiRequestBody StepLog log) {
        try {
            if (StringUtils.isEmpty((String)log.getChatSessionId())) {
                log.setChatSessionId(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            StepLogResult stepLogResult = MonitorServiceHelper.saveStepLog((StepLog)log);
            return CustomApiResult.success((Object)stepLogResult);
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace((Exception)e)));
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/saveEventLog", desc="GPT Event\u65e5\u5fd7\u63a5\u53e3")
    public CustomApiResult<@ApiResponseBody EventLogResult> saveEventLog(@ApiRequestBody EventLog log) {
        try {
            if (StringUtils.isEmpty((String)log.getChatSessionId())) {
                log.setChatSessionId(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            EventLogResult eventLogResult = MonitorServiceHelper.saveEventLog((EventLog)log);
            return CustomApiResult.success((Object)eventLogResult);
        }
        catch (Exception e) {
            logger.error(String.format("save event log error : %s", CommonUtil.getStackTrace((Exception)e)));
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)e.getMessage());
        }
    }

    @ApiGetMapping(value="/queryStepLogsByChatSessionId", desc="\u901a\u8fc7ChatSessionId\u67e5\u8be2\u6240\u6709Step\u65e5\u5fd7\u67e5\u8be2\u63a5\u53e3")
    public CustomApiResult<@ApiResponseBody JSONObject> queryStepLogsByChatSessionId(@ApiParam(value="chatSessionId", required=true) @ApiParam(value="chatSessionId", required=true) String chatSessionId) {
        try {
            JSONObject data = MonitorServiceHelper.queryStepLogsByChatSessionId((String)chatSessionId);
            return CustomApiResult.success((Object)data);
        }
        catch (Exception e) {
            logger.error(String.format("query step log error : %s", CommonUtil.getStackTrace((Exception)e)));
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)e.getMessage());
        }
    }
}

