/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.openapi;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.dto.GaiEmbeddingData;
import kd.ai.gai.dto.GaiRepoData;
import kd.ai.gai.dto.GaiRepoFileData;
import kd.ai.gai.dto.GaiRepoSearchData;
import kd.ai.gai.helper.RagHelper;
import kd.ai.gai.pojo.GaiRagSearchParams;
import kd.ai.gai.pojo.GaiRepoAddFileParams;
import kd.ai.gai.pojo.GaiRepoCreateParams;
import kd.ai.gai.pojo.GaiRepoDelFileParams;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiHeader;
import kd.bos.openapi.common.custom.annotation.ApiHeaders;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;

@ApiController(value="gai", desc="RAG-\u77e5\u8bc6\u5e93\u63a5\u53e3")
@ApiMapping(value="/rag/repo")
public class RagRepoServiceController
implements Serializable {
    private static final Log logger = LogFactory.getLog(RagRepoServiceController.class);
    private static final String METHOD_DESC = "OpenAPI";

    @ApiPostMapping(value="/queryIndexMethod", desc="\u67e5\u8be2\u53ef\u7528\u7d22\u5f15\u65b9\u5f0f\uff08embedding \u6a21\u578b\uff09\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody List<GaiEmbeddingData>> queryIndexMethod() {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            List<GaiEmbeddingData> gaiEmbeddings = RagHelper.queryIndexMethod(METHOD_DESC);
            result = CustomApiResult.success(gaiEmbeddings);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/createRepo", desc="\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody RepoDataInfo> createRepo(@ApiRequestBody GaiRepoCreateParams createParams) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RepoDataInfo repoDataInfo = RagHelper.createRepo(METHOD_DESC, createParams);
            result = CustomApiResult.success((Object)repoDataInfo);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/queryRepoInfo", desc="\u67e5\u8be2\u77e5\u8bc6\u5e93\u4fe1\u606f\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody GaiRepoData> queryRepoInfo(@ApiParam(value="\u77e5\u8bc6\u5e93ID") @ApiParam(value="\u77e5\u8bc6\u5e93ID") long repoId) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoData repoDTO = RagHelper.queryRepoInfo(METHOD_DESC, repoId);
            result = CustomApiResult.success((Object)repoDTO);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/queryRepoFilesInfo", desc="\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u4ef6\u5217\u8868\u4fe1\u606f\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody List<GaiRepoFileData>> queryRepoFilesInfo(@ApiParam(value="\u77e5\u8bc6\u5e93ID") @ApiParam(value="\u77e5\u8bc6\u5e93ID") long repoId) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            List<GaiRepoFileData> repoFilesInfos = RagHelper.queryRepoFilesInfo(METHOD_DESC, repoId);
            result = CustomApiResult.success(repoFilesInfos);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/addRepoFiles", desc="\u65b0\u589e\u77e5\u8bc6\u5e93\u6587\u4ef6")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> addRepoFiles(@ApiRequestBody GaiRepoAddFileParams params) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            boolean success = RagHelper.addRepoFiles(METHOD_DESC, params);
            result = CustomApiResult.success((Object)success);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/deleteRepoById", desc="\u5220\u9664\u6587\u672c\u95ee\u7b54\u77e5\u8bc6\u5e93\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> deleteRepoById(@ApiParam(value="\u77e5\u8bc6\u5e93ID") @ApiParam(value="\u77e5\u8bc6\u5e93ID") long repoId) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            boolean success = RagHelper.deleteRepoById(METHOD_DESC, repoId);
            result = CustomApiResult.success((Object)success);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/deleteRepoFiles", desc="\u5220\u9664\u77e5\u8bc6\u5e93\u6587\u672c\u5217\u8868\u6587\u4ef6\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> deleteRepoFiles(@ApiRequestBody GaiRepoDelFileParams params) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            boolean success = RagHelper.deleteRepoFiles(METHOD_DESC, params);
            result = CustomApiResult.success((Object)success);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    @ApiPostMapping(value="/search", desc="\u77e5\u8bc6\u5e93\u68c0\u7d22\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> search(@ApiRequestBody GaiRagSearchParams params) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            List<GaiRepoSearchData> dataList = RagHelper.search(METHOD_DESC, params);
            result = CustomApiResult.success(dataList);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    private CustomApiResult buildErrorResult(String requestId, Exception e) {
        ErrorCode errorCode;
        CustomApiResult result = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? CustomApiResult.fail((String)errorCode.getCode(), (String)errorCode.getMessage()) : CustomApiResult.fail((String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getCode(), (String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getMsg())) : CustomApiResult.fail((String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getCode(), (String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getMsg());
        logger.error("\u3010GPT-OpenAPI\u63a5\u53e3\u3011\u5f02\u5e38\uff0crequestId:{},errMsg:{}", new Object[]{requestId, JSON.toJSONString((Object)result), e});
        return result;
    }
}

