/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.agent.Feedback;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.domain.dto.agent.FileMetadata;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.dto.agent.annotations.FormAnnotation;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.ActionCallbackMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.engine.message.ForwardMessage;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.PurposeEnum;
import kd.ai.gai.core.enuz.agent.TipsTypeEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.privacy.model.PrivacyAgreementType;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.plugin.ShowCloseCallBack;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AbstractGaiAssistantPlugin
extends AbstractFormPlugin {
    protected static final String CONTROL_VISIBLE_STATUS = "control_visible_status";
    private static final Log log = LogFactory.getLog(AbstractGaiAssistantPlugin.class);
    public static final String TEMP_SKILL_LIST = "skill_id_list_cache";

    public void assistantFormInit(IFormView formView, String chatSessionId) {
        CustomControl ctrl;
        Long userId = RequestContext.get().getCurrUserId();
        RootPageIdContext rootPageIdContext = GaiUtils.newContextInSlide((IFormView)formView, (String)chatSessionId);
        Map crossPageData = rootPageIdContext.getData();
        GaiInitConfig gaiInitConfig = GaiUtils.getInitGaiConfig((Map)crossPageData, (IFormView)formView, (String)rootPageIdContext.getChatSessionId());
        boolean permissionShow = GaiUtils.canOpenSide((Long)userId);
        if (!permissionShow) {
            gaiInitConfig.setShowIcon(Boolean.FALSE);
            gaiInitConfig.setSwitchSide(Boolean.FALSE);
            if (AbstractGaiAssistantPlugin.isFormDev(formView)) {
                log.info("GAI TEMP show tips");
                formView.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u4f9d\u8d56AI\u5f00\u53d1\u5e73\u53f0\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"gai.plugin.000011", (String)"ai-gai-core", (Object[])new Object[0]));
            }
        }
        if ((ctrl = (CustomControl)this.getControl("gpt_gai")) != null) {
            ctrl.setData((Object)ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig));
        }
        formView.getPageCache().put(CONTROL_VISIBLE_STATUS, String.valueOf(gaiInitConfig.getSwitchSide()));
    }

    public static boolean isFormDev(IFormView formView) {
        String formId = (String)formView.getFormShowParameter().getCustomParam("formId");
        return StringUtils.isNotEmpty((CharSequence)formId) && formId.equals("bos_devpn_formdesign");
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        if (key.equals("gpt_gai") || key.equals("gpt_skill")) {
            try {
                this.invokeCustomEvent(eventName, eventArgs, key);
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
                String message = e1.getMessage();
                this.getView().showErrorNotification(message);
                String chatSessionId = this.getChatSessionId();
                Map resultMap = ResultVoHelper.buildErrMsg((ErrorCode)GaiExceptionUtil.buildExtMsgErr((GaiErrorCode)GaiErrorCode.ERR_ASSISTANT, (String)message), (String)chatSessionId);
                CustomControl customControl = (CustomControl)this.getControl(key);
                customControl.setData((Object)resultMap);
            }
        }
    }

    private void invokeCustomEvent(String eventName, String eventArgs, String controlKey) {
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName);
        JSONObject requestData = JSON.parseObject((String)eventArgs);
        CustomControl customControl = (CustomControl)this.getControl(controlKey);
        Map resultMap = new HashMap();
        String chatSessionId = requestData.getString("id");
        if (StringUtils.isEmpty((CharSequence)chatSessionId) && !StringUtils.equalsIgnoreCase((CharSequence)requestActionType.name(), (CharSequence)RequestActionType.newChat.name())) {
            chatSessionId = this.getChatSessionId();
        }
        Context context = null;
        switch (requestActionType) {
            case initial: {
                if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
                    GaiUtils.newContextInSlide((IFormView)this.getView(), (String)chatSessionId);
                }
                context = FlowCacheData.getContext((String)chatSessionId);
                GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
                gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
                if (!GptPrivacyHelper.isTenantAgree((String)RequestContext.get().getTenantId())) {
                    gaiInitConfig.setShowIcon(Boolean.FALSE);
                }
                resultMap = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                GaiUtils.startProcessIfHas((Context)context, (IFormView)this.getView());
                break;
            }
            case newChat: {
                GaiUtils.newContextInSlide((IFormView)this.getView(), (String)chatSessionId);
                chatSessionId = this.getChatSessionId();
                JSONObject dataJo = new JSONObject();
                dataJo.put("id", (Object)chatSessionId);
                resultMap = ResultVoHelper.buildResult((String)ResultActionType.newChat.name(), (Object)dataJo);
                break;
            }
            case chat: {
                Long skillId;
                context = FlowCacheData.getContext((String)chatSessionId);
                Result result = null;
                String controlIds = (String)requestData.getOrDefault((Object)"controlIds", (Object)"");
                String skillIdString = (String)requestData.getOrDefault((Object)"skillId", (Object)"");
                String skillTypeString = (String)requestData.getOrDefault((Object)"skillType", null);
                String input = (String)requestData.getOrDefault((Object)"input", (Object)"");
                if (StringUtils.isEmpty((CharSequence)skillIdString)) {
                    Process process;
                    String processNumber;
                    String processId = (String)requestData.getOrDefault((Object)"processId", (Object)"");
                    if (StringUtils.isEmpty((CharSequence)processId) && !StringUtils.isEmpty((CharSequence)(processNumber = (String)requestData.getOrDefault((Object)"processNumber", (Object)""))) && (process = ProcessService.getProcessByNumber((String)processNumber)) != null) {
                        processId = process.getId() + "";
                    }
                    skillIdString = StringUtils.isEmpty((CharSequence)processId) ? null : processId;
                    skillTypeString = Skill.Type.PROCESS.toString();
                    log.info("processNumber skillIdString  {}", (Object)skillIdString);
                }
                Skill.Type skillType = StringUtils.isEmpty((CharSequence)skillTypeString) ? null : Skill.Type.valueOf((String)skillTypeString);
                Long l = skillId = StringUtils.isEmpty((CharSequence)skillIdString) ? null : Long.valueOf(Long.parseLong(skillIdString));
                if (StringUtils.isEmpty((CharSequence)skillIdString) && context.getAssistant() != null && context.getAssistant().getPromptId() == 0L) {
                    Assistant assistant = AssistantService.getDefault();
                    assistant = assistant == null ? new Assistant() : assistant;
                    context.setAssistant(assistant);
                }
                ChatMessage chatMessage = new ChatMessage();
                chatMessage.setSkillId(skillId == null ? 0L : skillId);
                chatMessage.setSkillType(skillType);
                chatMessage.setUserInput(input);
                chatMessage.setChatSessionId(chatSessionId);
                chatMessage.setInParaMap(Collections.singletonMap("controlIds", controlIds));
                GaiUtils.refreshBizPageId((Context)context, (IFormView)this.getView());
                try {
                    result = HandlerFactory.runHandler((Context)context, (Message)chatMessage);
                    if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
                        resultMap = ResultVoHelper.buildFakeErrMsg((String)Errors.LLM_ERROR.getCode(), (String)result.getErrorCode().getMessage(), (String)chatSessionId);
                        WebSocketService.pushWaitingDone(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)chatSessionId);
                        break;
                    }
                    if (result.getErrorCode().equals((Object)Errors.OK)) break;
                    resultMap = ResultVoHelper.buildErrMsg((String)result.getErrorCode().getCode(), (String)result.getErrorCode().getMessage(), (String)chatSessionId);
                    WebSocketService.pushWaitingDone(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)chatSessionId);
                }
                catch (KDBizException e) {
                    log.info("\u8c03\u7528\u51fa\u73b0\u5f02\u5e38({})\uff1a{}", (Object)e.getErrorCode().getCode(), (Object)e.getMessage());
                    resultMap = ResultVoHelper.buildErrMsg((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (String)chatSessionId);
                    WebSocketService.pushWaitingDone(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)chatSessionId);
                }
                catch (Exception e) {
                    log.info("\u8c03\u7528 \u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    resultMap = ResultVoHelper.buildErrMsg((String)Errors.internalError((String)e.getMessage()).getCode(), (String)e.getMessage(), (String)chatSessionId);
                    WebSocketService.pushWaitingDone(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)chatSessionId);
                }
                break;
            }
            case openWorkFlow: {
                String crossPageData = requestData.getString("crossPageData");
                String appNumber = (String)requestData.get((Object)"appNumber");
                String source = (String)requestData.get((Object)"source");
                String entityNumber = (String)requestData.get((Object)"entityNumber");
                String caption = (String)requestData.get((Object)"caption");
                GaiUtils.openApp((IFormView)this.getView(), (String)caption, (String)appNumber, (String)source, (String)entityNumber, (String)crossPageData);
                break;
            }
            case getSkillList: 
            case getProcessList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                Object groupIds = requestData.get((Object)"groupIds");
                if (groupIds == null) {
                    GaiUtils.refreshBizPageId((Context)context, (IFormView)this.getView());
                    List<Skill> processDataList = context.getSkillList();
                    log.info("processDataIDList: {}", (Object)processDataList.stream().map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet()).toString());
                    processDataList = AbstractGaiAssistantPlugin.getSkillListByCheckLic(context, processDataList);
                    resultMap = ResultVoHelper.buildProcessList(processDataList);
                    break;
                }
                JSONArray arr = (JSONArray)groupIds;
                ArrayList<Long> groupIdList = new ArrayList<Long>(arr.size());
                for (Object item : arr) {
                    groupIdList.add(Long.parseLong((String)item));
                }
                List<Skill> processDataList = ProcessService.getProcessListDataByGroupIds((Long[])groupIdList.toArray(new Long[0]));
                log.info("processDataIDList: {}", (Object)processDataList.stream().map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet()).toString());
                processDataList = AbstractGaiAssistantPlugin.getSkillListByCheckLic(context, processDataList);
                resultMap = ResultVoHelper.buildProcessList(processDataList);
                break;
            }
            case getTempSkillList: {
                String temList = this.getView().getPageCache().get(TEMP_SKILL_LIST);
                List skillList = new ArrayList();
                if (StringUtils.isNotEmpty((CharSequence)temList)) {
                    List tempskillList = (List)JSON.parseObject((String)temList, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]);
                    skillList = GaiUtils.buildSkillList((List)tempskillList);
                } else {
                    skillList = SkillService.getList(null, null);
                }
                resultMap = ResultVoHelper.buildProcessList(skillList);
                break;
            }
            case stopStream: {
                context = FlowCacheData.getContext((String)chatSessionId);
                String taskId = requestData.getString("taskId");
                String flowId = requestData.getString("flowId");
                StopStreamMessage stopStreamMessage = new StopStreamMessage();
                stopStreamMessage.setTaskId(taskId);
                stopStreamMessage.setFlowId(StringUtils.isEmpty((CharSequence)flowId) ? 0L : Long.parseLong(flowId));
                HandlerFactory.runHandler((Context)context, (Message)stopStreamMessage);
                return;
            }
            case showBillForm: {
                String appId = requestData.getString("appId");
                String billFormId = requestData.getString("billFormId");
                String billPkId = requestData.getString("billPkId");
                String crossPageData = requestData.getString("crossPageData");
                if (StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)billFormId) || StringUtils.isEmpty((CharSequence)billPkId)) {
                    ResultVoHelper.buildErrMsg((ErrorCode)Errors.INPUT_NOT_EMPTY_ERROR, (String)chatSessionId);
                }
                GaiUtils.showBillForm((IFormView)this.getView(), (String)appId, (String)billFormId, (String)billPkId, (String)crossPageData);
                break;
            }
            case forward: {
                ForwardType forwardType = ForwardType.valueOf((String)requestData.getString("type"));
                if (ForwardType.javaAction != forwardType) break;
                String actionString = this.getView().getPageCache().get(requestData.getString("actionKey"));
                String forwardMsgString = this.getView().getPageCache().get(requestData.getString("forwardMsgKey"));
                String bizPageId = GaiUtils.getCurrentBizPageId((IFormView)this.getView());
                if (StringUtils.isNotEmpty((CharSequence)actionString)) {
                    List actionResult = (List)SerializationUtils.fromJsonString((String)actionString, List.class);
                    HashMap<String, Object> arg = new HashMap<String, Object>(3);
                    arg.put("pageId", bizPageId);
                    arg.put("actions", actionResult);
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.addAction("sendDynamicFormAction", arg);
                }
                ForwardMessage forwardMessage = (ForwardMessage)JSON.parseObject((String)forwardMsgString, ForwardMessage.class);
                HandlerFactory.callback((ActionCallbackMessage)forwardMessage);
                break;
            }
            case statusChanged: {
                this.getView().getPageCache().put(CONTROL_VISIBLE_STATUS, requestData.getString("gaiShowStatus"));
                break;
            }
            case showAgreement: {
                this.showUserAgreement();
                break;
            }
            case showTenantAgreement: {
                this.showTenantAgreement();
                break;
            }
            case showAboutCosmic: {
                this.showAboutCosmic();
                break;
            }
            case getAgentList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                PageQuery pageQuery = this.parsePageQuery(requestData);
                AgentService.checkAgentVersion((String)context.getChatSessionId());
                PageResult getAgentPage = AgentService.getAgentSamplePage((PageQuery)pageQuery);
                WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.getAgentList.name(), (Object)getAgentPage);
                break;
            }
            case getChatInfoList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                PageQuery pageQuery = this.parsePageQuery(requestData);
                PageResult chatInfoPage = ChatService.getChatSessionPage((PageQuery)pageQuery);
                WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.getChatInfoList.name(), (Object)chatInfoPage);
                break;
            }
            case getChatItemList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                PageQuery pageQuery = this.parsePageQuery(requestData);
                PageResult chatMessagePage = ChatService.getChatMessagePage((String)chatSessionId, (PageQuery)pageQuery);
                WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.getChatItemList.name(), (Object)chatMessagePage);
                break;
            }
            case renameChat: {
                context = FlowCacheData.getContext((String)chatSessionId);
                this.renameChat(requestData, context);
                break;
            }
            case deleteChat: {
                context = FlowCacheData.getContext((String)chatSessionId);
                this.deleteChat(requestData, context);
                break;
            }
            case saveMsgFeedback: {
                context = FlowCacheData.getContext((String)chatSessionId);
                this.saveMsgFeedback(requestData, context);
                break;
            }
            case agentCancel: {
                long runId = Long.parseLong(requestData.getString("runId"));
                ChatService.agentCancel((String)chatSessionId, (long)runId);
                break;
            }
            case saveFile: {
                this.saveFile(requestData);
                break;
            }
            case showForm: {
                FormAnnotation formAnnotation = (FormAnnotation)requestData.toJavaObject(FormAnnotation.class);
                AnnotationService.showFormByAnnotation((IFormView)this.getView(), (FormAnnotation)formAnnotation);
                break;
            }
            case showNotification: {
                this.showNotification(requestData);
                break;
            }
            default: {
                resultMap = new HashMap();
            }
        }
        if (!resultMap.isEmpty()) {
            customControl.setData(resultMap);
        }
    }

    private static List<Skill> getSkillListByCheckLic(Context context, List<Skill> processDataList) {
        if (Context.needCheckLicense((Context)context)) {
            Set processIdList = processDataList.stream().filter(skill -> skill.getType() == Skill.Type.PROCESS).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
            Set agentIdList = processDataList.stream().filter(skill -> skill.getType() == Skill.Type.AGENT).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
            Set usedSkillIdList = GPTLicenseHelper.getUseBizIds((String)GaiFormIdEnum.GAI_AGENT.getId(), agentIdList);
            usedSkillIdList.addAll(GPTLicenseHelper.getUseBizIds((String)GaiFormIdEnum.GAI_PROCESS.getId(), processIdList));
            log.info("usedSkillIdList: {}", (Object)usedSkillIdList.toString());
            processDataList = processDataList.stream().filter(skill -> usedSkillIdList.contains(Long.valueOf(skill.getId()))).collect(Collectors.toList());
        }
        return processDataList;
    }

    protected String getChatSessionId() {
        return this.getView().getPageCache().get("chatSessionId");
    }

    private void showNotification(JSONObject requestData) {
        String method = (String)requestData.getOrDefault((Object)"method", (Object)TipsTypeEnum.SHOW_TIP_NOTIFICATION.getId());
        int duration = (Integer)requestData.getOrDefault((Object)"duration", (Object)"3500");
        String msg = requestData.getString("msg");
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_TIP_NOTIFICATION.getId())) {
            this.getView().showTipNotification(msg, Integer.valueOf(duration));
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_SUCCESS_NOTIFICATION.getId())) {
            this.getView().showSuccessNotification(msg, Integer.valueOf(duration));
        } else if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_ERROR_NOTIFICATION.getId())) {
            this.getView().showErrorNotification(msg);
        }
    }

    private void saveFile(JSONObject requestData) {
        FileMetadata fileMetadata = (FileMetadata)requestData.toJavaObject(FileMetadata.class);
        fileMetadata.setPurpose(PurposeEnum.USER.getId());
        if (fileMetadata.getFileSize() > 0xA00000L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u5c0f\u4e0d\u5141\u8bb8\u8d85\u8fc710M\u3002", (String)"GaiAgentFormPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setName(fileMetadata.getName());
        fileInfo.setFileSize(fileMetadata.getFileSize());
        fileInfo.setFileType(fileMetadata.getFileType());
        fileInfo.setFileUrl(fileMetadata.getFileUrl());
        fileInfo = FileService.save((FileInfo)fileInfo);
        fileMetadata.setFileId(StrUtils.longAsString((Long)fileInfo.getId()));
        fileMetadata.setFileUrl(fileInfo.getFileUrl());
        fileMetadata.setPreviewUrl(fileInfo.getPreviewUrl());
        String chatSessionId = this.getChatSessionId();
        Context context = FlowCacheData.getContext((String)chatSessionId);
        WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.saveFileResult.name(), (Object)fileMetadata);
    }

    private void deleteChat(JSONObject requestData, Context context) {
        long sessionId = Long.parseLong(requestData.getString("sessionId"));
        DynamicObject chatInfoDo = BusinessDataServiceHelper.loadSingle((Object)sessionId, (String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        if (chatInfoDo != null) {
            chatInfoDo.set("enable", (Object)EnableEnum.NO.getKeyStr());
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatInfoDo});
            if (saveObjs != null && saveObjs.length > 0) {
                requestData.put("id", (Object)context.getChatSessionId());
                log.info("delete success size: {}", (Object)saveObjs.length);
                WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.deleteChat.name(), (Object)requestData);
            }
        }
    }

    private void renameChat(JSONObject requestData, Context context) {
        long sessionId = Long.parseLong(requestData.getString("sessionId"));
        String title = requestData.getString("title");
        DynamicObject chatInfoDo = BusinessDataServiceHelper.loadSingle((Object)sessionId, (String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        if (chatInfoDo != null) {
            chatInfoDo.set("name", (Object)title);
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatInfoDo});
            if (saveObjs != null && saveObjs.length > 0) {
                requestData.put("id", (Object)context.getChatSessionId());
                log.info("save success size: {}", (Object)saveObjs.length);
                WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.renameChat.name(), (Object)requestData);
            }
        }
    }

    private void saveMsgFeedback(JSONObject requestData, Context context) {
        Feedback feedback = (Feedback)JSONObject.parseObject((String)requestData.toJSONString(), Feedback.class);
        if (StringUtils.length((CharSequence)feedback.getContent()) > 255) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)String.format("\u5185\u5bb9\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7%s\u3002", 255), (String)"AbstractGaiAssistantPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        List feedbackList = ChatService.saveChatMsgFeedback((Feedback)feedback);
        if (feedbackList != null) {
            for (Feedback feedbackItem : feedbackList) {
                if (StringUtils.isEmpty((CharSequence)feedbackItem.getId())) {
                    feedbackItem.setId(context.getChatSessionId());
                }
                WebSocketService.pushResult(null, (String)context.getAssistantPageId(), (String)context.getRootPageId(), (String)context.getGlobalSessionId(), (String)ResultActionType.saveMsgFeedback.name(), (Object)feedbackItem);
            }
        }
    }

    private PageQuery parsePageQuery(JSONObject requestData) {
        PageQuery pageQuery = new PageQuery();
        long lastId = Long.parseLong(requestData.getOrDefault((Object)"lastId", (Object)"0") + "");
        int pageSize = (Integer)requestData.getOrDefault((Object)"pageSize", (Object)20);
        String searchKey = requestData.getString("searchKey");
        pageQuery.setPageSize(Integer.valueOf(pageSize));
        pageQuery.setSearchKey(searchKey);
        pageQuery.setLasId(lastId);
        return pageQuery;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        this.getView().getPageCache().remove("showAgreement");
        if ("agreementClose".equals(actionId)) {
            CustomControl customControl = (CustomControl)this.getControl("gpt_gai");
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String chatSessionId = this.getView().getPageCache().get("chatSessionId");
            GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
            if ("userAgree".equals(returnData)) {
                gaiInitConfig.setUserAgree(true);
            } else if ("userDisagree".equals(returnData)) {
                gaiInitConfig.setUserAgree(false);
            }
            Map resultMap = ResultVoHelper.buildUserAgree((GaiInitConfig)gaiInitConfig);
            customControl.setData((Object)resultMap);
        }
    }

    private void showTenantAgreement() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_privacy_agreement");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("agreementType", (Object)PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT.getKey());
        showParameter.setStatus(OperationStatus.VIEW);
        IFormView baseView = this.getView().getParentView();
        baseView.showForm(showParameter);
        this.getView().sendFormAction(baseView);
    }

    private void showUserAgreement() {
        IFormView baseView;
        String pageId = this.getView().getPageCache().get("showAgreement");
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            return;
        }
        this.getView().getPageCache().put("showAgreement", "true");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("gai_privacy_agreement");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)PrivacyAgreementType.USER_PRIVACY_POLICY.getKey());
        Context context = FlowCacheData.getContext((String)this.getChatSessionId());
        if (context.getSlideenv().toString().startsWith("BOS")) {
            fsp.setCloseCallBack(new CloseCallBack(ShowCloseCallBack.class.getName(), this.getView().getPageId()));
            baseView = this.getView().getParentView();
        } else {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "agreementClose"));
            baseView = this.getView();
        }
        baseView.showForm(fsp);
        this.getView().sendFormAction(baseView);
    }

    private void showAboutCosmic() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_about_cosmic");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView baseView = this.getView().getParentView();
        baseView.showForm(showParameter);
        this.getView().sendFormAction(baseView);
    }
}

