/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.NodePropertyDesigner;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public abstract class AbstractGaiProcessSetPlugin
extends AbstractFormPlugin {
    protected static final String KEY_NAME = "name";
    private NodePropertyDesigner nodePropertyDesigner;

    protected NodePropertyDesigner getNodePropertyDesigner() {
        if (this.nodePropertyDesigner == null) {
            this.nodePropertyDesigner = new NodePropertyDesigner(this.getView());
        }
        return this.nodePropertyDesigner;
    }

    protected int getNodeId() {
        return this.getNodePropertyDesigner().getNodeId();
    }

    protected ProcessNodeType getNodeType() {
        return this.getNodePropertyDesigner().getNodeType();
    }

    protected Flow getFlow() {
        return this.getNodePropertyDesigner().getFlow();
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject objCacheEntity = this.getNodePropertyDesigner().loadEntityFromCache();
        if (objCacheEntity != null) {
            e.setDataEntity((Object)objCacheEntity);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setComboItem();
        this.getNodePropertyDesigner().initData();
    }

    public void destory() {
        super.destory();
        if (this.nodePropertyDesigner != null) {
            this.nodePropertyDesigner.release();
        }
    }

    protected void setComboItem() {
    }

    protected List<ComboItem> getComboItem(RefrenceDataConfig config) {
        List<RefrenceParam> refrenceParamList = this.getNodePropertyDesigner().getRefrenceParamManager().getCanRefrenceParamList(this.getNodePropertyDesigner().getNodeId(), config);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(refrenceParamList.size());
        for (RefrenceParam refrenceParam : refrenceParamList) {
            comboItemList.add(new ComboItem(new LocaleString(refrenceParam.getParamDisplayName()), refrenceParam.getParamValue()));
        }
        return comboItemList;
    }

    protected List<ComboItem> getComboItem() {
        return this.getComboItem(new RefrenceDataConfig());
    }

    protected void loadRefrenceParams(Action action, String entryKey, String nameKey, String refrenceParamKey) {
        List inputVar = action.getInParamMap();
        if (inputVar != null) {
            int count = this.getModel().getEntryRowCount(entryKey);
            for (int i = 0; i < count; ++i) {
                String name = (String)this.getModel().getValue(nameKey, i);
                VarMapper var = this.getVarMapper(name, inputVar);
                if (var == null) continue;
                String param = RefrenceParam.getParamValue(var.getOutNodeId(), var.getOutVarName());
                this.getModel().setValue(refrenceParamKey, (Object)param, i);
            }
        }
    }

    protected VarMapper getVarMapper(String name, List<VarMapper> inputVar) {
        if (inputVar == null) {
            return null;
        }
        for (VarMapper var : inputVar) {
            if (!var.getInVarName().equals(name)) continue;
            return var;
        }
        return null;
    }

    protected void sendNodeNameToCustomControl(String name) {
        this.getNodePropertyDesigner().sendModifyNameAction(name);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_NAME)) {
            ChangeData data = e.getChangeSet()[0];
            if (data.getNewValue() == null || StringUtils.isEmpty((CharSequence)data.getNewValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractGaiProcessSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.getModel().setValue(propertyName, data.getOldValue());
            } else {
                this.sendNodeNameToCustomControl(data.getNewValue().toString());
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getModel().setDataChanged(true);
    }

    public abstract NodeValidateInfo nodeValidate(ProcessNodeType var1, int var2);

    public abstract void saveDataToFlow(Flow var1);

    public abstract void initData();
}

