/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.plugin.AbstractGaiAssistantPlugin;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class GaiAssistantConfigPlugin
extends AbstractGaiAssistantPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(GaiAssistantConfigPlugin.class);
    private static final String SWITCH_VOICE = "switch_voice";
    private static final String COMBO_LLM = "llm";
    public static final String DO_SAVE_SKILL_LIST = "do_save_skill_mark";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getFormShowParameter().setCustomParam("slideEnv", (Object)SLIDEENV.ASSISTANT);
        Assistant assistant = AssistantService.getDefault();
        IBillModel model = (IBillModel)this.getModel();
        if (null == assistant) {
            log.error(Errors.ASSISTANT_IS_NONE_ERROR.getMessage());
            throw new KDBizException(Errors.ASSISTANT_IS_NONE_ERROR, new Object[0]);
        }
        model.load((Object)assistant.getId());
        String pic = assistant.getPicture();
        if (StringUtils.isEmpty((CharSequence)pic) || !pic.startsWith("http")) {
            String pictureUrl = UrlService.getDomainContextUrl() + "/kingdee/gai/images/pc/icon/Cosmic_48_48.png";
            this.getModel().setValue("picture", (Object)pictureUrl);
        }
        model.setValue("id", (Object)10000L);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String doSave = this.getView().getPageCache().get(DO_SAVE_SKILL_LIST);
            if (StringUtils.isEmpty((CharSequence)doSave)) {
                Map resultMap = ResultVoHelper.buildPreSaveSkillList();
                CustomControl customControl = (CustomControl)this.getControl("gpt_skill");
                customControl.setData((Object)resultMap);
                args.setCancel(true);
            }
            this.getView().getPageCache().put(DO_SAVE_SKILL_LIST, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView formView = this.getView();
        FormShowParameter parameter = formView.getFormShowParameter();
        parameter.setCustomParam("slideEnv", (Object)SLIDEENV.ASSISTANT);
        this.assistantFormInit(formView, null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{SWITCH_VOICE, "picture"});
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        if (key.equals("gpt_skill")) {
            this.invokeCustomEvent(eventName, eventArgs, key);
            return;
        }
        super.customEvent(e);
    }

    private void invokeCustomEvent(String eventName, String eventArgs, String controlKey) {
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName.trim());
        JSONObject requestData = JSON.parseObject((String)eventArgs);
        CustomControl customControl = (CustomControl)this.getControl(controlKey);
        Map resultMap = new HashMap();
        switch (requestActionType) {
            case doAddAgent: {
                JSONArray skillIdArr = requestData.getJSONArray("skillIdList");
                this.showSkillF7("gai_agent", skillIdArr);
                break;
            }
            case doAddProcess: {
                JSONArray processIdArr = requestData.getJSONArray("skillIdList");
                this.showSkillF7("gai_process", processIdArr);
                break;
            }
            case doSaveSkillList: {
                this.getView().getPageCache().put(DO_SAVE_SKILL_LIST, "true");
                String skillJsonArrString = requestData.getString("skillList");
                this.getView().getPageCache().put("skill_id_list_cache", skillJsonArrString);
                List skillList = (List)JSON.parseObject((String)skillJsonArrString, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]);
                Object introduce = this.getModel().getValue("introduce");
                if (introduce != null) {
                    String introduceString = (String)introduce;
                    this.getModel().setValue("introduce", (Object)GaiUtils.removeExtraNewLines((String)introduceString));
                }
                SkillService.clearAndSaveList((List)skillList);
                this.getView().invokeOperation("save");
                String chatSessionId = this.getChatSessionId();
                GaiUtils.newContextInSlide((IFormView)this.getView(), (String)chatSessionId);
                break;
            }
            case saveTempSkillList: {
                String skillJsonArrString = requestData.getString("skillList");
                this.getView().getPageCache().put("skill_id_list_cache", skillJsonArrString);
                break;
            }
            case getTempSkillList: {
                List<Skill> skillList = this.getTemList();
                resultMap = ResultVoHelper.buildProcessList(skillList);
                break;
            }
            case doNotSaveSkillList: {
                String errMsg = requestData.getString("msg");
                this.getView().showErrorNotification(errMsg);
                break;
            }
            default: {
                resultMap = new HashMap();
            }
        }
        if (!resultMap.isEmpty()) {
            customControl.setData(resultMap);
        }
    }

    public List<Skill> getTemList() {
        String temList = this.getView().getPageCache().get("skill_id_list_cache");
        List skillList = StringUtils.isNotEmpty((CharSequence)temList) ? (List)JSON.parseObject((String)temList, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]) : SkillService.getList(null, null, (boolean)true);
        return skillList;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.closedCallBack(event);
        if ((event.getActionId().equals(GaiFormIdEnum.GAI_AGENT.getId()) || event.getActionId().equals(GaiFormIdEnum.GAI_PROCESS.getId())) && (listSelectedRowCollection = (ListSelectedRowCollection)event.getReturnData()) != null && !listSelectedRowCollection.isEmpty()) {
            ArrayList<Long> selectedIdList = new ArrayList<Long>(listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                selectedIdList.add((Long)listSelectedRow.getPrimaryKeyValue());
            }
            PageQuery pageQuery = new PageQuery();
            pageQuery.setPageSize(Integer.valueOf(100));
            pageQuery.setIdList(selectedIdList);
            PageResult agentPage = AgentService.getAgentPage((PageQuery)pageQuery);
            List agentList = agentPage.getList();
            CustomControl customControl = (CustomControl)this.getControl("gpt_skill");
            List<Skill> skills = new ArrayList(10);
            if ("gai_agent".equals(event.getActionId())) {
                for (Agent agent : agentList) {
                    Skill skill = new Skill();
                    skill.setId(agent.getAgentId() + "");
                    skill.setName(agent.getName());
                    skill.setNumber(agent.getNumber());
                    skill.setType(Skill.Type.AGENT);
                    skill.setPicture(agent.getPicture());
                    skill.setBgColor(agent.getBgColor());
                    skill.setPrologue(agent.getPrologue());
                    skill.setServiceDes(agent.getDescription());
                    skills.add(skill);
                }
            } else {
                skills = ProcessService.getProcessByIds(selectedIdList);
            }
            customControl.setData((Object)ResultVoHelper.buildProcessList(skills));
        }
    }

    private void showSkillF7(String formId, JSONArray selectedIdJsonArr) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setShowApproved(true);
        lsp.setBillFormId(formId);
        lsp.setFormId("bos_listf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700px");
        inlineStyleCss.setWidth("1200px");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        lsp.setLookUp(true);
        List<QFilter> qFilters = Collections.singletonList(new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr()));
        lsp.getListFilterParameter().setQFilters(qFilters);
        lsp.setLookUp(true);
        Object[] idList = new Long[selectedIdJsonArr.size()];
        for (int i = 0; i < selectedIdJsonArr.size(); ++i) {
            idList[i] = selectedIdJsonArr.getLong(i);
        }
        lsp.setSelectedRows(idList);
        lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), formId));
        this.getView().showForm((FormShowParameter)lsp);
    }
}

