/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class GaiProcessMessageSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final String KEY_ENTRY_SHOW = "show";
    private static final String KEY_SHOW_NAME = "show_name";
    private static final String KEY_SHOW_TYPE = "show_type";
    private static final String KEY_SHOW_INPUT = "show_input";
    private static final String KEY_SHOW_ISINPUT = "show_isinput";
    private static final String KEY_SHOW_SOURCEPARAM = "show_sourceparam";
    private static final String KEY_REPLACE_LAST_MSG = "replace_last_msg";

    @Override
    protected void setComboItem() {
        List<ComboItem> paramItems = this.getComboItem();
        ComboEdit showSourceParam = (ComboEdit)this.getControl(KEY_SHOW_SOURCEPARAM);
        showSourceParam.setComboItems(paramItems);
        List<ComboItem> itemList = GaiProcessMessageSetPlugin.createMessageTypeComboItem();
        ComboEdit showTypeEdit = (ComboEdit)this.getControl(KEY_SHOW_TYPE);
        showTypeEdit.setComboItems(itemList);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int row = e.getRowDataEntities()[0].getRowIndex();
        String name = this.getName(row);
        this.getModel().setValue(KEY_SHOW_NAME, (Object)name, row);
        this.setSourceEnable();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int row = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_SHOW);
        if (KEY_SHOW_ISINPUT.equals(propertyName)) {
            Boolean isInput = (Boolean)this.getModel().getValue(KEY_SHOW_ISINPUT, row);
            if (isInput.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{KEY_SHOW_SOURCEPARAM});
                this.getView().setEnable(Boolean.TRUE, row, new String[]{KEY_SHOW_INPUT});
                this.getModel().setValue(KEY_SHOW_SOURCEPARAM, (Object)"");
            } else {
                this.getView().setEnable(Boolean.TRUE, row, new String[]{KEY_SHOW_SOURCEPARAM});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{KEY_SHOW_INPUT});
                this.getModel().setValue(KEY_SHOW_INPUT, (Object)"");
            }
        }
    }

    private String check() {
        DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_SHOW);
        if (shows != null) {
            int i = 1;
            for (DynamicObject show : shows) {
                boolean showInputs = show.getBoolean(KEY_SHOW_ISINPUT);
                String type = show.getString(KEY_SHOW_TYPE);
                String sourceParam = show.getString(KEY_SHOW_SOURCEPARAM);
                String input = show.getString(KEY_SHOW_INPUT);
                if (StringUtils.isBlank((CharSequence)type)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u53c2\u6570\u7c7b\u578b\u201d", (String)"GaiProcessMessageSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                if (showInputs) {
                    if (StringUtils.isBlank((CharSequence)input)) {
                        return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u624b\u5de5\u7ef4\u62a4\u5185\u5bb9\u201d", (String)"GaiProcessMessageSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                    }
                } else if (StringUtils.isBlank((CharSequence)sourceParam)) {
                    return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u6765\u6e90\u201d", (String)"GaiProcessMessageSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]), i);
                }
                ++i;
            }
        }
        return "";
    }

    private void clickMessage(Flow flow, int nodeId) {
        DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_SHOW);
        MessageAction messageAction = (MessageAction)flow.findActionById(nodeId);
        boolean replace = this.getModel().getDataEntity().getBoolean(KEY_REPLACE_LAST_MSG);
        messageAction.setReplaceLastMessage(replace);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (shows != null) {
            ArrayList<Var> varList = new ArrayList<Var>();
            for (DynamicObject row : shows) {
                String name = row.getString(KEY_SHOW_NAME);
                String showType = row.getString(KEY_SHOW_TYPE);
                String value = row.getString(KEY_SHOW_INPUT);
                boolean isInput = row.getBoolean(KEY_SHOW_ISINPUT);
                Var var = new Var(name, showType, "");
                var.setValue(value);
                var.setInput(isInput);
                varList.add(var);
                VarMapper varM = new VarMapper();
                String sourceParam = row.getString(KEY_SHOW_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split("#");
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            messageAction.setVarList(varList);
        }
        messageAction.setInParamMap(varMapper);
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        MessageAction messageAction = (MessageAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam("nodeId")).intValue());
        if (messageAction != null) {
            this.loadMessage(messageAction);
            this.loadRefrenceParams((Action)messageAction, KEY_ENTRY_SHOW, KEY_SHOW_NAME, KEY_SHOW_SOURCEPARAM);
            this.getView().updateView();
        }
        this.setSourceEnable();
    }

    private void loadMessage(MessageAction messageAction) {
        List varList;
        List list = varList = messageAction == null ? null : messageAction.getVarList();
        if (varList != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_SHOW);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_SHOW);
            shows.clear();
            List varMap = messageAction.getInParamMap();
            for (Var var : varList) {
                String name = var.getName();
                String type = var.getType();
                VarMapper varMapper = this.getVarMapper(name, varMap);
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_SHOW_NAME, (Object)name);
                row.set(KEY_SHOW_TYPE, (Object)type);
                row.set(KEY_SHOW_INPUT, (Object)var.getValue());
                row.set(KEY_SHOW_ISINPUT, (Object)var.isInput());
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_SHOW_SOURCEPARAM, (Object)param);
                }
                shows.add((Object)row);
            }
            this.getView().updateView(KEY_ENTRY_SHOW);
        }
        boolean replaceLastMessage = messageAction != null && messageAction.isReplaceLastMessage();
        this.getModel().setValue(KEY_REPLACE_LAST_MSG, (Object)replaceLastMessage);
    }

    private String getName(int row) {
        return String.format("message%s", row + 1);
    }

    private static List<ComboItem> createMessageTypeComboItem() {
        MessageType[] types = MessageType.values();
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (MessageType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getText()));
                comboItem.setValue(type.getValue());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.MESSAGE_TYPE_INIT_ERROR.getCode(), GaiErrorCode.MESSAGE_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    private void setSourceEnable() {
        DynamicObjectCollection shows = this.getModel().getEntryEntity(KEY_ENTRY_SHOW);
        if (shows != null) {
            int i = 0;
            for (DynamicObject show : shows) {
                boolean isInput = show.getBoolean(KEY_SHOW_ISINPUT);
                if (isInput) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_SHOW_INPUT});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_SHOW_SOURCEPARAM});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_SHOW_INPUT});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{KEY_SHOW_SOURCEPARAM});
                }
                ++i;
            }
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickMessage(flow, this.getNodeId());
    }
}

