/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class GaiProcessOperationSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessOperationSetPlugin.class);
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String KEY_ADV_INPUT = "inputadv";
    private static final String KEY_ADV_OUTPUT = "outputadv";
    private static final String KEY_ADV_BASE = "baseadv";
    private static final String KEY_SERVICENAME = "servicename";
    private static final String KEY_APP = "app";
    private static final String KEY_APPID = "appid";
    private static final String KEY_ACTION = "action";
    private static final String KEY_OPERATION = "operationtype";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_SOURCEPARAM = "output_sourceparam";
    private static final String SEPERATOR = "#";
    private static Set<String> systemVarList = new HashSet<String>();

    @Override
    protected void setComboItem() {
        List<ComboItem> paramItems = this.getComboItem();
        ComboEdit inputSourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        inputSourceParam.setComboItems(paramItems);
        ComboEdit outputSourceParam = (ComboEdit)this.getControl(KEY_OUTPUT_SOURCEPARAM);
        outputSourceParam.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(itemList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INPUT_MUSTINPUT, KEY_OUTPUT_SOURCEPARAM});
        if (this.getNodeType() == ProcessNodeType.Start) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADV_OUTPUT, KEY_ADV_BASE, KEY_INPUT_SOURCEPARAM});
            int count = this.getModel().getEntryRowCount(KEY_ENTRYENTITY_INPUT);
            for (int i = 0; i < count; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_SOURCEPARAM});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_INPUT_MUSTINPUT});
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        } else if (this.getNodeType() == ProcessNodeType.End) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADV_INPUT, KEY_ADV_BASE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_OUTPUT_SOURCEPARAM});
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        }
    }

    @Override
    public void initData() {
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        int type = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeType");
        ProcessNodeType nodeType = ProcessNodeType.valueOf((int)type);
        switch (nodeType) {
            case Start: {
                this.loadStart(flow);
                break;
            }
            case End: {
                this.loadEnd(flow);
                break;
            }
            case PresetOption: 
            case CusOption: {
                JavaPluginAction pluginAction = (JavaPluginAction)flow.findActionById(nodeId);
                if (pluginAction == null || pluginAction.getActionId() == 0L) break;
                this.getPageCache().put("actionId", pluginAction.getActionId() + "");
                this.loadOperation(pluginAction.getActionId());
                this.loadRefrenceParams((Action)pluginAction, KEY_ENTRYENTITY_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCEPARAM);
                this.getView().updateView();
                break;
            }
        }
    }

    private void loadOperation(long actionId) {
        DynamicObject operation = BusinessDataServiceHelper.loadSingle((Object)actionId, (String)ENTITY_OPERATION);
        if (operation != null) {
            this.getModel().setValue(KEY_SERVICENAME, (Object)operation.getString(KEY_SERVICENAME));
            this.getModel().setValue(KEY_APP, operation.get(KEY_APP));
            this.getModel().setValue(KEY_ACTION, (Object)operation.getString(KEY_ACTION));
            this.getModel().setValue(KEY_OPERATION, (Object)operation.getString(KEY_OPERATION));
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection curInputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            curInputs.clear();
            DynamicObjectCollection inputs = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_INPUT);
            if (inputs != null) {
                for (DynamicObject input : inputs) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)entryType);
                    obj.set(KEY_INPUT_NAME, (Object)input.getString(KEY_INPUT_NAME));
                    obj.set(KEY_INPUT_TYPE, (Object)input.getString(KEY_INPUT_TYPE));
                    obj.set(KEY_INPUT_DESC, (Object)input.getString(KEY_INPUT_DESC));
                    curInputs.add((Object)obj);
                }
            }
            EntryType outEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection curOutputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
            curOutputs.clear();
            DynamicObjectCollection outputs = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT);
            if (outputs != null) {
                for (DynamicObject output : outputs) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)outEntryType);
                    obj.set(KEY_OUTPUT_NAME, (Object)output.getString(KEY_OUTPUT_NAME));
                    obj.set(KEY_OUTPUT_TYPE, (Object)output.getString(KEY_OUTPUT_TYPE));
                    obj.set(KEY_OUTPUT_DESC, (Object)output.getString(KEY_OUTPUT_DESC));
                    curOutputs.add((Object)obj);
                }
            }
        }
    }

    private void loadStart(Flow flow) {
        List inputVar;
        List list = inputVar = flow == null ? null : flow.getStart().getInputVars();
        if (inputVar != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            inputs.clear();
            for (Var var : inputVar) {
                String name = var.getName();
                String type = var.getType();
                String desc = var.getDesc();
                if (systemVarList.contains(name)) continue;
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_INPUT_NAME, (Object)name);
                row.set(KEY_INPUT_TYPE, (Object)type);
                row.set(KEY_INPUT_DESC, (Object)desc);
                inputs.add((Object)row);
            }
            this.getView().updateView(KEY_ENTRYENTITY_INPUT);
        }
    }

    private void loadEnd(Flow flow) {
        List outputVar;
        List list = outputVar = flow == null ? null : flow.getEnd().getOutputVars();
        if (outputVar != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection outputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
            outputs.clear();
            List outputVarMap = flow.getEnd().getOutParamMap();
            for (Var var : outputVar) {
                String name = var.getName();
                String type = var.getType();
                String desc = var.getDesc();
                VarMapper varMapper = this.getVarMapper(name, outputVarMap);
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                row.set(KEY_OUTPUT_NAME, (Object)name);
                row.set(KEY_OUTPUT_TYPE, (Object)type);
                row.set(KEY_OUTPUT_DESC, (Object)desc);
                if (varMapper != null) {
                    String param = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
                    row.set(KEY_OUTPUT_SOURCEPARAM, (Object)param);
                }
                outputs.add((Object)row);
            }
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int row = e.getInsertRow();
        if (this.getNodeType() == ProcessNodeType.Start) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{KEY_INPUT_SOURCEPARAM});
        }
    }

    private String checkCusOperation() {
        String type;
        String className = (String)this.getModel().getValue(KEY_SERVICENAME);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP);
        String appid = app == null ? "" : app.getString("number");
        appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
        String action = (String)this.getModel().getValue(KEY_ACTION);
        if (app == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"GaiProcessOperationSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)className)) {
            return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u540d\u3002", (String)"GaiProcessOperationSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        Map ret = (Map)DispatchServiceHelper.invokeBOSService((String)appid, (String)"IGPTService", (String)"getObject", (Object[])new Object[]{className});
        int status = ret == null || ret.get("status") == null ? -1 : (Integer)ret.get("status");
        String string = type = ret == null || ret.get("type") == null ? "" : (String)ret.get("type");
        if (status == 0) {
            return ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7c7b\u540d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002", (String)"GaiProcessOperationSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        if (status == 1 && StringUtils.isBlank((CharSequence)type)) {
            return ResManager.loadKDString((String)"\u8f93\u5165\u7684\u7c7b\u540d\u672a\u5b9e\u73b0\u64cd\u4f5c\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002", (String)"GaiProcessOperationSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        this.setOperationType(ret);
        if (StringUtils.isBlank((CharSequence)action)) {
            return ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u64cd\u4f5c\u540d\u79f0\u3002", (String)"GaiProcessOperationSetPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }

    private boolean clickCusOperation(Flow flow, int nodeId) {
        DynamicObject newOperation = this.createCusOperation(flow);
        NodeConfigData nodeConfigData = new NodeConfigData();
        nodeConfigData.setNodeId(nodeId);
        nodeConfigData.setConfigViewPageId(this.getView().getPageId());
        nodeConfigData.setDataEntityToBase64(this.getModel().getDataEntity(true));
        nodeConfigData.setDataByDynamicObject(newOperation);
        this.getNodePropertyDesigner().getNodeDataManager().add(nodeConfigData);
        JavaPluginAction pluginAction = (JavaPluginAction)flow.findActionById(nodeId);
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (inputs != null) {
            for (DynamicObject input : inputs) {
                VarMapper varM = new VarMapper();
                String name = input.getString(KEY_INPUT_NAME);
                String sourceParam = input.getString(KEY_INPUT_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split(SEPERATOR);
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
        }
        pluginAction.setInParamMap(varMapper);
        return true;
    }

    private boolean clickStart(Flow flow) {
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        if (inputs != null) {
            ArrayList<Var> inputVars = new ArrayList<Var>();
            for (DynamicObject input : inputs) {
                String name = input.getString(KEY_INPUT_NAME);
                String inputType = input.getString(KEY_INPUT_TYPE);
                String desc = input.getString(KEY_INPUT_DESC);
                if (StringUtils.isNotBlank((CharSequence)name) && systemVarList.contains(name.toLowerCase())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e3a\u9884\u7f6e\u53d8\u91cf\uff0c\u4e0d\u5141\u8bb8\u8f93\u5165\u3002", (String)"GaiProcessOperationSetPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]), name));
                    return false;
                }
                Var var = new Var(name, inputType, desc);
                inputVars.add(var);
            }
            flow.getStart().setInputVars(inputVars);
            this.initSystemVar(flow);
        }
        return true;
    }

    private void clickEnd(Flow flow) {
        DynamicObjectCollection outputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (outputs != null) {
            ArrayList<Var> outputVars = new ArrayList<Var>();
            for (DynamicObject output : outputs) {
                String name = output.getString(KEY_OUTPUT_NAME);
                String outputType = output.getString(KEY_OUTPUT_TYPE);
                String desc = output.getString(KEY_OUTPUT_DESC);
                outputVars.add(new Var(name, outputType, desc));
                VarMapper varM = new VarMapper();
                String sourceParam = output.getString(KEY_OUTPUT_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split(SEPERATOR);
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
            flow.getEnd().setOutputVars(outputVars);
        }
        flow.getEnd().setOutParamMap(varMapper);
    }

    private DynamicObject createCusOperation(Flow flow) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY_OPERATION);
        DynamicObject operation = new DynamicObject((DynamicObjectType)dt);
        Long actionId = ((JavaPluginAction)flow.findActionById(this.getNodeId())).getActionId();
        if (actionId != 0L) {
            operation = BusinessDataServiceHelper.loadSingle((Object)actionId, (DynamicObjectType)dt);
        }
        String serviceName = (String)this.getModel().getValue(KEY_SERVICENAME);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP);
        String appid = app == null ? "" : app.getString("number");
        appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
        String action = (String)this.getModel().getValue(KEY_ACTION);
        String operationType = (String)this.getModel().getValue(KEY_OPERATION);
        operation.set(KEY_SERVICENAME, (Object)serviceName.trim());
        operation.set(KEY_APP, (Object)app);
        operation.set(KEY_APPID, (Object)appid);
        operation.set(KEY_ACTION, (Object)action.trim());
        operation.set(KEY_OPERATION, (Object)operationType);
        operation.set("ispreset", (Object)Boolean.FALSE);
        operation.set("enable", (Object)"1");
        operation.set("status", (Object)"A");
        operation.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection input = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_INPUT);
        input.clear();
        DynamicObjectCollection curInput = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        if (curInput != null) {
            for (DynamicObject cur : curInput) {
                DynamicObject obj = new DynamicObject(input.getDynamicObjectType());
                obj.set(KEY_INPUT_NAME, (Object)cur.getString(KEY_INPUT_NAME));
                obj.set(KEY_INPUT_TYPE, (Object)cur.getString(KEY_INPUT_TYPE));
                obj.set(KEY_INPUT_DESC, (Object)cur.getString(KEY_INPUT_DESC));
                input.add((Object)obj);
            }
        }
        DynamicObjectCollection output = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT);
        output.clear();
        DynamicObjectCollection curOutput = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        if (curOutput != null) {
            for (DynamicObject cur : curOutput) {
                DynamicObject obj = new DynamicObject(output.getDynamicObjectType());
                obj.set(KEY_OUTPUT_NAME, (Object)cur.getString(KEY_OUTPUT_NAME));
                obj.set(KEY_OUTPUT_TYPE, (Object)cur.getString(KEY_OUTPUT_TYPE));
                obj.set(KEY_OUTPUT_DESC, (Object)cur.getString(KEY_OUTPUT_DESC));
                output.add((Object)obj);
            }
        }
        return operation;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_SERVICENAME.equals(propertyName) || KEY_APP.equals(propertyName)) {
            String className = (String)this.getModel().getValue(KEY_SERVICENAME);
            DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP);
            if (StringUtils.isNotBlank((CharSequence)className) && app != null) {
                String appid = app.getString("number");
                appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
                try {
                    Map ret = (Map)DispatchServiceHelper.invokeBOSService((String)appid, (String)"IGPTService", (String)"getObject", (Object[])new Object[]{className});
                    this.setOperationType(ret);
                }
                catch (Exception e2) {
                    log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e2), (Throwable)e2);
                }
            }
        }
        if (propertyName.equals(KEY_INPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateInputOrOutputValsName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        }
        if (propertyName.equals(KEY_OUTPUT_NAME)) {
            data = e.getChangeSet()[0];
            this.validateInputOrOutputValsName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        }
    }

    private void validateInputOrOutputValsName(String propertyName, String entityName, ChangeData data) {
        DynamicObjectCollection rows;
        if (data.getNewValue() == null || StringUtils.isEmpty((CharSequence)data.getNewValue().toString())) {
            return;
        }
        String newValue = data.getNewValue().toString();
        if (StringUtils.isNotBlank((CharSequence)newValue) && systemVarList.contains(newValue.toLowerCase())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e3a\u9884\u7f6e\u53d8\u91cf\uff0c\u4e0d\u5141\u8bb8\u8f93\u5165\u3002", (String)"GaiProcessOperationSetPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]), newValue));
            this.getModel().setValue(propertyName, data.getOldValue());
        }
        if (!(rows = this.getModel().getEntryEntity(entityName)).isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                if (data.getRowIndex() == i || !((DynamicObject)rows.get(i)).getString(propertyName).equals(newValue)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u8282\u70b9\u7684\u53c2\u6570\u540d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"GaiProcessOperationSetPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.getModel().setValue(propertyName, data.getOldValue());
                break;
            }
        }
    }

    private void setOperationType(Map<String, Object> ret) {
        String type;
        String string = type = ret == null ? "" : (String)ret.get("type");
        if ("IGPTFormAction".equals(type)) {
            type = "0";
        } else if ("IGPTAction".equals(type)) {
            type = "1";
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            this.getModel().setValue(KEY_OPERATION, (Object)type);
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        String sMessage;
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        if (noteType == ProcessNodeType.CusOption && StringUtils.isNotEmpty((CharSequence)(sMessage = this.checkCusOperation()))) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        ProcessNodeType nodeType = this.getNodeType();
        int nodeId = this.getNodeId();
        switch (nodeType) {
            case Start: {
                this.clickStart(flow);
                break;
            }
            case End: {
                this.clickEnd(flow);
                break;
            }
            case CusOption: {
                this.clickCusOperation(flow, nodeId);
            }
        }
    }

    protected void initSystemVar(Flow flow) {
        ArrayList<Var> inputVars = flow.getStart().getInputVars();
        if (inputVars == null) {
            inputVars = new ArrayList<Var>(10);
        }
        if (!this.containsVar((List<Var>)inputVars, "system.chat_sessionid")) {
            inputVars.add(0, new Var("system.chat_sessionid", VarFieldType.STRING.getType(), RefrenceParam.getSystemChatsessionDesc()));
        }
        if (!this.containsVar(inputVars, "system.chat_history")) {
            inputVars.add(0, new Var("system.chat_history", VarFieldType.STRING.getType(), RefrenceParam.getSystemChathistoryDesc()));
        }
        if (!this.containsVar(inputVars, "system.user_input")) {
            inputVars.add(0, new Var("system.user_input", VarFieldType.STRING.getType(), RefrenceParam.getSystemUserinputDesc()));
        }
        flow.getStart().setInputVars(inputVars);
    }

    private boolean containsVar(List<Var> inputVars, String key) {
        if (inputVars == null || inputVars.isEmpty() || StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        for (Var var : inputVars) {
            if (!key.equals(var.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        systemVarList.add("system.user_input");
        systemVarList.add("system.chat_history");
        systemVarList.add("user_input");
        systemVarList.add("system.chat_sessionid");
    }
}

