/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.Date;
import java.util.EventObject;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.flow.FlowDesigner;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ValidateService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;

public class GaiProcessPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(GaiProcessPlugin.class);
    private static final String KEY_SPLITCONTAINERAP = "splitcontainerap";
    private static final String KEY_SPLITPANELAP_RIGHT = "splitpanelap_right";
    private static final String KEY_ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String KEY_TBMAIN = "tbmain";
    private static final String KEY_COLLAPSE = "vectorapcollapse";
    private static final String OP_SAVE = "saveprocess";
    private static final String OPERATION_KEY_ENABLE = "enable";
    private static final String OPERATION_KEY_DISABLE = "disable";
    private FlowDesigner flowDesigner;

    private FlowDesigner getFlowDesigner() {
        if (this.flowDesigner == null) {
            this.flowDesigner = new FlowDesigner(this.getView());
        }
        return this.flowDesigner;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ADVCONTOOLBARAP, KEY_TBMAIN});
        this.addClickListeners(new String[]{KEY_COLLAPSE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getFlowDesigner().initFlow();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getFlowDesigner().lockFlow();
        this.getFlowDesigner().getEditingContext().getService(ViewService.class).setCurrentEditFlow();
    }

    public void destory() {
        super.destory();
        if (this.flowDesigner != null) {
            this.flowDesigner.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (key.equals("ai_gai_gpt_flow")) {
            logger.info(String.format("traceid=%s,customEvent-beforelock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
            DLock mylock = DLock.createReentrant((String)this.getView().getPageId());
            mylock.lock();
            try {
                logger.info(String.format("traceid=%s,customEvent-before-invokeEvent,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
                this.getView().addService(IPageCache.class, (Object)new PageCache(this.getView().getPageId()));
                this.getFlowDesigner().handleFlowEvent(eventName, eventArgs);
                logger.info(String.format("traceid=%s,customEvent-after-invokeEvent,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
            }
            catch (Throwable throwable) {
                mylock.unlock();
                mylock.close();
                logger.info(String.format("traceid=%s,customEvent-afterunlock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
                throw throwable;
            }
            mylock.unlock();
            mylock.close();
            logger.info(String.format("traceid=%s,customEvent-afterunlock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (OP_SAVE.equals(evt.getOperationKey())) {
            boolean iscancel = this.getFlowDesigner().getEditingContext().getService(ValidateService.class).validateFlow();
            if (iscancel) {
                evt.setCancel(true);
                return;
            }
            CustomControlAction action = new CustomControlAction("saveFlow");
            this.getFlowDesigner().getEditingContext().getService(FlowActionService.class).sendAction(action);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_COLLAPSE)) {
            SplitContainer splitContainer = (SplitContainer)this.getControl(KEY_SPLITCONTAINERAP);
            splitContainer.setCollapse(KEY_SPLITPANELAP_RIGHT, true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "enable": 
            case "disable": {
                if (!this.getModel().getDataChanged()) break;
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6d41\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"GaiProcessPlugin_22", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                args.setCancelMessage(message);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "enable": 
            case "disable": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getFlowDesigner().lockFlow();
            }
        }
    }
}

