/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class GaiProcessPromptSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final String KEY_PROMPTINFO = "promptinfo";
    private static final String KEY_USERINPUT_PARAM = "userinput";
    private static final String KEY_DY_REPO = "dyrepo";
    private static final String KEY_SHOWMESSAGE = "showmessage";
    private static final String KEY_MERGE_SHOW = "merge_show";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_ENTRYENTITY_VARCONFIG = "var_configs";
    private static final String KEY_ENTRYENTITY_OUTVARCONFIG = "out_var_configs";
    private static final String SEPERATOR = "#";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    protected void setComboItem() {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserInput(false);
        config.setAddCharHistory(false);
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit sourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        sourceParam.setComboItems(paramItems);
        config.setAddUserInput(true);
        config.setAddCharHistory(true);
        paramItems = this.getComboItem(config);
        ComboEdit userInputEdit = (ComboEdit)this.getControl(KEY_USERINPUT_PARAM);
        userInputEdit.setComboItems(paramItems);
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        ArrayList<String> paramTypeList = new ArrayList<String>(1);
        paramTypeList.add("String");
        config.setAddCharHistory(false);
        config.setAddUserInput(false);
        config.setOnlyNodeTypeList(nodeTypeList);
        config.setOnlyParamTypeList(paramTypeList);
        paramItems = this.getComboItem(config);
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_REPO);
        dyRepo.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(itemList);
    }

    @Override
    public void initData() {
        String userInputVal;
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        LLMAction llmAction = (LLMAction)flow.findActionById(nodeId);
        long promptId = llmAction.getLlmPromptId();
        boolean isStream = llmAction.isStream();
        VarMapper userInputVarMap = llmAction.getUserInputMapper();
        VarMapper dyRepoVarMap = llmAction.getRepoMapper();
        if (userInputVarMap != null) {
            userInputVal = RefrenceParam.getParamValue(userInputVarMap.getOutNodeId(), userInputVarMap.getOutVarName());
            this.getModel().setValue(KEY_USERINPUT_PARAM, (Object)userInputVal);
        } else {
            this.getModel().setValue(KEY_USERINPUT_PARAM, (Object)RefrenceParam.getParamValue(flow.getStart().getId(), "system.user_input"));
        }
        if (dyRepoVarMap != null) {
            userInputVal = RefrenceParam.getParamValue(dyRepoVarMap.getOutNodeId(), dyRepoVarMap.getOutVarName());
            this.getModel().setValue(KEY_DY_REPO, (Object)userInputVal);
        } else {
            this.getModel().setValue(KEY_DY_REPO, null);
        }
        boolean merge = llmAction.isMergeLastMessageCard();
        this.getModel().setValue(KEY_PROMPTINFO, (Object)promptId);
        this.getModel().setValue(KEY_SHOWMESSAGE, (Object)isStream);
        this.getModel().setValue(KEY_MERGE_SHOW, (Object)merge);
        this.fillInput();
        List inputVar = llmAction.getInParamMap();
        if (inputVar != null) {
            int count = this.getModel().getEntryRowCount(KEY_ENTRYENTITY_INPUT);
            for (int i = 0; i < count; ++i) {
                String name = (String)this.getModel().getValue(KEY_INPUT_NAME, i);
                VarMapper var = this.getVarMapper(name, inputVar);
                if (var == null) continue;
                String param = RefrenceParam.getParamValue(var.getOutNodeId(), var.getOutVarName());
                this.getModel().setValue(KEY_INPUT_SOURCEPARAM, (Object)param, i);
            }
        }
        this.getView().updateView();
    }

    private void clickGPTPrompt(Flow flow, int nodeId) {
        LLMAction llmAction = (LLMAction)flow.findActionById(nodeId);
        DynamicObject serviceInfo = (DynamicObject)this.getModel().getValue(KEY_PROMPTINFO);
        if (serviceInfo != null) {
            llmAction.setLlmPromptId(serviceInfo.getLong("id"));
        }
        boolean showMessage = (Boolean)this.getModel().getValue(KEY_SHOWMESSAGE);
        llmAction.setStream(showMessage);
        boolean mergeShow = (Boolean)this.getModel().getValue(KEY_MERGE_SHOW);
        llmAction.setMergeLastMessageCard(mergeShow);
        String userInputParam = (String)this.getModel().getValue(KEY_USERINPUT_PARAM);
        VarMapper userInputMapper = this.buildVarMapper(userInputParam, "");
        llmAction.setUserInputMapper(userInputMapper);
        String dyRepo = (String)this.getModel().getValue(KEY_DY_REPO);
        VarMapper llmMapper = this.buildVarMapper(dyRepo, "");
        llmAction.setRepoMapper(llmMapper);
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (inputs != null) {
            for (DynamicObject input : inputs) {
                String name = input.getString(KEY_INPUT_NAME);
                String sourceParam = input.getString(KEY_INPUT_SOURCEPARAM);
                VarMapper varM = this.buildVarMapper(sourceParam, name);
                if (varM == null) continue;
                varMapper.add(varM);
            }
        }
        llmAction.setInParamMap(varMapper);
    }

    private VarMapper buildVarMapper(String sourceParam, String name) {
        if (StringUtils.isNotBlank((CharSequence)sourceParam)) {
            VarMapper varM = new VarMapper();
            String[] arr = sourceParam.split(SEPERATOR);
            int selNodeId = Integer.parseInt(arr[0]);
            String param = arr[1];
            varM.setInVarName(name);
            varM.setOutNodeId(selNodeId);
            varM.setOutVarName(param);
            return varM;
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_PROMPTINFO.equals(propertyName)) {
            this.fillInput();
        }
    }

    private void fillInput() {
        DynamicObject serviceInfo = (DynamicObject)this.getModel().getValue(KEY_PROMPTINFO);
        if (serviceInfo != null) {
            EntryType inEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection input = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            input.clear();
            DynamicObjectCollection preRows = serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_VARCONFIG);
            if (preRows != null && !preRows.isEmpty()) {
                int index = 0;
                for (DynamicObject row : preRows) {
                    DynamicObject inputRow = new DynamicObject((DynamicObjectType)inEntryType);
                    String name = row.getString("var");
                    String type = row.getString("var_type");
                    inputRow.set(KEY_INPUT_NAME, (Object)name);
                    inputRow.set(KEY_INPUT_TYPE, (Object)type);
                    input.add((Object)inputRow);
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{KEY_INPUT_TYPE, KEY_INPUT_NAME});
                    ++index;
                }
            }
            this.getView().updateView(KEY_ENTRYENTITY_INPUT);
            EntryType outEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection output = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
            output.clear();
            DynamicObjectCollection outRows = serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTVARCONFIG);
            if (outRows != null && !outRows.isEmpty()) {
                int index = 0;
                for (DynamicObject row : outRows) {
                    DynamicObject outputRow = new DynamicObject((DynamicObjectType)outEntryType);
                    String name = row.getString("out_var");
                    String type = row.getString("out_var_type");
                    outputRow.set(KEY_OUTPUT_NAME, (Object)name);
                    outputRow.set(KEY_OUTPUT_TYPE, (Object)type);
                    output.add((Object)outputRow);
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{KEY_OUTPUT_TYPE, KEY_OUTPUT_NAME});
                    ++index;
                }
            }
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        String sMessage = this.check();
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickGPTPrompt(flow, this.getNodeId());
    }

    private String check() {
        if (this.getModel().getValue(KEY_PROMPTINFO) == null) {
            return ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        if (this.getModel().getValue(KEY_USERINPUT_PARAM) == null) {
            return ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
        }
        return "";
    }
}

