/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiProcessSysOperationSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static Log log = LogFactory.getLog(GaiProcessSysOperationSetPlugin.class);
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String KEY_OPERATION_SELECT = "operation";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_OUTPUT_SOURCEPARAM = "output_sourceparam";
    private static final String SEPERATOR = "#";

    @Override
    protected void setComboItem() {
        List<ComboItem> paramItems = this.getComboItem();
        ComboEdit inputSourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        inputSourceParam.setComboItems(paramItems);
        ComboEdit outputSourceParam = (ComboEdit)this.getControl(KEY_OUTPUT_SOURCEPARAM);
        outputSourceParam.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(itemList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setForm();
    }

    @Override
    public void initData() {
        int nodeId;
        Flow flow = this.getFlow();
        JavaPluginAction pluginAction = (JavaPluginAction)flow.findActionById(nodeId = ((Integer)this.getView().getFormShowParameter().getCustomParam("nodeId")).intValue());
        if (pluginAction != null && pluginAction.getActionId() != 0L) {
            this.getPageCache().put("actionId", pluginAction.getActionId() + "");
            this.getModel().setValue(KEY_OPERATION_SELECT, (Object)pluginAction.getActionId());
            this.loadOperation();
            this.loadRefrenceParams((Action)pluginAction, KEY_ENTRYENTITY_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCEPARAM);
            this.getView().updateView();
        }
    }

    private void loadOperation() {
        DynamicObject operation = (DynamicObject)this.getModel().getValue(KEY_OPERATION_SELECT);
        if (operation != null) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection curInputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            curInputs.clear();
            DynamicObjectCollection inputs = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_INPUT);
            if (inputs != null) {
                for (DynamicObject input : inputs) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)entryType);
                    obj.set(KEY_INPUT_NAME, (Object)input.getString(KEY_INPUT_NAME));
                    obj.set(KEY_INPUT_TYPE, (Object)input.getString(KEY_INPUT_TYPE));
                    obj.set(KEY_INPUT_DESC, (Object)input.getString(KEY_INPUT_DESC));
                    curInputs.add((Object)obj);
                }
            }
            EntryType outEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
            this.getModel().getDataEntity(true);
            DynamicObjectCollection curOutputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
            curOutputs.clear();
            DynamicObjectCollection outputs = operation.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT);
            if (outputs != null) {
                for (DynamicObject output : outputs) {
                    DynamicObject obj = new DynamicObject((DynamicObjectType)outEntryType);
                    obj.set(KEY_OUTPUT_NAME, (Object)output.getString(KEY_OUTPUT_NAME));
                    obj.set(KEY_OUTPUT_TYPE, (Object)output.getString(KEY_OUTPUT_TYPE));
                    obj.set(KEY_OUTPUT_DESC, (Object)output.getString(KEY_OUTPUT_DESC));
                    curOutputs.add((Object)obj);
                }
            }
        }
    }

    private void clickOperation(Flow flow, int nodeId) {
        Long pkId;
        JavaPluginAction pluginAction = (JavaPluginAction)flow.findActionById(nodeId);
        DynamicObject operation = (DynamicObject)this.getModel().getValue(KEY_OPERATION_SELECT);
        Long l = pkId = operation == null ? null : (Long)operation.getPkValue();
        if (pkId != null) {
            this.getPageCache().put("actionId", pkId + "");
            pluginAction.setActionId(pkId.longValue());
        }
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
        if (inputs != null) {
            for (DynamicObject input : inputs) {
                VarMapper varM = new VarMapper();
                String name = input.getString(KEY_INPUT_NAME);
                String sourceParam = input.getString(KEY_INPUT_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split(SEPERATOR);
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMapper.add(varM);
            }
        }
        pluginAction.setInParamMap(varMapper);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (KEY_OPERATION_SELECT.equals(e.getProperty().getName())) {
            this.loadOperation();
            this.getView().updateView(KEY_ENTRYENTITY_INPUT);
            this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
        }
    }

    private void setForm() {
        DynamicObjectCollection outputs;
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        if (inputs != null) {
            for (int i = 0; i < inputs.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_NAME, KEY_INPUT_TYPE, KEY_INPUT_DESC, KEY_INPUT_MUSTINPUT, KEY_OUTPUT_NAME, KEY_OUTPUT_DESC, KEY_OUTPUT_TYPE, KEY_OUTPUT_SOURCEPARAM});
            }
        }
        if ((outputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT)) != null) {
            for (int i = 0; i < outputs.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_INPUT_NAME, KEY_INPUT_TYPE, KEY_INPUT_DESC, KEY_INPUT_MUSTINPUT, KEY_OUTPUT_NAME, KEY_OUTPUT_DESC, KEY_OUTPUT_TYPE, KEY_OUTPUT_SOURCEPARAM});
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INPUT_MUSTINPUT, KEY_OUTPUT_SOURCEPARAM});
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickOperation(flow, this.getNodeId());
    }
}

