/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.EventObject;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.service.PromptService;
import kd.ai.gai.core.util.Encrypt;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiPromptEncryptPlugin
extends AbstractFormPlugin {
    private static final String KEY_PROMPT = "prompt";
    private static final String KEY_PROMPT_TEXT = "prompttext";
    private static final String KEY_CIPHER_TEXT = "ciphertext";
    private static final String KEY_CANCEL = "exit";
    private static final String KEY_OK = "ok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_CANCEL, KEY_OK});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject prompt;
        String propertyName = e.getProperty().getName();
        if (KEY_PROMPT.equals(propertyName) && (prompt = (DynamicObject)this.getModel().getValue(KEY_PROMPT)) != null) {
            String text = prompt.getString(KEY_PROMPT);
            String cipherText = "";
            boolean isEncrypted = prompt.getBoolean("isencrypted");
            if (isEncrypted) {
                text = "\u6539\u63d0\u793a\u8bcd\u5df2\u88ab\u52a0\u5bc6";
            }
            this.getModel().setValue(KEY_PROMPT_TEXT, (Object)text);
            this.getModel().setValue(KEY_CIPHER_TEXT, (Object)cipherText);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "exit": {
                this.getView().close();
                break;
            }
            case "ok": {
                if (!this.check()) break;
                this.encrypt();
            }
        }
    }

    private void encrypt() {
        Boolean replace = (Boolean)this.getModel().getValue("prompt_replace");
        DynamicObject promptObj = (DynamicObject)this.getModel().getValue(KEY_PROMPT);
        Prompt prompt = PromptService.getById((long)((Long)promptObj.getPkValue()));
        String ciphertext = Encrypt.encrypt((Prompt)prompt);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)promptObj.getPkValue(), (String)"gai_prompt");
        if (obj != null) {
            obj.set("prompt_tag", (Object)ciphertext);
            obj.set("ispreset", (Object)Boolean.TRUE);
            obj.set("isencrypted", (Object)Boolean.TRUE);
        }
        this.getModel().setValue(KEY_CIPHER_TEXT, (Object)ciphertext);
        if (replace.booleanValue()) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            this.getModel().setValue(KEY_PROMPT_TEXT, (Object)"\u8be5\u63d0\u793a\u8bcd\u5df2\u88ab\u52a0\u5bc6");
        }
    }

    private boolean check() {
        DynamicObject prompt = (DynamicObject)this.getModel().getValue(KEY_PROMPT);
        if (prompt == null) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9GPT\u63d0\u793a\u3002");
            return false;
        }
        String text = (String)this.getModel().getValue(KEY_PROMPT_TEXT);
        if (StringUtils.isBlank((CharSequence)text)) {
            this.getView().showTipNotification("GPT\u63d0\u793a\u7684\u63d0\u793a\u8bcd\u4e3a\u7a7a\uff0c\u65e0\u9700\u52a0\u5bc6\u3002");
            return false;
        }
        boolean isEncrypted = prompt.getBoolean("isencrypted");
        if (isEncrypted) {
            this.getView().showTipNotification("GPT\u63d0\u793a\u7684\u63d0\u793a\u8bcd\u5df2\u52a0\u5bc6\uff0c\u65e0\u9700\u52a0\u5bc6\u3002");
            return false;
        }
        return true;
    }
}

