/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.dto.PromptOutVar;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.StopStreamMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.PromptTestCallbackMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.enuz.OutPreVar;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.field.type.OutFieldType;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GaiPromptPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static Log logger = LogFactory.getLog(GaiPromptPlugin.class);
    private static final String toolbar = "tbmain";
    private static final String bar_save = "bar_save";
    private static final String bar_run = "bar_run";
    private static final String getChatInfo = "getChatInfo";
    private static final String key_prompt_encrypted_context = "prompt_encrypted_context";
    private static final int entry_max_size = 5;
    private static final String regex = "^[a-zA-Z0-9_]+$";

    public void registerListener(EventObject e) {
        Toolbar tbmain = (Toolbar)this.getView().getControl(toolbar);
        tbmain.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{bar_run});
    }

    public void afterBindData(EventObject e) {
        DynamicObject entity = this.getModel().getDataEntity(true);
        Object pkValue = entity.getPkValue();
        boolean exists = QueryServiceHelper.exists((String)"gai_prompt", (Object)pkValue);
        if (!exists) {
            long pkId = ORM.create().genLongId("gai_prompt");
            entity.set("id", (Object)pkId);
            this.getView().updateView("gai_prompt");
        }
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem();
        ComboEdit languageModel = (ComboEdit)this.getView().getControl("language_model");
        languageModel.setComboItems(comboItems);
        List varTypeComboItem = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit varType = (ComboEdit)this.getView().getControl("var_type");
        varType.setComboItems(varTypeComboItem);
        ComboEdit outVarType = (ComboEdit)this.getView().getControl("out_var_type");
        outVarType.setComboItems(varTypeComboItem);
        DynamicObjectCollection outVars = this.getModel().getEntryEntity("out_var_configs");
        if (Objects.nonNull(outVars)) {
            if (outVars.size() == 0) {
                this.setOutPreVar();
            } else {
                for (int i = 0; i < outVars.size(); ++i) {
                    String outVar = ((DynamicObject)outVars.get(i)).getString("out_var");
                    if (OutPreVar.GPT_OUTPUT.getVar().equalsIgnoreCase(outVar)) {
                        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"out_var", "out_var_name", "out_var_type"});
                        continue;
                    }
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"out_json_analysis"});
                }
            }
        }
        DynamicObjectCollection docs = this.getModel().getEntryEntity("prompt_repo_config");
        for (int i = 0; i < docs.size(); ++i) {
            DynamicObject ddoc = ((DynamicObject)docs.get(i)).getDynamicObject("repoid");
            Object repoId = ddoc.getPkValue();
            DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", repoId)});
            this.getModel().setValue("doc_total", (Object)repo.getInt("file_total"), i);
        }
        this.injectInfo();
        this.setStatus();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "var_configs": {
                this.injectInfo();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof NewEntry) {
            String entityId;
            switch (entityId = ((NewEntry)source).getEntityId()) {
                case "var_configs": {
                    int customSize;
                    DynamicObjectCollection customRows = this.getView().getModel().getEntryEntity("var_configs");
                    int totalSize = customSize = Objects.nonNull(customRows) ? customRows.size() : 0;
                    if (totalSize < 5) break;
                    this.getView().showTipNotification("\u53d8\u91cf\u4e2a\u6570\u9650\u52365\u4e2a\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u6dfb\u52a0\u3002");
                    args.setCancel(true);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "repoid": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("prompt_repo_config");
                DynamicObjectCollection repos = this.getModel().getDataEntity(true).getDynamicObjectCollection("prompt_repo_config");
                DynamicObject doc = (DynamicObject)repos.get(rowIndex);
                DynamicObject repoInfo = doc.getDynamicObject("repoid");
                Object repoId = doc.getDynamicObject("repoid").getPkValue();
                DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", repoId)});
                this.getModel().setValue("doc_total", (Object)repo.getInt("file_total"), rowIndex);
                if (repoInfo == null) break;
                this.getModel().setValue("repotype", (Object)repoInfo.getString("type"));
                break;
            }
            case "var": 
            case "var_name": {
                this.injectInfo();
                break;
            }
            case "out_var": {
                DynamicObjectCollection outEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_var_configs");
                if (!Objects.nonNull(outEntrys)) break;
                HashSet<String> outVarSet = new HashSet<String>(outEntrys.size());
                Pattern pattern = Pattern.compile(regex);
                for (DynamicObject out : outEntrys) {
                    String outVar = out.getString("out_var");
                    if (!this.checkVar(true, pattern, outVarSet, outVar)) continue;
                    outEntrys.remove((Object)out);
                    this.getView().updateView("out_var_configs");
                    return;
                }
                int rowIndex = this.getModel().getEntryCurrentRowIndex("out_var_configs");
                String currenOutVar = (String)this.getModel().getValue("out_var", rowIndex);
                if (!OutPreVar.GPT_OUTPUT.getVar().equalsIgnoreCase(currenOutVar)) break;
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"out_json_analysis"});
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldName = e.getKey();
        if ("language_model".equals(fieldName)) {
            String language_model = (String)e.getValue();
            List instanceList = AiccService.getAiccInstanceList();
            if (!instanceList.contains(language_model)) {
                this.getView().updateView(fieldName);
                e.setCancel(true);
                this.getView().showConfirm("\u672a\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u8fdb\u5165\u3010AI\u80fd\u529b\u4e2d\u5fc3\u3011\u2192\u3010\u670d\u52a1\u5b9e\u4f8b\u3011\u5217\u8868\u4e2d\u914d\u7f6e\u6a21\u578bAPI\u53c2\u6570\u3002", MessageBoxOptions.OK);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "out_var_configs": {
                RowDataEntity[] rows;
                for (RowDataEntity row : rows = e.getRowDataEntities()) {
                    int rowIndex = row.getRowIndex();
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"out_json_analysis"});
                }
                break;
            }
        }
    }

    private void injectInfo() {
        HashMap<String, String> varMap = new HashMap<String, String>(5);
        DynamicObjectCollection custVars = this.getModel().getEntryEntity("var_configs");
        if (Objects.nonNull(custVars)) {
            for (DynamicObject custVar : custVars) {
                String var = custVar.getString("var");
                String varName = custVar.getString("var_name");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)var) || !kd.bos.util.StringUtils.isNotEmpty((String)varName)) continue;
                varMap.put(var, varName);
            }
        }
        Map sendVarMapData = ResultVoHelper.buildInjectInfo(varMap);
        this.sendCustom(sendVarMapData);
        GaiUtils.newContextInPrompt((IFormView)this.getView());
    }

    private void setOutPreVar() {
        this.getModel().batchCreateNewEntryRow("out_var_configs", 1);
        this.getModel().setValue("out_var", (Object)OutPreVar.GPT_OUTPUT.getVar(), 0);
        this.getModel().setValue("out_var_name", (Object)OutPreVar.GPT_OUTPUT.getName(), 0);
        this.getModel().setValue("out_var_type", (Object)OutPreVar.GPT_OUTPUT.getType().getType(), 0);
        this.getModel().setValue("out_json_analysis", (Object)0, 0);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"out_var", "out_var_name", "out_var_type"});
        this.getView().updateView("out_var_configs");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": {
                if (this.checkVarAll(true)) {
                    evt.setCancel(true);
                    return;
                }
                DynamicObjectCollection outEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_var_configs");
                if (Objects.nonNull(outEntrys) && outEntrys.size() == 0) {
                    String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53d8\u91cf\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u3002", (String)"GaiServiceInfoPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    evt.setCancel(true);
                    return;
                }
                if (this.checkRepo()) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    private boolean checkRepo() {
        DynamicObjectCollection repoEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("prompt_repo_config");
        if (repoEntrys != null && !repoEntrys.isEmpty()) {
            String firstRepoType = "";
            for (DynamicObject repo : repoEntrys) {
                String type = repo.getString("repotype");
                if (kd.bos.util.StringUtils.isBlank((String)type)) continue;
                if (kd.bos.util.StringUtils.isBlank((String)firstRepoType)) {
                    firstRepoType = type;
                    continue;
                }
                if (firstRepoType.equals(type)) continue;
                String message = ResManager.loadKDString((String)"\u8bf7\u5173\u8054\u540c\u7c7b\u578b\u7684\u77e5\u8bc6\u5e93\u3002", (String)"GaiServiceInfoPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return false;
            }
        }
        return true;
    }

    private boolean checkVarAll(boolean showTop) {
        DynamicObjectCollection customRows = this.getModel().getEntryEntity("var_configs");
        int customSize = Objects.nonNull(customRows) ? customRows.size() : 0;
        HashSet<String> varSet = new HashSet<String>(customSize);
        Pattern pattern = Pattern.compile(regex);
        if (Objects.nonNull(customRows)) {
            for (DynamicObject row : customRows) {
                String varValue = row.getString("var");
                if (!this.checkVar(showTop, pattern, varSet, varValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkVar(boolean showTop, Pattern pattern, Set<String> varSet, String varValue) {
        boolean status;
        boolean bl = status = !pattern.matcher(varValue).find();
        if (status) {
            if (showTop) {
                String message = ResManager.loadKDString((String)"\u53d8\u91cf\u53ea\u80fd\u8f93\u5165\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"GaiServiceInfoPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
            }
            return true;
        }
        if (varSet.contains(varValue)) {
            if (showTop) {
                String message = ResManager.loadKDString((String)"\u53d8\u91cf\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"GaiServiceInfoPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
            }
            return true;
        }
        varSet.add(varValue);
        return false;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        Map<String, Object> resp = this.invokeCustom(this.getView(), eventName, eventArgs);
        this.sendCustom(resp);
        switch (eventName) {
            case "getChatInfo": {
                String modelStyle;
                String languageModel;
                String name;
                StringBuilder msg = new StringBuilder();
                DynamicObject prampt = this.getModel().getDataEntity(true);
                String number = prampt.getString("number");
                if (kd.bos.util.StringUtils.isEmpty((String)number)) {
                    msg.append("\u7f16\u7801,");
                }
                if (kd.bos.util.StringUtils.isEmpty((String)(name = prampt.getString("name")))) {
                    msg.append("\u540d\u79f0,");
                }
                if (kd.bos.util.StringUtils.isEmpty((String)(languageModel = prampt.getString("language_model")))) {
                    msg.append("\u8bed\u8a00\u6a21\u578b,");
                }
                if (kd.bos.util.StringUtils.isEmpty((String)(modelStyle = prampt.getString("model_style")))) {
                    msg.append("\u6a21\u578b\u98ce\u683c,");
                }
                String promptStr = prampt.getString("prompt_tag");
                if (kd.bos.util.StringUtils.isNotEmpty((String)msg.toString())) {
                    msg.append("\u4e0d\u80fd\u4e3a\u7a7a");
                    this.getView().showTipNotification(msg.toString());
                    return;
                }
                if (this.checkVarAll(true)) {
                    return;
                }
                DynamicObjectCollection outEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("out_var_configs");
                if (Objects.nonNull(outEntrys) && outEntrys.size() == 0) {
                    String message = ResManager.loadKDString((String)"\u8f93\u51fa\u53d8\u91cf\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u3002", (String)"GaiServiceInfoPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(message);
                    return;
                }
                Map resultMap = ResultVoHelper.buildGetChatInfo((String)languageModel, (String)modelStyle, (String)promptStr);
                this.sendCustom(resultMap);
            }
        }
    }

    private void sendCustom(Map<String, Object> resp) {
        CustomControl ctrl = (CustomControl)this.getControl("gai_gpt_playground");
        if (ctrl != null) {
            ctrl.setData(resp);
        }
    }

    private Map<String, Object> invokeCustom(IFormView formView, String eventName, String eventArgs) {
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName);
        JSONObject requestData = JSONObject.parseObject((String)eventArgs);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String chatSessionId = requestData.getString("id");
        if (StringUtils.isEmpty((CharSequence)chatSessionId) && !StringUtils.equalsIgnoreCase((CharSequence)requestActionType.name(), (CharSequence)RequestActionType.newChat.name())) {
            chatSessionId = this.getChatSessionId();
        }
        Context context = null;
        switch (requestActionType) {
            case initial: {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                formShowParameter.setCustomParam("slideEnv", (Object)SLIDEENV.PLAYGROUND);
                GaiUtils.newContextInSlide((IFormView)this.getView(), null);
                chatSessionId = this.getChatSessionId();
                GaiInitConfig gaiInitConfig = new GaiInitConfig(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, SLIDEENV.PLAYGROUND, chatSessionId, null, null);
                gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)RequestContext.get().getCurrUserId()));
                resultMap = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
                break;
            }
            case newChat: {
                GaiUtils.newContextInSlide((IFormView)this.getView(), null);
                chatSessionId = this.getChatSessionId();
                JSONObject dataJo = new JSONObject();
                dataJo.put("id", (Object)chatSessionId);
                resultMap = ResultVoHelper.buildResult((String)ResultActionType.newChat.name(), (Object)dataJo);
                break;
            }
            case playgroundChat: {
                boolean stream = requestData.getBoolean("stream");
                String promptTemplate = requestData.getString("promptTemplate");
                DynamicObject promptInfo = this.getModel().getDataEntity(true);
                boolean isEncrypted = (Boolean)this.getModel().getValue("isencrypted");
                if (isEncrypted) {
                    promptTemplate = this.getView().getPageCache().get(key_prompt_encrypted_context);
                }
                String input = requestData.getString("input");
                String serviceNumber = requestData.getString("llm");
                Map service = AiccService.queryLlmAiccService((String)serviceNumber);
                if (service == null || service.isEmpty()) {
                    throw new KDBizException("\u63d0\u793a\u5bf9\u5e94\u7684\u7b97\u6cd5\u670d\u52a1\u4e0d\u5b58\u5728\u3002");
                }
                String llmNumber = (String)service.get("llm");
                if (StringUtils.isEmpty((CharSequence)llmNumber)) {
                    llmNumber = serviceNumber;
                }
                LLM llm = LLM.parse((String)llmNumber);
                LlmStyle llmStyle = LlmStyle.parse((String)requestData.getString("llmStyle"));
                Map variableMap = GaiUtils.toMap((JSONObject)requestData.getJSONObject("variableMap"));
                DynamicObjectCollection repos = promptInfo.getDynamicObjectCollection("prompt_repo_config");
                ArrayList<Long> repoIds = new ArrayList<Long>(repos.size());
                for (DynamicObject repoRow : repos) {
                    DynamicObject repo = repoRow.getDynamicObject("repoid");
                    repoIds.add((Long)repo.getPkValue());
                }
                BigDecimal count = promptInfo.getBigDecimal("remembercount");
                Prompt prompt = new Prompt();
                prompt.setId(((Long)this.getModel().getValue("id")).longValue());
                prompt.setLlm(llm);
                prompt.setServiceNumber(serviceNumber);
                prompt.setLlmStyle(llmStyle);
                prompt.setPrompt(promptTemplate);
                prompt.setRemembercount(count.intValue());
                prompt.setRepoIds(repoIds);
                prompt.setPromptOutVarList(Collections.singletonList(new PromptOutVar("prompt_output", "GPT\u63d0\u793a\u8f93\u51fa", OutFieldType.STRING.getType(), false)));
                prompt.setCreateTime((Date)this.getModel().getValue("createtime"));
                try {
                    Result result = this.sendAsync(input, prompt, stream, variableMap);
                    if (!result.getErrorCode().equals((Object)Errors.FAKE_OK)) break;
                    resultMap = ResultVoHelper.buildFakeErrMsg((String)Errors.LLM_ERROR.getCode(), (String)result.getErrorCode().getMessage(), null);
                }
                catch (Exception e) {
                    logger.error("GaiPrompt\u9519\u8bef", (Throwable)e);
                    resultMap = ResultVoHelper.buildErrMsg((String)Errors.LLM_ERROR.getCode(), (String)e.getMessage(), null);
                }
                break;
            }
            case stopStream: {
                String taskId = requestData.getString("taskId");
                context = FlowCacheData.getContext((String)chatSessionId);
                StopStreamMessage stopStreamMessage = new StopStreamMessage();
                stopStreamMessage.setTaskId(taskId);
                stopStreamMessage.setFlowId(0L);
                Result result = HandlerFactory.runHandler((Context)context, (Message)stopStreamMessage);
                String message = ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u6d4b\u8bd5\u5173\u95ed\u6d41\u4fe1\u606f\u8f93\u51fa:{}\u3002", (String)"GaiServiceInfoPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]);
                logger.info(message, (Object)JsonUtil.toJson((Object)result));
                break;
            }
            case showAgreement: {
                String pageId = this.getView().getPageCache().get("showAgreement");
                if (kd.bos.util.StringUtils.isNotEmpty((String)pageId)) break;
                this.getView().getPageCache().put("showAgreement", "true");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("gai_privacy_agreement");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "agreementClose"));
                fsp.setCustomParam("agreementType", (Object)"userAgreement");
                this.getView().showForm(fsp);
            }
            default: {
                resultMap = new HashMap();
            }
        }
        return resultMap;
    }

    private String getChatSessionId() {
        return this.getView().getPageCache().get("chatSessionId");
    }

    private Result sendAsync(String input, Prompt prompt, boolean stream, Map<String, String> varParams) {
        IPageCache chatSessionInfo = this.getView().getPageCache();
        String chatSessionId = chatSessionInfo.get("chatSessionId");
        PromptTestCallbackMessage callbackMessage = new PromptTestCallbackMessage("gai_gpt_playground");
        callbackMessage.setChatSessionId(chatSessionId);
        callbackMessage.setParseOutput(true);
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setCallbackMessage((LLMParsedMessage)callbackMessage);
        llmMessage.setUserInput(input);
        llmMessage.setPrompt(prompt);
        llmMessage.setStream(stream);
        llmMessage.setParamMap(varParams);
        return HandlerFactory.runHandler((Context)FlowCacheData.getContext((String)chatSessionId), (Message)llmMessage);
    }

    private void setStatus() {
        boolean isEncrypted = (Boolean)this.getModel().getValue("isencrypted");
        boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        if (isEncrypted) {
            String promptInfo = this.getModel().getDataEntity(true).getString("prompt_tag");
            this.getView().getPageCache().put(key_prompt_encrypted_context, promptInfo);
            this.getModel().setValue("prompt", (Object)"\u8be5\u63d0\u793a\u8bcd\u5df2\u88ab\u52a0\u5bc6");
            this.getModel().setValue("prompt_tag", (Object)"\u8be5\u63d0\u793a\u8bcd\u5df2\u88ab\u52a0\u5bc6");
            this.getView().updateView("prompt");
            this.getView().updateView("prompt_tag");
        }
        if (isEncrypted || isPreset) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry", "moveentryup", "moveentrydown", "newentry_out", "deleteentry_out", "moveentryup_out", "moveentrydown_out", "advconbaritemap2", "advconbaritemap3", "advconbaritemap4", "advconbaritemap5"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        this.getView().getPageCache().remove("showAgreement");
        if ("agreementClose".equals(actionId)) {
            CustomControl customControl = (CustomControl)this.getControl("gai_gpt_playground");
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String chatSessionId = this.getView().getPageCache().get("chatSessionId");
            GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
            if ("userAgree".equals(returnData)) {
                gaiInitConfig.setUserAgree(true);
            } else if ("userDisagree".equals(returnData)) {
                gaiInitConfig.setUserAgree(false);
            }
            Map resultMap = ResultVoHelper.buildUserAgree((GaiInitConfig)gaiInitConfig);
            customControl.setData((Object)resultMap);
        }
    }
}

