/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import io.milvus.param.R;
import io.milvus.param.collection.DropCollectionParam;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.rag.milvus.MilvusClientFactory;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;

public class GaiTestPlugin
extends AbstractFormPlugin {
    private static final String toolbarName = "toolbar";
    private static final String bt_llm = "bt_llm";
    private static final String button_embedding = "button_embedding";
    private static final String button_embedding_search = "button_embedding_search";
    private static final String button_sync_micro = "button_sync_micro";
    private static final String embedding_input = "embedding_input";
    private static final String gaiconfig = "textgaiconfig";
    private static final String rootpageid = "rootpageid";
    private static final String bigIntRepoId = "bigint_repoid";
    private static final String text_system = "system";
    private static final String userinput = "userinput";
    private static final String embedding_search_input = "embedding_search_input";
    private static final String textResult = "text_result";
    private static final String version = "2023.10.16";

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getView().getControl(toolbarName);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem();
        ComboEdit languageModel = (ComboEdit)this.getView().getControl("language_model");
        languageModel.setComboItems(comboItems);
    }

    public void itemClick(ItemClickEvent evt) {
        String result = "\u7ed3\u679c\uff1a";
        switch (evt.getItemKey()) {
            case "bt_search_collection_name": {
                String collectionName = MilvusService.getExecutor((LLM)LLM.AZURE_EMBEDDING_ADA_002).getCollectionName();
                this.getModel().setValue("collection_name", (Object)collectionName);
                break;
            }
            case "bt_del_collection_name": {
                String collection_name = (String)this.getModel().getValue("collection_name");
                DropCollectionParam dropCollectionParam = DropCollectionParam.newBuilder().withCollectionName(collection_name).build();
                R rs = MilvusClientFactory.getClient().dropCollection(dropCollectionParam);
                result = collection_name + "\u5220\u9664\u6210\u529f:" + rs.getStatus() + rs.getMessage();
                break;
            }
            case "click": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setFormId("gpt_gai_form_embedded");
                showParameter.getOpenStyle().setShowType(ShowType.NonModal);
                JSONArray position = new JSONArray();
                position.add((Object)550);
                position.add((Object)500);
                showParameter.setCustomParam("position", (Object)JSON.toJSONString((Object)position));
                showParameter.setCustomParam("selectedControls", (Object)JSON.toJSONString((Object)new JSONArray()));
                this.getView().showForm(showParameter);
                break;
            }
            case "bt_llm": {
                String input = (String)this.getModel().getValue(userinput);
                String system = (String)this.getModel().getValue(text_system);
                String llmString = (String)this.getModel().getDataEntity().get("language_model");
                LLM llm = LLM.parse((String)llmString);
                Prompt prompt = new Prompt();
                prompt.setLlm(llm);
                prompt.setLlmStyle(LlmStyle.BALANCE);
                prompt.setPrompt(system);
                Result2User result2User = LlmService.syncGpt((Prompt)prompt, null, null, (String)input, (int)0);
                result = "2023.10.16\u6a21\u578b\u540c\u6b65\u8c03\u7528\u7ed3\u679c\uff1a" + result2User.getContent();
                break;
            }
            case "button_embedding": {
                String embeddingInput = (String)this.getModel().getValue(embedding_input);
                long start = System.currentTimeMillis();
                Result4Embedding result4Embedding = EmbeddingServiceFactory.getExecutor((LLM)LLM.AZURE_EMBEDDING_ADA_002).embedding(Collections.singletonList(embeddingInput));
                result = "embedding\u63a5\u53e3\u8017\u65f6:" + (System.currentTimeMillis() - start) + JSON.toJSONString(result4Embedding.getVectorList().get(0));
                break;
            }
            case "button_embedding_search": {
                String input = (String)this.getModel().getValue(embedding_search_input);
                Long repoId = Long.parseLong(this.getModel().getValue(bigIntRepoId) + "");
                if (repoId.equals(0L)) {
                    throw new KDBizException("repoId\u5fc5\u987b\u8f93\u5165\u3002");
                }
                long start = System.currentTimeMillis();
                Result4Embedding result4Embedding = EmbeddingServiceFactory.getExecutor((LLM)LLM.AZURE_EMBEDDING_ADA_002).embedding(Collections.singletonList(input));
                long middle = System.currentTimeMillis();
                List chunkIdList = MilvusService.getExecutor((LLM)LLM.AZURE_EMBEDDING_ADA_002).searchIds((List)result4Embedding.getVectorList().get(0), Collections.singletonList(repoId));
                result = "embedding\u63a5\u53e3\u8017\u65f6" + (middle - start) + "milvus\u641c\u7d22\u8017\u65f6\uff1a" + (System.currentTimeMillis() - middle) + JSON.toJSONString((Object)chunkIdList);
                break;
            }
            case "button_sync_micro": {
                String gaiConfigJson = (String)this.getModel().getValue(gaiconfig);
                String rootPageId = (String)this.getModel().getValue(rootpageid);
                DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, gaiConfigJson});
                result = rootPageId + gaiConfigJson;
            }
        }
        this.getModel().setValue(textResult, (Object)result);
        this.getView().showSuccessNotification("\u7ed3\u679c\uff1a" + result);
    }
}

