/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.context.RequestContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class HomePagePlugin
extends AbstractFormPlugin {
    private static final String ENTITY_TENANT_AGREEMENT = "gai_tenant_agreement";
    private static final String ENTITY_USER_AGREEMENT = "gai_user_agreement";
    private static final String PARAM_AGREEMENT_TYPE = "agreementType";
    private static final String AGREEMENT_TYPE_TENANT = "tenantAgreement";
    private static final String AGREEMENT_TYPE_USER = "userAgreement";
    private static final String FORM_PRIVACY_POLICY = "gai_privacy_agreement";
    private static final String CONFIRM_AGREEMENT = "agreementConfirm";
    private static final String CLOSE_CALL_BACK_AGREEMENT = "agreementClose";

    public void afterCreateNewData(EventObject e) {
        long currUserId = RequestContext.get().getCurrUserId();
        String tenantId = RequestContext.get().getTenantId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)currUserId);
        if (GptPrivacyHelper.isTenantAgree((String)tenantId)) {
            return;
        }
        if (!isAdmin) {
            HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>(2);
            btnNameMap.put(MessageBoxResult.OK.getValue(), "\u6211\u77e5\u9053\u4e86");
            this.getView().showConfirm("\u672a\u7b7e\u7f72\u670d\u52a1\u5904\u7406\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", "\u60a8\u7684\u4f01\u4e1a\u8fd8\u672a\u7b7e\u7f72\u82cd\u7a79GPT\u670d\u52a1\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7b7e\u7f72\u3002", MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_AGREEMENT), btnNameMap);
        } else {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(FORM_PRIVACY_POLICY);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_AGREEMENT));
            fsp.setCustomParam(PARAM_AGREEMENT_TYPE, (Object)AGREEMENT_TYPE_TENANT);
            this.getView().showForm(fsp);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CONFIRM_AGREEMENT.equals(callBackId) && MessageBoxResult.Cancel.equals((Object)evt.getResult())) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSE_CALL_BACK_AGREEMENT.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null || !"tenantAgree".equals(returnData)) {
                this.getView().close();
            } else {
                String rootPageId = GaiUtils.getRootPageId((IFormView)this.getView());
                RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
                GaiInitConfig gaiInitConfig = new GaiInitConfig(rootPageIdContext.getChatSessionId());
                gaiInitConfig.setShowIcon(Boolean.TRUE);
                DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSON.toJSONString((Object)gaiInitConfig)});
            }
        }
    }
}

