/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.ToolPageCache;
import kd.ai.gai.core.agent.tool.util.FastJsonUtil;
import kd.ai.gai.core.service.agent.OpenAPIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;

public class GaiToolAPITestFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GaiToolAPITestFormPlugin.class);
    private ToolPageCache cache;
    public static final String BTN_CANCEL = "btncancel";
    public static final String BTN_OK = "btnok";
    public static final String BTN_TEST = "bartest";
    private static final String PARAMETERS_ENTITY = "entryentity";
    private static final String URLENCODED_ENTITY = "urlentryentity";
    public static final String API_CONFIG_CACHE = "_api_config_test_cache";
    public static final String API_CONFIG_PARAM_CACHE = "_api_config_param_test_cache";
    public static final String API_CONFIG_COMPONENTS_CACHE = "_api_config_components_test_cache";
    public static final String API_CONFIG_HEADERS_CACHE = "_api_config_headers_test_cache";
    public static final String CONTROL_RESULT_CODE_EDIT = "codeeditap";
    public static final String CONTROL_REQUEST_BODY = "request_body";
    public static final String CONTROL_REQUEST_BODY_CONTENT = "requestbody_content";
    public static final String CONTROL_REQUEST_BODY_TITLE = "requestbody_title";
    public static final String CONTROL_REQUEST_BODY_TYPE = "content_type_ap";
    public static final String CONTROL_REQUEST_BODY_URL_ENCODED = "requestbody_urlencoded";
    public static final String API_TEST_CACHE = "_api_test_cache_pre";
    public static final String CONTROL_CONTENT_TYPE_SELECTOR = "content_type_selector";
    public static final String IS_HAS_REQUEST_BODY_CACHE = "_is_request_body_cache_";
    public static final String API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE = "_api_content_type_pre_";

    public ToolPageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new ToolPageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL, BTN_TEST});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bartest": {
                this.callApi();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONTROL_CONTENT_TYPE_SELECTOR)) {
            this.handlerContentTypeSelectorChange(e);
        }
    }

    private void handlerContentTypeSelectorChange(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData[0] != null) {
            String contentType = (String)changeData[0].getNewValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.X_WWW_FORM_URLENCODED.getType()) || StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.MULTIPART_FORM_DATA.getType())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_REQUEST_BODY_URL_ENCODED, CONTROL_REQUEST_BODY_TITLE});
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_REQUEST_BODY_CONTENT});
                JSONArray params = this.getCache().getAsArray(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, contentType));
                this.getModel().deleteEntryData(URLENCODED_ENTITY);
                this.addParameters(params, URLENCODED_ENTITY);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_REQUEST_BODY_URL_ENCODED});
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_REQUEST_BODY_CONTENT, CONTROL_REQUEST_BODY_TITLE});
                String jsonStr = this.getCache().get(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_JSON.getType()));
                CodeEdit body = (CodeEdit)this.getControl(CONTROL_REQUEST_BODY);
                body.setText(jsonStr);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_REQUEST_BODY_URL_ENCODED});
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_REQUEST_BODY_CONTENT, CONTROL_REQUEST_BODY_TITLE});
                String xmlStr = this.getCache().get(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_XML.getType()));
                CodeEdit body = (CodeEdit)this.getControl(CONTROL_REQUEST_BODY);
                body.setText(xmlStr);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String operationParam = (String)formShowParameter.getCustomParam("operation");
        String config = (String)formShowParameter.getCustomParam("config");
        logger.info("API Test Config:{}", (Object)config);
        String components = (String)formShowParameter.getCustomParam("components");
        String headersJson = (String)formShowParameter.getCustomParam("headers");
        this.getCache().put(API_CONFIG_CACHE, config);
        this.getCache().put(API_CONFIG_PARAM_CACHE, operationParam);
        this.getCache().put(API_CONFIG_COMPONENTS_CACHE, components);
        this.getCache().put(API_CONFIG_HEADERS_CACHE, headersJson);
        this.getModel().deleteEntryData(PARAMETERS_ENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_REQUEST_BODY_CONTENT, CONTROL_REQUEST_BODY_URL_ENCODED, CONTROL_REQUEST_BODY_TITLE});
        if (!StringUtils.isEmpty((CharSequence)operationParam)) {
            JSONObject operation = JSONObject.parseObject((String)operationParam);
            JSONArray parameters = operation.getJSONArray("parameters");
            this.addQueryParameters(parameters, PARAMETERS_ENTITY);
            JSONObject requestBody = operation.getJSONObject("requestBody");
            try {
                if (requestBody != null && requestBody.containsKey((Object)"content")) {
                    this.getCache().put(IS_HAS_REQUEST_BODY_CACHE, "1");
                    this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_REQUEST_BODY_TYPE});
                    JSONObject content = requestBody.getJSONObject("content");
                    if (content != null && !content.isEmpty()) {
                        ArrayList<String> contentTypes = new ArrayList<String>(content.keySet());
                        for (String contentType : contentTypes) {
                            JSONObject mediaType = content.getJSONObject(contentType);
                            if (mediaType == null) continue;
                            if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
                                this.handlerApplicationJSON(mediaType);
                                continue;
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.X_WWW_FORM_URLENCODED.getType())) {
                                this.handlerBodyURLEncodedParam(contentType, mediaType);
                                continue;
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.MULTIPART_FORM_DATA.getType())) {
                                this.handlerBodyURLEncodedParam(contentType, mediaType);
                                continue;
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) continue;
                            this.handlerApplicationXML(mediaType);
                        }
                        this.setContentTypeSelectValues(contentTypes);
                    }
                } else {
                    this.getCache().put(IS_HAS_REQUEST_BODY_CACHE, "0");
                    this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_REQUEST_BODY_URL_ENCODED, CONTROL_REQUEST_BODY_CONTENT, CONTROL_REQUEST_BODY_TITLE, CONTROL_REQUEST_BODY_TYPE});
                }
            }
            catch (Exception ex) {
                logger.error("\u89e3\u6790requestBody\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)ex.getMessage());
            }
        }
    }

    private void setContentTypeSelectValues(List<String> contentTypes) {
        ComboEdit select = (ComboEdit)this.getControl(CONTROL_CONTENT_TYPE_SELECTOR);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(contentTypes.size());
        for (int i = 0; i < contentTypes.size(); ++i) {
            String contentType = contentTypes.get(i);
            ComboItem ci = new ComboItem();
            ci.setCaption(new LocaleString(contentType));
            ci.setValue(contentType);
            items.add(ci);
        }
        select.setComboItems(items);
    }

    private void addParameters(JSONArray parameters, String entityName) {
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(entityName);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(entityName).getDynamicObjectType();
        if (parameters != null && !parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                JSONObject parameter = parameters.getJSONObject(i);
                String name = parameter.getString("name");
                String dataType = parameter.getString("dataType");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set(String.format("%s_key", entityName), (Object)name);
                if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"Integer") || StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"Long")) {
                    dynamicObject.set(String.format("%s_value", entityName), (Object)0);
                } else {
                    dynamicObject.set(String.format("%s_value", entityName), (Object)"");
                }
                dynamicObject.set(String.format("%s_type", entityName), (Object)dataType);
                billEntityCollection.add((Object)dynamicObject);
            }
        }
        this.getModel().updateEntryCache(billEntityCollection);
        this.getView().updateView(entityName);
    }

    private void addQueryParameters(JSONArray parameters, String entityName) {
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(entityName);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(entityName).getDynamicObjectType();
        if (parameters != null && !parameters.isEmpty()) {
            for (int i = 0; i < parameters.size(); ++i) {
                JSONObject parameter = parameters.getJSONObject(i);
                String name = parameter.getString("name");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set(String.format("%s_key", entityName), (Object)name);
                dynamicObject.set(String.format("%s_value", entityName), (Object)"");
                billEntityCollection.add((Object)dynamicObject);
            }
        }
        this.getModel().updateEntryCache(billEntityCollection);
        this.getView().updateView(entityName);
    }

    private void handlerBodyURLEncodedParam(String contentType, JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        if (schema != null) {
            String $ref = schema.getString("$ref");
            if (!StringUtils.isEmpty((CharSequence)$ref)) {
                String schemaName = this.parseSchemaName("#/components/schemas/", $ref);
                JSON data = this.getSchemaJSON(schemaName, ToolConstant.ContentType.APPLICATION_JSON.getType());
                JSONArray params = this.handlerProps(data);
                this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, contentType), params.toJSONString());
            } else {
                JSON data = this.getSchemaJSON(schema, ToolConstant.ContentType.APPLICATION_JSON.getType());
                JSONArray params = this.handlerProps(data);
                this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, contentType), params.toJSONString());
            }
        }
    }

    private JSONArray handlerProps(JSON json) {
        JSONArray params = new JSONArray();
        if (json != null) {
            JSONArray array;
            if (json instanceof JSONObject) {
                JSONObject item = (JSONObject)json;
                this.handlerParameters(params, item);
            } else if (json instanceof JSONArray && (array = (JSONArray)json) != null && !array.isEmpty()) {
                JSONObject item = array.getJSONObject(0);
                this.handlerParameters(params, item);
            }
        }
        return params;
    }

    private void handlerParameters(JSONArray params, JSONObject item) {
        for (String propName : item.keySet()) {
            JSONObject data = new JSONObject();
            Object value = item.get((Object)propName);
            data.put("name", (Object)propName);
            if (value != null) {
                String typeName = value.getClass().getName();
                int length = typeName.lastIndexOf(".");
                String type = typeName.substring(length + 1);
                data.put("dataType", (Object)type);
            }
            params.add((Object)data);
        }
    }

    private void handlerApplicationXML(JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        if (schema != null) {
            String $ref = schema.getString("$ref");
            if (!StringUtils.isEmpty((CharSequence)$ref)) {
                String schemaName = this.parseSchemaName("#/components/schemas/", $ref);
                JSONObject xmlConfig = new JSONObject();
                JSON data = this.getSchemaJSON(schemaName, ToolConstant.ContentType.APPLICATION_XML.getType(), xmlConfig);
                String xmlName = this.parseRefXMLNode($ref);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                if (!StringUtils.isEmpty((CharSequence)xmlName)) {
                    sb.append(String.format("<%s>", xmlName));
                }
                FastJsonUtil.jsonToXmlStr((String)schemaName, (JSON)data, (StringBuffer)sb, (Boolean)Boolean.TRUE, (JSONObject)xmlConfig);
                if (!StringUtils.isEmpty((CharSequence)xmlName)) {
                    sb.append(String.format("</%s>", xmlName));
                }
                this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_XML.getType()), sb.toString());
            } else {
                String xmlName = this.getSchemaXMLName(schema);
                JSONObject xmlConfig = new JSONObject();
                JSON data = this.getSchemaJSON(xmlName, schema, ToolConstant.ContentType.APPLICATION_XML.getType(), xmlConfig);
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                if (!StringUtils.isEmpty((CharSequence)xmlName)) {
                    sb.append(String.format("<%s>", xmlName));
                }
                FastJsonUtil.jsonToXmlStr((String)xmlName, (JSON)data, (StringBuffer)sb, (Boolean)Boolean.TRUE, (JSONObject)xmlConfig);
                if (!StringUtils.isEmpty((CharSequence)xmlName)) {
                    sb.append(String.format("</%s>", xmlName));
                }
                this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_XML.getType()), sb.toString());
            }
        }
    }

    private void handlerApplicationJSON(JSONObject mediaType) {
        JSONObject schema = mediaType.getJSONObject("schema");
        if (schema != null) {
            JSONObject example = schema.getJSONObject("example");
            if (example != null) {
                String jsonStr = JSONObject.toJSONString((Object)example, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty});
                this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_JSON.getType()), jsonStr);
            } else {
                String $ref = schema.getString("$ref");
                if (!StringUtils.isEmpty((CharSequence)$ref)) {
                    String schemaName = this.parseSchemaName("#/components/schemas/", $ref);
                    JSON data = this.getSchemaJSON(schemaName, ToolConstant.ContentType.APPLICATION_JSON.getType());
                    String jsonStr = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty});
                    this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_JSON.getType()), jsonStr);
                } else {
                    JSON data = this.getSchemaJSON(schema, ToolConstant.ContentType.APPLICATION_JSON.getType());
                    String jsonStr = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty});
                    this.getCache().put(String.format("%s%s", API_REQUEST_BODY_CONTENT_TYPE_PARAMS_PRE_CACHE, ToolConstant.ContentType.APPLICATION_JSON.getType()), jsonStr);
                }
            }
        }
    }

    private Map<String, JSONObject> parseSchema(String componentsJson) {
        JSONObject schemas;
        HashMap<String, JSONObject> stringJSONObjectMap = new HashMap<String, JSONObject>();
        if (StringUtils.isEmpty((CharSequence)componentsJson)) {
            return new HashMap<String, JSONObject>();
        }
        JSONObject components = JSONObject.parseObject((String)componentsJson);
        if (components != null && !components.isEmpty() && (schemas = components.getJSONObject("schemas")) != null && !schemas.isEmpty()) {
            for (String schemaName : schemas.keySet()) {
                stringJSONObjectMap.put(schemaName, schemas.getJSONObject(schemaName));
            }
        }
        return stringJSONObjectMap;
    }

    private JSON getSchemaJSON(String schemaName, String type) {
        return this.getSchemaJSON(schemaName, type, new JSONObject());
    }

    private JSON getSchemaJSON(JSONObject schema, String type) {
        return this.getSchemaJSON(null, schema, type, new JSONObject());
    }

    private JSON getSchemaJSON(String schemaName, String type, JSONObject xmlConfig) {
        JSONObject schema;
        JSONObject data = null;
        String components = this.getCache().get(API_CONFIG_COMPONENTS_CACHE);
        Map<String, JSONObject> stringJSONObjectMap = this.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty() && (schema = stringJSONObjectMap.get(schemaName)) != null) {
            String schemaType = schema.getString("type");
            if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
                JSONObject props = schema.getJSONObject("properties");
                data = this.handlerProperties(props, type, xmlConfig);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
                data = this.handlerItems(schemaName, schema, type, xmlConfig);
            }
        }
        return data;
    }

    private JSON getSchemaJSON(String propName, JSONObject schema, String type, JSONObject xmlConfig) {
        JSONObject data = null;
        String schemaType = schema.getString("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"object")) {
            JSONObject props = schema.getJSONObject("properties");
            data = this.handlerProperties(props, type, xmlConfig);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)schemaType, (CharSequence)"array")) {
            data = this.handlerItems(propName, schema, type, xmlConfig);
        }
        return data;
    }

    private JSONArray handlerItems(String propName, JSONObject schema, String contentType, JSONObject xmlConfig) {
        String xmlNodeName = "";
        boolean wrapped = Boolean.FALSE;
        if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) {
            if (schema.containsKey((Object)"xml")) {
                JSONObject xml = schema.getJSONObject("xml");
                if (xml != null) {
                    if (xml.containsKey((Object)"wrapped")) {
                        wrapped = xml.getBoolean("wrapped");
                    }
                    if (wrapped) {
                        JSONObject itemsObj = schema.getJSONObject("items");
                        if (itemsObj.containsKey((Object)"xml")) {
                            JSONObject xmlObj = itemsObj.getJSONObject("xml");
                            if (xmlObj != null && xmlObj.containsKey((Object)"name")) {
                                xmlNodeName = xmlObj.getString("name");
                            }
                        } else if (itemsObj.containsKey((Object)"$ref")) {
                            xmlNodeName = this.parseRefXMLNode(itemsObj.getString("$ref"));
                        }
                    }
                }
            } else {
                JSONObject items = schema.getJSONObject("items");
                if (items != null && items.containsKey((Object)"$ref")) {
                    xmlNodeName = this.parseRefXMLNode(items.getString("$ref"));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)propName)) {
                JSONObject config = new JSONObject();
                config.put("_$XML_NODE_NAME$_", (Object)xmlNodeName);
                config.put("_$XML_WRAPPED$_", (Object)wrapped);
                xmlConfig.put(propName, (Object)config);
            }
        }
        return this.parseItems(propName, schema, contentType, xmlConfig);
    }

    private JSONArray parseItems(String propName, JSONObject schema, String contentType, JSONObject xmlConfig) {
        JSONObject items = schema.getJSONObject("items");
        JSONArray data = new JSONArray();
        if (items.containsKey((Object)"$ref")) {
            String ref = items.getString("$ref");
            String schemaName = this.parseSchemaName("#/components/schemas/", ref);
            JSON json = this.getSchemaJSON(schemaName, contentType, xmlConfig);
            data.add((Object)json);
        } else {
            String itemType = items.getString("type");
            if (StringUtils.equalsIgnoreCase((CharSequence)itemType, (CharSequence)"object")) {
                JSONObject itemProps = items.getJSONObject("properties");
                JSONObject item = this.handlerProperties(itemProps, contentType, xmlConfig);
                data.add((Object)item);
            } else if ("array".equalsIgnoreCase(itemType)) {
                JSONObject itemsObj = items.getJSONObject("items");
                JSONArray array = this.handlerItems(propName, itemsObj, contentType, xmlConfig);
                data.add((Object)array);
            } else if ("integer".equalsIgnoreCase(itemType)) {
                data.add((Object)0);
            } else if ("number".equalsIgnoreCase(itemType)) {
                data.add((Object)0);
            } else if ("boolean".equalsIgnoreCase(itemType)) {
                data.add((Object)Boolean.FALSE);
            } else if ("string".equalsIgnoreCase(itemType)) {
                data.add((Object)"");
            }
        }
        return data;
    }

    private JSONObject handlerProperties(JSONObject props, String contentType) {
        return this.handlerProperties(props, contentType, new JSONObject());
    }

    private JSONObject handlerProperties(JSONObject props, String contentType, JSONObject xmlConfig) {
        JSONObject data = new JSONObject();
        if (props != null && !props.isEmpty()) {
            for (String propName : props.keySet()) {
                JSONObject prop = props.getJSONObject(propName);
                String type = prop.getString("type");
                if ("string".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)"");
                    continue;
                }
                if ("integer".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)0);
                    continue;
                }
                if ("number".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)0);
                    continue;
                }
                if ("boolean".equalsIgnoreCase(type)) {
                    data.put(propName, (Object)Boolean.FALSE);
                    continue;
                }
                if ("object".equalsIgnoreCase(type)) {
                    JSONObject subProps = prop.getJSONObject("properties");
                    JSONObject subPropsData = this.handlerProperties(subProps, contentType);
                    data.put(propName, (Object)subPropsData);
                    continue;
                }
                if ("array".equalsIgnoreCase(type)) {
                    JSONArray array = this.handlerItems(propName, prop, contentType, xmlConfig);
                    data.put(propName, (Object)array);
                    continue;
                }
                if (!prop.containsKey((Object)"$ref")) continue;
                String ref = prop.getString("$ref");
                JSONObject schema = this.getRefSchema(ref);
                JSONObject subProps = schema.getJSONObject("properties");
                JSONObject subPropsData = this.handlerProperties(subProps, contentType, xmlConfig);
                data.put(propName, (Object)subPropsData);
            }
        }
        return data;
    }

    private String parseSchemaName(String pre, String $ref) {
        return $ref.substring(pre.length());
    }

    private String parseRefXMLNode(String $ref) {
        JSONObject schema;
        String nodeName = "";
        String schemaName = this.parseSchemaName("#/components/schemas/", $ref);
        String components = this.getCache().get(API_CONFIG_COMPONENTS_CACHE);
        Map<String, JSONObject> stringJSONObjectMap = this.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty() && (schema = stringJSONObjectMap.get(schemaName)) != null && schema.containsKey((Object)"xml")) {
            nodeName = schema.getJSONObject("xml").getString("name");
        }
        return nodeName;
    }

    private JSONObject getRefSchema(String $ref) {
        String schemaName = this.parseSchemaName("#/components/schemas/", $ref);
        String components = this.getCache().get(API_CONFIG_COMPONENTS_CACHE);
        Map<String, JSONObject> stringJSONObjectMap = this.parseSchema(components);
        if (stringJSONObjectMap != null && !stringJSONObjectMap.isEmpty()) {
            JSONObject schema = stringJSONObjectMap.get(schemaName);
            return schema;
        }
        return new JSONObject();
    }

    private String getSchemaXMLName(JSONObject schema) {
        String name = "";
        if (schema != null && schema.containsKey((Object)"xml")) {
            name = schema.getJSONObject("xml").getString("name");
        }
        return name;
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctl = (Control)e.getSource();
        String key = ctl.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_OK) || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BTN_CANCEL)) {
            JSONObject data = this.getCache().getAsObject(API_TEST_CACHE);
            this.getView().returnDataToParent((Object)data);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        JSONObject data = this.getCache().getAsObject(API_TEST_CACHE);
        this.getView().returnDataToParent((Object)data);
    }

    private void callApi() {
        String config = this.getCache().get(API_CONFIG_CACHE);
        String operationParam = this.getCache().get(API_CONFIG_PARAM_CACHE);
        JSONObject operation = JSONObject.parseObject((String)operationParam);
        String operationId = operation.getString("operationId");
        JSONObject toolParams = new JSONObject();
        String flag = this.getCache().get(IS_HAS_REQUEST_BODY_CACHE);
        if (StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)"1")) {
            JSONObject body = new JSONObject();
            logger.info("Handler Http RequestBody ...");
            String contentType = (String)this.getModel().getValue(CONTROL_CONTENT_TYPE_SELECTOR);
            if (StringUtils.isEmpty((CharSequence)contentType)) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9Content-Type\u3002");
                return;
            }
            body.put("contentType", (Object)contentType);
            String requestBody = this.buildRequestBody();
            logger.info("RequestBody:{}", (Object)requestBody);
            body.put("body", (Object)requestBody);
            toolParams.put("requestBody", (Object)body);
        }
        toolParams.put("operationId", (Object)operationId);
        JSONArray parameters = this.buildRequestParameters();
        toolParams.put("parameters", (Object)parameters);
        String headersJson = this.getCache().get(API_CONFIG_HEADERS_CACHE);
        JSONArray commonHeaders = JSONArray.parseArray((String)headersJson);
        toolParams.put("headers", (Object)commonHeaders);
        logger.info("###ToolConfig:{}", (Object)JSONObject.toJSONString((Object)config));
        logger.info("###ToolParams:{}", (Object)JSONObject.toJSONString((Object)toolParams));
        BaseResult result = OpenAPIService.callOpenAPITool((String)config, (JSONObject)toolParams);
        CodeEdit codeEdit = (CodeEdit)this.getControl(CONTROL_RESULT_CODE_EDIT);
        codeEdit.setText(JSONObject.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty}));
        JSONObject data = new JSONObject();
        data.put("operationId", (Object)operationId);
        data.put("errCode", (Object)result.getErrCode());
        this.getCache().put(API_TEST_CACHE, data.toJSONString());
    }

    private JSONArray buildRequestParameters() {
        EntryGrid grid = (EntryGrid)this.getControl(PARAMETERS_ENTITY);
        DynamicObject[] dynamicObjects = grid.getEntryData().getDataEntitys();
        JSONArray parameters = new JSONArray();
        for (DynamicObject object : dynamicObjects) {
            String paramName = object.getString(String.format("%s_key", PARAMETERS_ENTITY));
            String paramValue = object.getString(String.format("%s_value", PARAMETERS_ENTITY));
            JSONObject parameter = new JSONObject();
            parameter.put("name", (Object)paramName);
            parameter.put("value", (Object)paramValue);
            parameters.add((Object)parameter);
        }
        return parameters;
    }

    private String buildRequestBody() {
        String body = "";
        String contentType = (String)this.getModel().getValue(CONTROL_CONTENT_TYPE_SELECTOR);
        if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_JSON.getType())) {
            CodeEdit bodyEdit = (CodeEdit)this.getControl(CONTROL_REQUEST_BODY);
            body = bodyEdit.getText();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.X_WWW_FORM_URLENCODED.getType())) {
            body = this.buildURLEncodedBodyData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.APPLICATION_XML.getType())) {
            CodeEdit bodyEdit = (CodeEdit)this.getControl(CONTROL_REQUEST_BODY);
            body = bodyEdit.getText();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ToolConstant.ContentType.MULTIPART_FORM_DATA.getType())) {
            body = this.buildMultipartFormBodyData();
        }
        return body;
    }

    private String buildURLEncodedBodyData() {
        EntryGrid grid = (EntryGrid)this.getControl(URLENCODED_ENTITY);
        DynamicObject[] dynamicObjects = grid.getEntryData().getDataEntitys();
        ArrayList<String> keys = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            String paramName = object.getString(String.format("%s_key", URLENCODED_ENTITY));
            String paramValue = object.getString(String.format("%s_value", URLENCODED_ENTITY));
            try {
                keys.add(String.format("%s=%s", URLEncoder.encode(paramName, "UTF-8"), URLEncoder.encode(paramValue, "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                logger.info("ContentType\u4e3aapplication/x-www-form-urlencoded\u65f6\uff0c\u5bf9\u53c2\u6570\u503c\u8fdb\u884c\u7f16\u7801\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        }
        String body = StringUtils.join(keys, (String)"&");
        return body;
    }

    private String buildMultipartFormBodyData() {
        String formData = null;
        try {
            EntryGrid grid = (EntryGrid)this.getControl(URLENCODED_ENTITY);
            DynamicObject[] dynamicObjects = grid.getEntryData().getDataEntitys();
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("UTF-8"));
            for (DynamicObject object : dynamicObjects) {
                String paramName = object.getString(String.format("%s_key", URLENCODED_ENTITY));
                String paramValue = object.getString(String.format("%s_value", URLENCODED_ENTITY));
                String dataType = object.getString(String.format("%s_type", URLENCODED_ENTITY));
                if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"JSONObject")) {
                    builder.addPart(paramName, (ContentBody)new StringBody(paramValue, ContentType.create((String)"application/json", (Charset)Charset.forName("UTF-8"))));
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"JSONArray")) {
                    builder.addPart(paramName, (ContentBody)new StringBody(paramValue, ContentType.create((String)"application/json", (Charset)Charset.forName("UTF-8"))));
                    continue;
                }
                builder.addPart(paramName, (ContentBody)new StringBody(paramValue, ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8"))));
            }
            HttpEntity entity = builder.build();
            formData = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            logger.error("build form data error,{}", (Object)e.getMessage());
        }
        return formData;
    }
}

