/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.ToolPageCache;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Components;
import kd.ai.gai.core.agent.tool.openapi.v3.models.HttpMethod;
import kd.ai.gai.core.agent.tool.openapi.v3.models.OpenAPI;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Operation;
import kd.ai.gai.core.agent.tool.openapi.v3.models.Path;
import kd.ai.gai.core.agent.tool.util.FastJsonUtil;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GaiToolBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private ToolPageCache cache;
    private static final Log logger = LogFactory.getLog(GaiToolBillPlugin.class);
    private static final String CONTROL_AGENT_TYPE = "tool_type";
    private static final String CONTROL_NUMBER = "number";
    private static final String CONTROL_NAME = "name";
    private static final String CONTROL_ENABLE = "enable";
    private static final String CONTROL_DESCRIPTION = "description";
    private static final String CONTROL_THD_OPENAPI_CONFIG = "thd_openapi_config";
    private static final String CUSTOM_ACTION_CONFIG = "custom_action_config";
    private static final String CONTROL_AUTH_TYPE_SELECTOR = "auth_selector";
    private static final String CONTROL_KEY_HEADER_SELECTOR = "key_selector";
    private static final String CONTROL_THD_AUTH = "thd_auth";
    private static final String CONTROL_PARAM_NAME = "param_name";
    private static final String CONTROL_PARAM_VALUE = "param_value";
    private static final String CONTROL_SERVICE_AUTH_AP = "serviceauth_ap";
    private static final String CONTROL_OPENAPI_AP = "openapi_ap";
    private static final String CONTROL_COSMIC_ACCESS_TOKEN_AP = "cosmic_at_ap";
    private static final String CONTROL_SWAGGER_EDIT = "swagger_edit";
    private static final String CONTROL_BTN_PARSER_SWAGGER = "btn_swagger_parser";
    private static final String API_ENTITY = "apientity";
    private static final String CONTROL_SWAGGER_CONFIG_TAG = "config_tag";
    private static final String CONTROL_BTN_HEADER_DEL = "headerbtndel";
    private static final String CONTROL_BTN_HEADER_ADD = "headerbtnadd";
    private static final String CONTROL_BTN_BODY_PARAM_DEL = "bodyparamdel";
    private static final String CONTROL_BTN_BODY_PARAM_ADD = "bodyparamadd";
    private static final String CONTROL_PANEL_SWAGGER_CONFIG = "flexpanelap";
    private static final String OPENAPI_SWAGGER_OPERATION_PARAM_CACHE = "_openapi_operation_param_cache";
    private static final String OPENAPI_SWAGGER_COMPONENTS_CACHE = "_openapi_swagger_components_cache";
    private static final String CONTROL_CLIENT_ID = "client_id";
    private static final String CONTROL_CLIENT_SECRET = "client_secret";
    private static final String CONTROL_AUTHORIZATION_URL = "authorization_url";
    private static final String CONTROL_TOKEN_URL = "token_url";
    private static final String CONTROL_SCOPE = "scope";
    private static final String CONTROL_COSMIC_CLIENT_ID = "cosmic_client_id";
    private static final String CONTROL_COSMIC_CLIENT_SECRET = "cosmic_client_secret";
    private static final String CONTROL_COSMIC_USERNAME = "cosmic_username";
    private static final String CONTROL_COSMIC_ACCOUNTID = "cosmic_accountid";
    private static final String CONTROL_COSMIC_ACCESS_TOKEN_URL = "cosmic_token_url";
    private static final String CONTROL_HEADER_ENTIRY = "headerentity";
    private static final String CONTROL_BODY_ENTIRY = "bodyentity";
    private static final String CONTROL_SAVE_BTN = "bar_save";
    private static final String OPENAPI_TEST_CACHE_PRE = "_openapi_test_cache_pre_";
    private static final String OPENAPI_API_LIST_CACHE = "_openapi_api_list_cache";
    private static final String OPENAPI_API_HEADERS_CACHE = "_openapi_api_headers_cache";
    private static final String OPENAPI_API_BODY_PARAMS_CACHE = "_openapi_api_body_params_cache";
    private static final String OPENAPI_API_OPERATIONS_CACHE = "_openapi_api_operations_cache";
    private static final String OPENAPI_API_API_LIST_CACHE = "_openapi_api_api_list_cache";
    private static final String OPENAPI_API_LAST_TEST_PASS_CACHE = "_openapi_api_last_test_pass_cache";
    private static final String CONTROL_IMPORT_URL_LABEL = "import_url";
    private static final String CONTROL_API_LIST_TOOL_BAR = "apicontrolbar";
    private static final String OPERATION_KEY_PARSER_SWAGGER = "parser_swagger";
    private static final String OPERATION_KEY_TEST_API = "test_api";
    private static final String OPERATION_KEY_SAVE = "save";
    private static final String API_ENTITY_FIELD_OPERATION = "api_operation";
    private static final String CONTROL_FORMAT_LABEL = "format_swagger";
    private static final String CONTROL_API_EXAMPLE_LABEL = "view_example";
    private static final String CURRENT_AUTH_TYPE_CACHE = "_current_auth_type_cache_";
    private static final String OPENAPI_API_ENTRY_INDEX_CACHE = "_openapi_api_entry_index_cache";
    private static final int MAX_ENABLE_API_NUM = 5;
    private static final String OPENAPI_API_ENTRY_CURRENT_CLICK_CACHE = "_openapi_api_entry_current_click_cache";
    private static final String DELETE_TAGS = "externalDocs,tags";
    private static final String KEY_SERVICE_NAME = "servicename";
    private static final String KEY_SERVICE_APP = "serviceapp";
    private static final String KEY_ACTION_NAME = "actionname";
    private static final String KEY_INPUT_ENTITY = "input_entryentity";
    private static final String KEY_OUTPUT_ENTITY = "output_entryentity";
    private static final String KEY_VAR_NAME = "var_name";
    private static final String KEY_VAR_TYPE = "var_type";
    private static final String KEY_VAR_DESC = "var_desc";
    private static final String KEY_VAR_INPUT_PREFIX = "input_";
    private static final String KEY_VAR_OUTPUT_PREFIX = "output_";
    private static final String KEY_CUSTOM_ACTION_CONFIG_CACHE = "_custom_action_config_cache_";
    private static final String KEY_INPUT_ADD = "actioninputadd";
    private static final String KEY_INPUT_DEL = "actioninputdel";
    private static final String KEY_OUTPUT_ADD = "actionoutputadd";
    private static final String KEY_OUTPUT_DEL = "actionoutputdel";

    public ToolPageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new ToolPageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label importUrl = (Label)this.getControl(CONTROL_IMPORT_URL_LABEL);
        importUrl.addClickListener((ClickListener)this);
        Label apiExample = (Label)this.getControl(CONTROL_API_EXAMPLE_LABEL);
        apiExample.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{CONTROL_API_LIST_TOOL_BAR});
        Label format = (Label)this.getControl(CONTROL_FORMAT_LABEL);
        format.addClickListener((ClickListener)this);
        EntryGrid apiEntity = (EntryGrid)this.getControl(API_ENTITY);
        apiEntity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_AGENT_TYPE});
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Boolean isCopy = (Boolean)billShowParameter.getCustomParam("iscopy");
        OperationStatus status = billShowParameter.getStatus();
        if (isCopy != null && isCopy.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_AGENT_TYPE});
            Object originPk = billShowParameter.getPkId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)originPk, (String)"gai_tool");
            String toolType = dynamicObject.getString(CONTROL_AGENT_TYPE);
            String config = dynamicObject.getString(CONTROL_SWAGGER_CONFIG_TAG);
            JSONObject configObj = JSONObject.parseObject((String)config);
            String number = CodeRuleServiceHelper.readNumber((String)"gai_tool", (DynamicObject)dynamicObject, null);
            String name = dynamicObject.getString(CONTROL_NAME);
            this.getModel().setValue(CONTROL_NUMBER, (Object)number);
            this.getModel().setValue(CONTROL_NAME, (Object)name);
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                if (configObj != null) {
                    String swaggerSchema = configObj.getString("swaggerSchema");
                    CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
                    swaggerEdit.setText(swaggerSchema);
                }
                this.init();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                if (configObj != null) {
                    this.showCustomActionInfo(config);
                }
                this.initCosmicAction();
            }
        } else if (OperationStatus.ADDNEW.getValue() == status.getValue()) {
            this.init();
        } else if (OperationStatus.VIEW.getValue() == status.getValue()) {
            Object pk = billShowParameter.getPkId();
            this.view(pk);
        } else if (OperationStatus.EDIT.getValue() == status.getValue()) {
            Object pk = billShowParameter.getPkId();
            this.edit(pk);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONTROL_AGENT_TYPE)) {
            this.handlerAgentToolTypeSelectorChange(e);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONTROL_AUTH_TYPE_SELECTOR)) {
            this.handlerOpenAPIAuthTypeSelectorChange(e);
        }
    }

    public void click(EventObject e) {
        Control ctl = (Control)e.getSource();
        String key = ctl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_IMPORT_URL_LABEL)) {
            this.importUrl();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_API_EXAMPLE_LABEL)) {
            this.viewExample();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_FORMAT_LABEL)) {
            this.formatSwagger();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)OPERATION_KEY_PARSER_SWAGGER)) {
            this.getCache().remove(OPENAPI_TEST_CACHE_PRE);
            this.parserSwagger();
            JSONArray operations = this.getCache().getAsArray(OPENAPI_API_OPERATIONS_CACHE);
            if (operations == null || operations.isEmpty()) {
                return;
            }
            this.showOpenAPIOperations(operations);
            this.selectAllApi(operations.size());
            this.recordRowIndex();
        }
    }

    private void selectAllApi(int size) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(API_ENTITY);
        int[] rows = new int[size];
        for (int i = 0; i < size; ++i) {
            rows[i] = i;
        }
        entryGrid.selectRows(rows, 0);
    }

    private void importUrl() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_tool_api_import");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterImportApiCallback"));
        this.getView().showForm(parameter);
    }

    private void viewExample() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_tool_api_example");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewExampleCallback"));
        this.getView().showForm(parameter);
    }

    private void formatSwagger() {
        CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
        String swaggerConfig = swaggerEdit.getText();
        try {
            if (StringUtils.isEmpty((CharSequence)swaggerConfig)) {
                return;
            }
            JSONObject config = JSONObject.parseObject((String)swaggerConfig);
            swaggerEdit.setText(JSONObject.toJSONString((Object)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullListAsEmpty}));
        }
        catch (Exception e) {
            logger.error("format swagger config error,{}", (Object)e.getMessage());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6790OpenAPI\u7684swagger\u914d\u7f6e\u51fa\u9519\uff0c\u53ea\u652f\u6301JSON\u683c\u5f0f\u7684swagger\u914d\u7f6e\u3002\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u7684\u683c\u5f0f\u3002", (String)"GaiToolBillPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int index = evt.getRow();
        this.getCache().put(OPENAPI_API_ENTRY_CURRENT_CLICK_CACHE, String.valueOf(index));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)OPERATION_KEY_TEST_API)) {
            int clickRow = Integer.parseInt(this.getCache().get(OPENAPI_API_ENTRY_CURRENT_CLICK_CACHE));
            DynamicObjectCollection entry = this.getModel().getEntryEntity(API_ENTITY);
            DynamicObject dynamicObject = (DynamicObject)entry.get(clickRow);
            String operation = dynamicObject.getString(API_ENTITY_FIELD_OPERATION);
            this.testApi(operation);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)OPERATION_KEY_SAVE)) {
            String toolType = (String)this.getModel().getValue(CONTROL_AGENT_TYPE);
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                JSONArray operations = this.getCache().getAsArray(OPENAPI_API_API_LIST_CACHE);
                JSONArray headers = this.getCache().getAsArray(OPENAPI_API_HEADERS_CACHE);
                JSONArray bodyParams = this.getCache().getAsArray(OPENAPI_API_BODY_PARAMS_CACHE);
                this.showHeaders(headers);
                this.showOpenAPIOperations(operations);
                this.showBodyCommonParams(bodyParams);
                JSONArray apiList = this.getCache().getAsArray(OPENAPI_API_API_LIST_CACHE);
                this.setApiSelected(apiList);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                String config = this.getCache().get(KEY_CUSTOM_ACTION_CONFIG_CACHE);
                this.showCustomActionInfo(config);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_AGENT_TYPE});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATION_KEY_SAVE)) {
            String toolType = (String)this.getModel().getValue(CONTROL_AGENT_TYPE);
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                List<String> operations = this.getAllSelectedAPI();
                if (operations.size() > 5) {
                    this.getView().showTipNotification(String.format("\u52fe\u9009\u7684\u53ef\u7528\u63a5\u53e3\u6570\u91cf\u6700\u5927\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", 5), Integer.valueOf(3000));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                this.saveOpenAPIConfig();
                if (!this.checkSelectedApiIsTestSuccess()) {
                    this.getModel().setValue(CONTROL_ENABLE, (Object)String.valueOf(0));
                    Object configTag = this.getModel().getValue(CONTROL_SWAGGER_CONFIG_TAG);
                    if (configTag != null) {
                        JSONObject configData = JSONObject.parseObject((String)String.valueOf(configTag));
                        configData.put("flag", (Object)0);
                        this.getModel().setValue(CONTROL_SWAGGER_CONFIG_TAG, (Object)JSONObject.toJSONString((Object)configData));
                    }
                } else {
                    this.getModel().setValue(CONTROL_ENABLE, (Object)String.valueOf(1));
                    String currentAuthType = (String)this.getModel().getValue(CONTROL_AUTH_TYPE_SELECTOR);
                    this.getCache().put(CURRENT_AUTH_TYPE_CACHE, currentAuthType);
                    Object configTag = this.getModel().getValue(CONTROL_SWAGGER_CONFIG_TAG);
                    if (configTag != null) {
                        JSONObject configData = JSONObject.parseObject((String)String.valueOf(configTag));
                        configData.put("flag", (Object)1);
                        this.getModel().setValue(CONTROL_SWAGGER_CONFIG_TAG, (Object)JSONObject.toJSONString((Object)configData));
                    }
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                if (!this.validateCusOperation()) {
                    this.getModel().setValue(CONTROL_ENABLE, (Object)String.valueOf(0));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                this.getModel().setValue(CONTROL_ENABLE, (Object)String.valueOf(1));
                this.saveCustomActionConfig();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    private void testApi(String operationId) {
        String authType;
        Object authTypeObj = this.getModel().getValue(CONTROL_AUTH_TYPE_SELECTOR);
        String string = authType = ObjectUtils.isEmpty((Object)authTypeObj) ? "" : (String)authTypeObj;
        if (StringUtils.isEmpty((CharSequence)authType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u9274\u6743\u65b9\u5f0f\u3002", (String)"GaiToolBillPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.saveOpenAPIConfig();
        String jsonCache = this.getCache().get(OPENAPI_SWAGGER_OPERATION_PARAM_CACHE);
        JSONObject operationParamMap = JSONObject.parseObject((String)jsonCache);
        if (!operationParamMap.containsKey((Object)operationId)) {
            this.getView().showTipNotification(String.format("api %s is not exist in plugin config", operationId), Integer.valueOf(3000));
            return;
        }
        JSONObject operation = operationParamMap.getJSONObject(operationId);
        String operationJson = JSONObject.toJSONString((Object)operation);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("gai_tool_api_test");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("operation", (Object)operationJson);
        String componentsJson = this.getCache().get(OPENAPI_SWAGGER_COMPONENTS_CACHE);
        String config = (String)this.getModel().getValue(CONTROL_SWAGGER_CONFIG_TAG);
        parameter.setCustomParam("config", (Object)config);
        parameter.setCustomParam("components", (Object)componentsJson);
        JSONArray headers = this.getHeaderList();
        String headerJson = headers.toJSONString();
        parameter.setCustomParam("headers", (Object)headerJson);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterTestApiCallback"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object value;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (action.equals("afterTestApiCallback")) {
            JSONArray apiList = this.getAPIList();
            JSONObject data = (JSONObject)closedCallBackEvent.getReturnData();
            if (data != null) {
                String errorCode = data.getString("errCode");
                String operationId = data.getString("operationId");
                JSONObject statusMap = (JSONObject)this.getCache().getAsObject(OPENAPI_TEST_CACHE_PRE, JSONObject.class);
                if (statusMap == null) {
                    statusMap = new JSONObject();
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)errorCode, (CharSequence)"0")) {
                    statusMap.put(operationId, (Object)String.valueOf(1));
                    this.updateOperationAPIStatus(operationId, 1);
                } else {
                    statusMap.put(operationId, (Object)String.valueOf(0));
                    this.updateOperationAPIStatus(operationId, 0);
                }
                this.getCache().put(OPENAPI_TEST_CACHE_PRE, JSONObject.toJSONString((Object)statusMap));
            }
            this.setApiSelected(apiList);
        } else if (action.equalsIgnoreCase("afterImportApiCallback")) {
            Object value2 = closedCallBackEvent.getReturnData();
            if (!ObjectUtils.isEmpty((Object)value2)) {
                String config = (String)value2;
                CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
                swaggerEdit.setText(config);
                this.formatSwagger();
            }
        } else if (action.equalsIgnoreCase("viewExampleCallback") && !ObjectUtils.isEmpty((Object)(value = closedCallBackEvent.getReturnData()))) {
            String config = (String)value;
            CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
            swaggerEdit.setText(config);
        }
    }

    private void handlerAgentToolTypeSelectorChange(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData[0] != null) {
            String toolType = (String)changeData[0].getNewValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
                this.selectAgentPreset();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                this.selectThdOpenAPI();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                this.selectCustomAction();
            }
        }
    }

    private void handlerOpenAPIAuthTypeSelectorChange(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData[0] != null) {
            String authType = (String)changeData[0].getNewValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.NO_AUTH.getType())) {
                this.selectNOauth();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                this.selectServiceAuth();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                this.selectOAuth();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                this.selectCosmicAccessToken();
            }
        }
    }

    private void selectAgentPreset() {
        this.getView().setEnable(Boolean.TRUE, new String[]{CONTROL_NUMBER});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_THD_OPENAPI_CONFIG});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_THD_AUTH});
        this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOM_ACTION_CONFIG});
    }

    private void selectThdOpenAPI() {
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_NUMBER});
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_THD_OPENAPI_CONFIG});
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_THD_AUTH});
        this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOM_ACTION_CONFIG});
    }

    private void selectNOauth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
    }

    private void selectServiceAuth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_SERVICE_AUTH_AP});
    }

    private void openAPIPreset(Boolean ispreset) {
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_AGENT_TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_NAME});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_DESCRIPTION});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_SWAGGER_EDIT});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_PARSER_SWAGGER});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_HEADER_DEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_HEADER_ADD});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_BODY_PARAM_DEL});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_BTN_BODY_PARAM_ADD});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_FORMAT_LABEL, CONTROL_IMPORT_URL_LABEL, CONTROL_API_EXAMPLE_LABEL, API_ENTITY});
            HashMap<String, Boolean> data = new HashMap<String, Boolean>(1);
            data.put("selchexkbox", false);
            this.getView().updateControlMetadata(API_ENTITY, data);
        }
    }

    private void cosmicActionPreset(Boolean ispreset) {
        if (ispreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_AGENT_TYPE, CONTROL_SAVE_BTN});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_NAME});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_DESCRIPTION, KEY_SERVICE_APP, KEY_SERVICE_NAME, KEY_ACTION_NAME, KEY_INPUT_ENTITY, KEY_OUTPUT_ENTITY, KEY_INPUT_ADD, KEY_INPUT_DEL, KEY_OUTPUT_ADD, KEY_OUTPUT_DEL});
        }
    }

    private void selectOAuth() {
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_OPENAPI_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
    }

    private void selectCosmicAccessToken() {
        this.getView().setVisible(Boolean.TRUE, new String[]{CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP});
    }

    private void init() {
        this.initToolTypeSelectCombo();
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_NUMBER});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_THD_OPENAPI_CONFIG});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_THD_AUTH});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_SERVICE_AUTH_AP, CONTROL_OPENAPI_AP, CONTROL_COSMIC_ACCESS_TOKEN_AP});
        this.getModel().setValue(CONTROL_AGENT_TYPE, (Object)ToolConstant.ToolType.THIRD_OPENAPI.getType());
        this.selectThdOpenAPI();
        this.getModel().setValue(CONTROL_AUTH_TYPE_SELECTOR, (Object)AuthType.NO_AUTH.getType());
    }

    private void view(Object pk) {
        this.edit(pk);
    }

    private void edit(Object pk) {
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"gai_tool");
        if (tool != null) {
            String config = tool.getString(CONTROL_SWAGGER_CONFIG_TAG);
            String toolType = tool.getString(CONTROL_AGENT_TYPE);
            String number = tool.getString(CONTROL_NUMBER);
            String name = tool.getString(CONTROL_NAME);
            Boolean ispreset = tool.getBoolean("ispreset");
            this.getModel().setValue(CONTROL_NUMBER, (Object)number);
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
                this.selectAgentPreset();
                this.getModel().setValue(CONTROL_NUMBER, (Object)number);
                this.getModel().setValue(CONTROL_NAME, (Object)name);
                this.getModel().setValue(CONTROL_AGENT_TYPE, (Object)ToolConstant.ToolType.AGENT_PRESET.getType());
                this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_NAME, CONTROL_DESCRIPTION, CONTROL_SAVE_BTN});
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                this.getModel().setValue(CONTROL_NAME, (Object)name);
                this.selectThdOpenAPI();
                JSONObject swaggerConfig = JSONObject.parseObject((String)config);
                if (swaggerConfig != null) {
                    int flag = swaggerConfig.getIntValue("flag");
                    this.getCache().put(OPENAPI_API_LAST_TEST_PASS_CACHE, String.valueOf(flag));
                    String swaggerSchema = swaggerConfig.getString("swaggerSchema");
                    CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
                    swaggerEdit.setText(swaggerSchema);
                    this.formatSwagger();
                    JSONArray apiList = swaggerConfig.getJSONArray("apiList");
                    this.parseSwagger(swaggerSchema);
                    this.showOpenAPIOperations(apiList);
                    this.recordRowIndex();
                    this.putAPITestCache(apiList);
                    this.setApiSelected(apiList);
                    String authType = swaggerConfig.getString("authtype");
                    this.getModel().setValue(CONTROL_AUTH_TYPE_SELECTOR, (Object)authType);
                    if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.NO_AUTH.getType())) {
                        this.selectNOauth();
                        this.openAPIPreset(ispreset);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
                        this.selectServiceAuth();
                        this.openAPIPreset(ispreset);
                        this.showServiceAuthFields(swaggerConfig.getJSONObject("serviceConfig"));
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
                        this.selectOAuth();
                        this.openAPIPreset(ispreset);
                        this.showOAuthFields(swaggerConfig.getJSONObject("oauthConfig"));
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
                        this.selectCosmicAccessToken();
                        this.openAPIPreset(ispreset);
                        this.showCosmicAccessTokenAuthFields(swaggerConfig.getJSONObject("cosmicAccessTokenConfig"));
                    }
                    JSONArray headers = swaggerConfig.getJSONArray("headerList");
                    this.showHeaders(headers);
                    JSONArray bodyParams = swaggerConfig.getJSONArray("bodyParamList");
                    this.showBodyCommonParams(bodyParams);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                this.selectCustomAction();
                this.cosmicActionPreset(ispreset);
                this.showCustomActionInfo(config);
            }
        }
    }

    private void putAPITestCache(JSONArray operations) {
        if (operations != null && !operations.isEmpty()) {
            JSONObject statusMap = new JSONObject(operations.size());
            for (int i = 0; i < operations.size(); ++i) {
                JSONObject operation = operations.getJSONObject(i);
                String operationId = operation.getString("operationId");
                String status = operation.getString("testStatus");
                if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(1), (CharSequence)status)) {
                    statusMap.put(operationId, (Object)1);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(0), (CharSequence)status)) continue;
                statusMap.put(operationId, (Object)0);
            }
            this.getCache().put(OPENAPI_TEST_CACHE_PRE, JSONObject.toJSONString((Object)statusMap));
        }
    }

    private void showHeaders(JSONArray headers) {
        this.getModel().deleteEntryData(CONTROL_HEADER_ENTIRY);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(CONTROL_HEADER_ENTIRY);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(CONTROL_HEADER_ENTIRY).getDynamicObjectType();
        if (headers != null && !headers.isEmpty()) {
            for (int i = 0; i < headers.size(); ++i) {
                JSONObject parameter = headers.getJSONObject(i);
                String name = parameter.getString("key");
                String value = parameter.getString("value");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set("header_key", (Object)name);
                dynamicObject.set("header_value", (Object)value);
                billEntityCollection.add((Object)dynamicObject);
            }
            this.getModel().updateEntryCache(billEntityCollection);
            this.getView().updateView(CONTROL_HEADER_ENTIRY);
        }
    }

    private void showBodyCommonParams(JSONArray bodyParams) {
        this.getModel().deleteEntryData(CONTROL_BODY_ENTIRY);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(CONTROL_BODY_ENTIRY);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(CONTROL_BODY_ENTIRY).getDynamicObjectType();
        if (bodyParams != null && !bodyParams.isEmpty()) {
            for (int i = 0; i < bodyParams.size(); ++i) {
                JSONObject parameter = bodyParams.getJSONObject(i);
                String name = parameter.getString("paramName");
                String value = parameter.getString("paramValue");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set("body_param_name", (Object)name);
                dynamicObject.set("body_param_value", (Object)value);
                billEntityCollection.add((Object)dynamicObject);
            }
            this.getModel().updateEntryCache(billEntityCollection);
            this.getView().updateView(CONTROL_BODY_ENTIRY);
        }
    }

    private void parserSwagger(String swaggerSchema) {
        if (StringUtils.isEmpty((CharSequence)swaggerSchema)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"OpenAPI\u7684swagger\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a.", (String)"GaiToolBillPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        JSONObject swagger = null;
        try {
            swagger = JSONObject.parseObject((String)swaggerSchema, (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6790OpenAPI\u7684swagger\u914d\u7f6e\u51fa\u9519\uff0c\u53ea\u652f\u6301JSON\u683c\u5f0f\u7684swagger\u914d\u7f6e\u3002\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u7684\u683c\u5f0f\u3002", (String)"GaiToolBillPlugin_7", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (swagger == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89e3\u6790OpenAPI\u7684swagger\u914d\u7f6e\u51fa\u9519", (String)"GaiToolBillPlugin_8", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (!swagger.containsKey((Object)"openapi")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6OpenAPI\u534f\u8bae\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4e2d\u662f\u5426\u5305\u542bopenapi\u534f\u8bae\u4fe1\u606f\u3002", (String)"GaiToolBillPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (swagger.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6OpenAPI\u534f\u8bae\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u3002", (String)"GaiToolBillPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.parser(swagger);
    }

    private void parseSwagger(String swaggerSchema) {
        if (StringUtils.isEmpty((CharSequence)swaggerSchema)) {
            return;
        }
        JSONObject swagger = null;
        try {
            swagger = JSONObject.parseObject((String)swaggerSchema, (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            return;
        }
        if (swagger == null) {
            return;
        }
        if (!swagger.containsKey((Object)"openapi")) {
            return;
        }
        if (swagger.isEmpty()) {
            return;
        }
        this.parser(swagger);
    }

    private void parser(JSONObject swagger) {
        OpenAPI openAPI = OpenAPIUtils.parserSwaggerConfig((JSONObject)swagger);
        Map operationParamMap = OpenAPIUtils.parseOperationParam((OpenAPI)openAPI);
        String jsonCache = JSONObject.toJSONString((Object)operationParamMap);
        this.getCache().put(OPENAPI_SWAGGER_OPERATION_PARAM_CACHE, jsonCache);
        Components components = openAPI.getComponents();
        this.getCache().put(OPENAPI_SWAGGER_COMPONENTS_CACHE, JSONObject.toJSONString((Object)components));
        logger.info("parse swagger : {}", (Object)JSONObject.toJSONString((Object)openAPI));
        List operationIds = operationParamMap.keySet().stream().collect(Collectors.toList());
        this.getCache().put(OPENAPI_API_LIST_CACHE, JSONObject.toJSONString(operationIds));
        JSONArray operations = this.parseOpenAPIOperations(openAPI);
        this.getCache().put(OPENAPI_API_OPERATIONS_CACHE, operations.toJSONString());
    }

    private void parserSwagger() {
        CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
        String swaggerSchema = swaggerEdit.getText();
        this.parserSwagger(swaggerSchema);
    }

    private JSONArray parseOpenAPIOperations(OpenAPI openAPI) {
        Map paths = openAPI.getPaths();
        JSONArray operations = new JSONArray();
        if (paths != null && !paths.isEmpty()) {
            for (Map.Entry entry : paths.entrySet()) {
                Operation delete;
                Operation put;
                Operation post;
                String location = (String)entry.getKey();
                Path path = (Path)entry.getValue();
                Operation get = path.getGet();
                if (get != null) {
                    this.buildOperation(operations, get, location, HttpMethod.GET.toString().toLowerCase(Locale.ROOT));
                }
                if ((post = path.getPost()) != null) {
                    this.buildOperation(operations, post, location, HttpMethod.POST.toString().toLowerCase(Locale.ROOT));
                }
                if ((put = path.getPut()) != null) {
                    this.buildOperation(operations, put, location, HttpMethod.PUT.toString().toLowerCase(Locale.ROOT));
                }
                if ((delete = path.getDelete()) == null) continue;
                this.buildOperation(operations, delete, location, HttpMethod.DELETE.toString().toLowerCase(Locale.ROOT));
            }
        }
        return operations;
    }

    private void buildOperation(JSONArray operations, Operation op, String location, String method) {
        JSONObject operation = new JSONObject();
        operation.put("operationId", (Object)op.getOperationId());
        operation.put(CONTROL_DESCRIPTION, (Object)op.getSummary());
        operation.put("method", (Object)method);
        operation.put("location", (Object)location);
        operations.add((Object)operation);
    }

    private void showOpenAPIOperations(JSONArray operations) {
        if (operations == null || operations.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(API_ENTITY);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(API_ENTITY);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(API_ENTITY).getDynamicObjectType();
        JSONObject indexMap = new JSONObject(operations.size());
        for (int i = 0; i < operations.size(); ++i) {
            JSONObject operation = operations.getJSONObject(i);
            DynamicObject doObj = new DynamicObject(dynamicObjectType);
            String operationId = operation.getString("operationId");
            doObj.set("seq", (Object)i);
            doObj.set(API_ENTITY_FIELD_OPERATION, (Object)operationId);
            doObj.set("api_description", (Object)operation.getString(CONTROL_DESCRIPTION));
            doObj.set("api_method", (Object)operation.getString("method"));
            String status = operation.getString("testStatus");
            String showText = "";
            if (!StringUtils.isEmpty((CharSequence)status)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)String.valueOf(1))) {
                    showText = ResManager.loadKDString((String)"\u901a\u8fc7", (String)"GaiToolBillPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.changeRelationCellStyle("api_test_status", i, "green");
                } else {
                    showText = ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"GaiToolBillPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
                    this.changeRelationCellStyle("api_test_status", i, "red");
                }
            }
            doObj.set("api_test_status", (Object)showText);
            doObj.set("api_location", (Object)operation.getString("location"));
            indexMap.put(operationId, (Object)i);
            billEntityCollection.add((Object)doObj);
        }
        this.getModel().updateEntryCache(billEntityCollection);
        this.getView().updateView(API_ENTITY);
    }

    private void updateOperationAPIStatus(String operationId, int testStatus) {
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(API_ENTITY);
        for (int i = 0; i < billEntityCollection.size(); ++i) {
            DynamicObject obj = (DynamicObject)billEntityCollection.get(i);
            String opId = obj.getString(API_ENTITY_FIELD_OPERATION);
            String opstatus = obj.getString("api_test_status");
            if (!StringUtils.isEmpty((CharSequence)opstatus)) {
                String text = ResManager.loadKDString((String)"\u901a\u8fc7", (String)"GaiToolBillPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                if (StringUtils.equalsIgnoreCase((CharSequence)opstatus, (CharSequence)text)) {
                    this.changeRelationCellStyle("api_test_status", i, "green");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)opstatus, (CharSequence)ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"GaiToolBillPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]))) {
                    this.changeRelationCellStyle("api_test_status", i, "red");
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)opId, (CharSequence)operationId)) continue;
            String showText = "";
            if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(testStatus), (CharSequence)String.valueOf(1))) {
                showText = ResManager.loadKDString((String)"\u901a\u8fc7", (String)"GaiToolBillPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.changeRelationCellStyle("api_test_status", i, "green");
            } else {
                showText = ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"GaiToolBillPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.changeRelationCellStyle("api_test_status", i, "red");
            }
            obj.set("api_test_status", (Object)showText);
        }
        this.getModel().updateEntryCache(billEntityCollection);
        this.getView().updateView(API_ENTITY);
    }

    private Map<String, String> getApiTestStatusMap() {
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(API_ENTITY);
        HashMap<String, String> status = new HashMap<String, String>(1);
        for (int i = 0; i < billEntityCollection.size(); ++i) {
            DynamicObject obj = (DynamicObject)billEntityCollection.get(i);
            String opId = obj.getString(API_ENTITY_FIELD_OPERATION);
            String opstatus = obj.getString("api_test_status");
            if (!StringUtils.isEmpty((CharSequence)opstatus)) {
                String text = ResManager.loadKDString((String)"\u901a\u8fc7", (String)"GaiToolBillPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                if (StringUtils.equalsIgnoreCase((CharSequence)opstatus, (CharSequence)text)) {
                    status.put(opId, String.valueOf(1));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)opstatus, (CharSequence)ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"GaiToolBillPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]))) continue;
                status.put(opId, String.valueOf(0));
                continue;
            }
            status.put(opId, "");
        }
        return status;
    }

    private void changeRelationCellStyle(String fieldKey, int row, String coreColor) {
        EntryGrid grid = (EntryGrid)this.getControl(API_ENTITY);
        CellStyle cs = new CellStyle();
        cs.setFieldKey(fieldKey);
        cs.setRow(row);
        cs.setForeColor(coreColor);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(1);
        cellStyles.add(cs);
        grid.setCellStyle(cellStyles);
    }

    private JSONObject buildToolConfig(String authType, String swaggerConfig) {
        JSONObject data = new JSONObject();
        data.put("authtype", (Object)authType);
        if (!StringUtils.isEmpty((CharSequence)swaggerConfig)) {
            try {
                JSONObject obj = JSONObject.parseObject((String)swaggerConfig);
                swaggerConfig = FastJsonUtil.removeWhitespaceAndNewlines((String)JSONObject.toJSONString((Object)obj));
            }
            catch (Exception e) {
                logger.error("swagger configuration information error");
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.NO_AUTH.getType())) {
            data.put("swaggerSchema", (Object)swaggerConfig);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.SERVICE.getType())) {
            data.put("swaggerSchema", (Object)swaggerConfig);
            data.put("serviceConfig", (Object)this.getServiceAuthConfig());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.OAUTH.getType())) {
            data.put("swaggerSchema", (Object)swaggerConfig);
            data.put("oauthConfig", (Object)this.getOAuthConfig());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)authType, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
            data.put("swaggerSchema", (Object)swaggerConfig);
            data.put("cosmicAccessTokenConfig", (Object)this.getCosmicAccessTokenConfig());
        }
        JSONArray headers = this.getHeaderList();
        JSONArray bodyParmas = this.getRequestBodyParams();
        data.put("bodyParamList", (Object)bodyParmas);
        data.put("headerList", (Object)headers);
        JSONArray apiList = this.getAPIList();
        data.put("apiList", (Object)apiList);
        JSONObject llmSwagger = this.buildLLMApiSchema(apiList, swaggerConfig);
        data.put("llmSchema", (Object)FastJsonUtil.removeWhitespaceAndNewlines((String)JSONObject.toJSONString((Object)llmSwagger)));
        this.getCache().put(OPENAPI_API_API_LIST_CACHE, apiList.toJSONString());
        this.getCache().put(OPENAPI_API_HEADERS_CACHE, headers.toJSONString());
        this.getCache().put(OPENAPI_API_BODY_PARAMS_CACHE, bodyParmas.toJSONString());
        return data;
    }

    private JSONObject buildLLMApiSchema(JSONArray apiList, String swaggerConfig) {
        JSONObject swagger = JSONObject.parseObject((String)swaggerConfig);
        if (swagger != null) {
            String[] supportsMethods = "get,put,post,delete,options,head,patch,trace".split(",");
            for (int i = 0; i < apiList.size(); ++i) {
                JSONObject api = apiList.getJSONObject(i);
                int enable = api.getIntValue(CONTROL_ENABLE);
                String method = api.getString("method");
                String location = api.getString("location");
                if (enable != 0) continue;
                this.deleteApiMethodFromSwagger(swagger, location, method, supportsMethods);
            }
            for (String tag : DELETE_TAGS.split(",")) {
                if (!swagger.containsKey((Object)tag)) continue;
                swagger.remove((Object)tag);
            }
        }
        return swagger;
    }

    private void deleteApiMethodFromSwagger(JSONObject swagger, String location, String method, String[] supportsMethods) {
        if (!swagger.containsKey((Object)"paths")) {
            return;
        }
        JSONObject paths = swagger.getJSONObject("paths");
        if (paths == null || paths.isEmpty()) {
            return;
        }
        if (!paths.containsKey((Object)location)) {
            return;
        }
        JSONObject pathObj = paths.getJSONObject(location);
        if (pathObj == null || pathObj.isEmpty()) {
            return;
        }
        if (pathObj.containsKey((Object)method)) {
            pathObj.remove((Object)method);
            Boolean exist = Boolean.FALSE;
            for (String opMethod : supportsMethods) {
                if (StringUtils.equalsIgnoreCase((CharSequence)opMethod, (CharSequence)method) || !pathObj.containsKey((Object)opMethod)) continue;
                exist = Boolean.TRUE;
                break;
            }
            if (!exist.booleanValue()) {
                paths.remove((Object)location);
            }
        }
    }

    private JSONArray getAPIList() {
        JSONArray operations = this.getCache().getAsArray(OPENAPI_API_OPERATIONS_CACHE);
        Map<String, String> statusMap = this.getApiTestStatusMap();
        JSONArray apiList = new JSONArray(0);
        if (operations != null && !operations.isEmpty()) {
            apiList = new JSONArray(operations.size());
            List<String> selectApis = this.getAllSelectedAPI();
            for (int i = 0; i < operations.size(); ++i) {
                JSONObject operation = operations.getJSONObject(i);
                String operationId = operation.getString("operationId");
                String description = operation.getString(CONTROL_DESCRIPTION);
                String method = operation.getString("method");
                String location = operation.getString("location");
                JSONObject opData = new JSONObject();
                opData.put("operationId", (Object)operationId);
                opData.put(CONTROL_DESCRIPTION, (Object)description);
                opData.put("method", (Object)method);
                opData.put("location", (Object)location);
                if (statusMap == null) {
                    opData.put("testStatus", (Object)"");
                } else {
                    String status = statusMap.get(operationId);
                    if (!StringUtils.isEmpty((CharSequence)status)) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(1), (CharSequence)status)) {
                            opData.put("testStatus", (Object)status);
                        } else {
                            opData.put("testStatus", (Object)String.valueOf(0));
                        }
                    } else {
                        opData.put("testStatus", (Object)"");
                    }
                }
                if (!selectApis.isEmpty()) {
                    if (selectApis.contains(operationId)) {
                        opData.put(CONTROL_ENABLE, (Object)1);
                    } else {
                        opData.put(CONTROL_ENABLE, (Object)0);
                    }
                } else {
                    opData.put(CONTROL_ENABLE, (Object)0);
                }
                apiList.add((Object)opData);
            }
        }
        return apiList;
    }

    private List<String> getAllSelectedAPI() {
        int[] rows;
        ArrayList<String> operationIds = new ArrayList<String>(1);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(API_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(API_ENTITY);
        for (int row : rows = entryGrid.getSelectRows()) {
            DynamicObject rowData = (DynamicObject)dynamicObjects.get(row);
            String operationId = rowData.getString(API_ENTITY_FIELD_OPERATION);
            operationIds.add(operationId);
        }
        return operationIds;
    }

    private void setApiSelected(JSONArray apiList) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(API_ENTITY);
        JSONObject apiIndexMap = this.getCache().getAsObject(OPENAPI_API_ENTRY_INDEX_CACHE);
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        for (int i = 0; i < apiList.size(); ++i) {
            JSONObject operation = apiList.getJSONObject(i);
            String operationId = operation.getString("operationId");
            int enable = operation.getIntValue(CONTROL_ENABLE);
            int rowIndex = apiIndexMap.getIntValue(operationId);
            if (enable != 1) continue;
            selectRows.add(rowIndex);
        }
        String[] rowIndexs = StringUtils.split((String)StringUtils.join(selectRows, (String)","), (String)",");
        int[] indexs = new int[rowIndexs.length];
        for (int i = 0; i < indexs.length; ++i) {
            indexs[i] = Integer.parseInt(rowIndexs[i]);
        }
        entryGrid.selectRows(indexs, 0);
    }

    private void recordRowIndex() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(API_ENTITY);
        JSONObject indexMap = new JSONObject(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String operationId = dynamicObject.getString(API_ENTITY_FIELD_OPERATION);
            int seq = dynamicObject.getInt("seq");
            indexMap.put(operationId, (Object)seq);
        }
        this.getCache().put(OPENAPI_API_ENTRY_INDEX_CACHE, JSONObject.toJSONString((Object)indexMap));
    }

    private JSONArray getHeaderList() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_HEADER_ENTIRY);
        DynamicObject[] dynamicObjects = entryGrid.getEntryData().getDataEntitys();
        JSONArray headers = new JSONArray();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String key = dynamicObject.getString("header_key");
                if (StringUtils.isEmpty((CharSequence)key)) continue;
                String value = dynamicObject.getString("header_value");
                JSONObject item = new JSONObject();
                item.put("key", (Object)key.trim());
                item.put("value", (Object)value);
                headers.add((Object)item);
            }
        }
        return headers;
    }

    private JSONArray getRequestBodyParams() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(CONTROL_BODY_ENTIRY);
        DynamicObject[] dynamicObjects = entryGrid.getEntryData().getDataEntitys();
        JSONArray bodyParams = new JSONArray();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String key = dynamicObject.getString("body_param_name");
                if (StringUtils.isEmpty((CharSequence)key)) continue;
                String value = dynamicObject.getString("body_param_value");
                JSONObject item = new JSONObject();
                item.put("paramName", (Object)key.trim());
                item.put("paramValue", (Object)value);
                bodyParams.add((Object)item);
            }
        }
        return bodyParams;
    }

    private JSONObject getServiceAuthConfig() {
        JSONObject config = new JSONObject();
        config.put("location", this.getModel().getValue(CONTROL_KEY_HEADER_SELECTOR));
        config.put("paramName", this.getModel().getValue(CONTROL_PARAM_NAME));
        config.put("paramValue", this.getModel().getValue(CONTROL_PARAM_VALUE));
        return config;
    }

    private JSONObject getOAuthConfig() {
        JSONObject config = new JSONObject();
        config.put(CONTROL_CLIENT_ID, this.getModel().getValue(CONTROL_CLIENT_ID));
        config.put(CONTROL_CLIENT_SECRET, this.getModel().getValue(CONTROL_CLIENT_SECRET));
        config.put(CONTROL_SCOPE, this.getModel().getValue(CONTROL_SCOPE));
        config.put(CONTROL_AUTHORIZATION_URL, this.getModel().getValue(CONTROL_AUTHORIZATION_URL));
        config.put(CONTROL_TOKEN_URL, this.getModel().getValue(CONTROL_TOKEN_URL));
        return config;
    }

    private JSONObject getCosmicAccessTokenConfig() {
        JSONObject config = new JSONObject();
        config.put(CONTROL_CLIENT_ID, this.getModel().getValue(CONTROL_COSMIC_CLIENT_ID));
        config.put(CONTROL_CLIENT_SECRET, this.getModel().getValue(CONTROL_COSMIC_CLIENT_SECRET));
        config.put("username", this.getModel().getValue(CONTROL_COSMIC_USERNAME));
        config.put("accountId", this.getModel().getValue(CONTROL_COSMIC_ACCOUNTID));
        config.put(CONTROL_TOKEN_URL, this.getModel().getValue(CONTROL_COSMIC_ACCESS_TOKEN_URL));
        return config;
    }

    private void showServiceAuthFields(JSONObject serviceConfig) {
        this.getModel().setValue(CONTROL_KEY_HEADER_SELECTOR, serviceConfig.get((Object)"location"));
        this.getModel().setValue(CONTROL_PARAM_NAME, serviceConfig.get((Object)"paramName"));
        this.getModel().setValue(CONTROL_PARAM_VALUE, serviceConfig.get((Object)"paramValue"));
    }

    private void showOAuthFields(JSONObject oauthConfig) {
        this.getModel().setValue(CONTROL_CLIENT_ID, oauthConfig.get((Object)CONTROL_CLIENT_ID));
        this.getModel().setValue(CONTROL_CLIENT_SECRET, oauthConfig.get((Object)CONTROL_CLIENT_SECRET));
        this.getModel().setValue(CONTROL_SCOPE, oauthConfig.get((Object)CONTROL_SCOPE));
        this.getModel().setValue(CONTROL_AUTHORIZATION_URL, oauthConfig.get((Object)CONTROL_AUTHORIZATION_URL));
        this.getModel().setValue(CONTROL_TOKEN_URL, oauthConfig.get((Object)CONTROL_TOKEN_URL));
    }

    private void showCosmicAccessTokenAuthFields(JSONObject cosmicConfig) {
        this.getModel().setValue(CONTROL_COSMIC_CLIENT_ID, cosmicConfig.get((Object)CONTROL_CLIENT_ID));
        this.getModel().setValue(CONTROL_COSMIC_CLIENT_SECRET, cosmicConfig.get((Object)CONTROL_CLIENT_SECRET));
        this.getModel().setValue(CONTROL_COSMIC_USERNAME, cosmicConfig.get((Object)"username"));
        this.getModel().setValue(CONTROL_COSMIC_ACCOUNTID, cosmicConfig.get((Object)"accountId"));
        this.getModel().setValue(CONTROL_COSMIC_ACCESS_TOKEN_URL, cosmicConfig.get((Object)CONTROL_TOKEN_URL));
    }

    private void saveOpenAPIConfig() {
        String toolType;
        Object value = this.getModel().getValue(CONTROL_AGENT_TYPE);
        String string = toolType = ObjectUtils.isEmpty((Object)value) ? "" : (String)value;
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
            this.getModel().setValue(CONTROL_SWAGGER_CONFIG_TAG, (Object)"");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
            Object authTypeObj = this.getModel().getValue(CONTROL_AUTH_TYPE_SELECTOR);
            String authType = ObjectUtils.isEmpty((Object)authTypeObj) ? "" : (String)authTypeObj;
            CodeEdit swaggerEdit = (CodeEdit)this.getControl(CONTROL_SWAGGER_EDIT);
            String swaggerConfig = swaggerEdit.getText();
            JSONObject configData = this.buildToolConfig(authType, swaggerConfig);
            String configJson = JSON.toJSONString((Object)configData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            String press = FastJsonUtil.removeWhitespaceAndNewlines((String)configJson);
            this.getModel().setValue(CONTROL_SWAGGER_CONFIG_TAG, (Object)press);
        }
    }

    private boolean checkSelectedApiIsTestSuccess() {
        Map<String, String> statusMap = this.getApiTestStatusMap();
        List<String> selectedApis = this.getAllSelectedAPI();
        if (selectedApis.isEmpty()) {
            return Boolean.FALSE;
        }
        if (statusMap == null) {
            return Boolean.FALSE;
        }
        StringBuilder sb = new StringBuilder();
        for (String operationId : selectedApis) {
            String status = statusMap.get(operationId);
            if (!StringUtils.isBlank((CharSequence)status) && !StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(0), (CharSequence)status)) continue;
            sb.append(String.format("api (%s) test no passed", operationId));
        }
        if (StringUtils.isEmpty((CharSequence)sb.toString())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean validateCusOperation() {
        String type;
        String className = (String)this.getModel().getValue(KEY_SERVICE_NAME);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_SERVICE_APP);
        String appid = app == null ? "" : app.getString(CONTROL_NUMBER);
        String string = appid = StringUtils.isBlank((CharSequence)appid) || BOSRuntime.isBOSApp((String)appid) ? "bos" : appid;
        if (app == null) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u5e94\u7528\u3002");
            return Boolean.FALSE;
        }
        if (StringUtils.isBlank((CharSequence)className)) {
            this.getView().showTipNotification("\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u540d\u3002");
            return Boolean.FALSE;
        }
        String action = (String)this.getModel().getValue(KEY_ACTION_NAME);
        if (StringUtils.isBlank((CharSequence)action)) {
            this.getView().showTipNotification("\u8bf7\u8f93\u5165\u64cd\u4f5c\u540d\u79f0\u3002");
            return Boolean.FALSE;
        }
        if (!this.validateInputParams()) {
            return Boolean.FALSE;
        }
        if (!this.validateOutputParams()) {
            return Boolean.FALSE;
        }
        Map ret = (Map)DispatchServiceHelper.invokeBOSService((String)appid, (String)"IGPTService", (String)"getObject", (Object[])new Object[]{className});
        int status = ret == null || ret.get("status") == null ? -1 : (Integer)ret.get("status");
        String string2 = type = ret == null || ret.get("type") == null ? "" : (String)ret.get("type");
        if (status == 0) {
            this.getView().showTipNotification("\u8f93\u5165\u7684\u7c7b\u540d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u5408\u89c4\u8303\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002");
            return Boolean.FALSE;
        }
        if (status == 1 && StringUtils.isBlank((CharSequence)type)) {
            this.getView().showTipNotification("\u8f93\u5165\u7684\u7c7b\u540d\u672a\u5b9e\u73b0\u64cd\u4f5c\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c\u3002");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean validateInputParams() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_INPUT_ENTITY);
        DynamicObject[] entites = entryGrid.getEntryData().getDataEntitys();
        Boolean flag = Boolean.TRUE;
        if (entites != null && entites.length > 0) {
            for (DynamicObject dynamicObject : entites) {
                String varName = dynamicObject.getString(String.format("%s%s", KEY_VAR_INPUT_PREFIX, KEY_VAR_NAME));
                String varType = dynamicObject.getString(String.format("%s%s", KEY_VAR_INPUT_PREFIX, KEY_VAR_TYPE));
                String varDesc = dynamicObject.getString(String.format("%s%s", KEY_VAR_INPUT_PREFIX, KEY_VAR_DESC));
                if (StringUtils.isBlank((CharSequence)varName)) {
                    flag = Boolean.FALSE;
                    this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8f93\u5165\u53c2\u6570\u540d\u79f0\u3002");
                    break;
                }
                if (StringUtils.isBlank((CharSequence)varType)) {
                    flag = Boolean.FALSE;
                    this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8f93\u5165\u53c2\u6570\u7c7b\u578b\u3002");
                    break;
                }
                if (!StringUtils.isBlank((CharSequence)varDesc)) continue;
                flag = Boolean.FALSE;
                this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8f93\u5165\u53c2\u6570\u63cf\u8ff0\u3002");
                break;
            }
        }
        return flag;
    }

    private boolean validateOutputParams() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_OUTPUT_ENTITY);
        DynamicObject[] entites = entryGrid.getEntryData().getDataEntitys();
        Boolean flag = Boolean.TRUE;
        if (entites != null && entites.length > 0) {
            for (DynamicObject dynamicObject : entites) {
                String varName = dynamicObject.getString(String.format("%s%s", KEY_VAR_OUTPUT_PREFIX, KEY_VAR_NAME));
                String varType = dynamicObject.getString(String.format("%s%s", KEY_VAR_OUTPUT_PREFIX, KEY_VAR_TYPE));
                String varDesc = dynamicObject.getString(String.format("%s%s", KEY_VAR_OUTPUT_PREFIX, KEY_VAR_DESC));
                if (StringUtils.isBlank((CharSequence)varName)) {
                    flag = Boolean.FALSE;
                    this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8f93\u51fa\u53c2\u6570\u540d\u79f0\u3002");
                    break;
                }
                if (StringUtils.isBlank((CharSequence)varType)) {
                    flag = Boolean.FALSE;
                    this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8f93\u51fa\u53c2\u6570\u7c7b\u578b\u3002");
                    break;
                }
                if (!StringUtils.isBlank((CharSequence)varDesc)) continue;
                flag = Boolean.FALSE;
                this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8f93\u51fa\u53c2\u6570\u63cf\u8ff0\u3002");
                break;
            }
        }
        return flag;
    }

    private void saveCustomActionConfig() {
        JSONObject configData = this.buildCustomActionConfig();
        this.getCache().put(KEY_CUSTOM_ACTION_CONFIG_CACHE, JSONObject.toJSONString((Object)configData));
        String configJson = JSON.toJSONString((Object)configData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        String press = FastJsonUtil.removeWhitespaceAndNewlines((String)configJson);
        this.getModel().setValue(CONTROL_SWAGGER_CONFIG_TAG, (Object)press);
    }

    private JSONObject buildCustomActionConfig() {
        String className = (String)this.getModel().getValue(KEY_SERVICE_NAME);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(KEY_SERVICE_APP);
        String appId = null;
        String app = null;
        if (dynamicObject != null) {
            appId = dynamicObject.getString(CONTROL_NUMBER);
            app = dynamicObject.getString("id");
        }
        if (StringUtils.isBlank(appId) || BOSRuntime.isBOSApp((String)appId)) {
            appId = "bos";
        }
        String action = (String)this.getModel().getValue(KEY_ACTION_NAME);
        JSONObject config = new JSONObject();
        config.put("appId", (Object)appId);
        config.put("app", (Object)app);
        config.put("serviceName", (Object)className);
        config.put("action", (Object)action);
        JSONArray inputParams = this.buildCustomActionParams("input");
        JSONArray outputParams = this.buildCustomActionParams("output");
        config.put("inputParams", (Object)inputParams);
        config.put("outputParams", (Object)outputParams);
        return config;
    }

    private JSONArray buildCustomActionParams(String type) {
        DynamicObject[] entites;
        String grid = "";
        String prefix = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"input")) {
            grid = KEY_INPUT_ENTITY;
            prefix = KEY_VAR_INPUT_PREFIX;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"output")) {
            grid = KEY_OUTPUT_ENTITY;
            prefix = KEY_VAR_OUTPUT_PREFIX;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(grid);
        JSONArray params = new JSONArray();
        for (DynamicObject dynamicObject : entites = entryGrid.getEntryData().getDataEntitys()) {
            String varName = dynamicObject.getString(String.format("%s%s", prefix, KEY_VAR_NAME));
            String varType = dynamicObject.getString(String.format("%s%s", prefix, KEY_VAR_TYPE));
            String varDesc = dynamicObject.getString(String.format("%s%s", prefix, KEY_VAR_DESC));
            JSONObject param = new JSONObject();
            param.put("paramName", (Object)varName);
            param.put("paramType", (Object)varType);
            param.put("paramDesc", (Object)varDesc);
            params.add((Object)param);
        }
        return params;
    }

    private void showCustomActionInfo(String config) {
        JSONObject ca = JSONObject.parseObject((String)config);
        String app = ca.getString("app");
        this.getModel().setValue(KEY_SERVICE_APP, (Object)app);
        this.getModel().setValue(KEY_SERVICE_NAME, (Object)ca.getString("serviceName"));
        this.getModel().setValue(KEY_ACTION_NAME, (Object)ca.getString("action"));
        if (ca.containsKey((Object)"operationId")) {
            this.getCache().put("operation_id", ca.getString("operationId"));
        }
        JSONArray inputParams = ca.getJSONArray("inputParams");
        this.showCustomActionParams("input", inputParams);
        JSONArray outputParams = ca.getJSONArray("outputParams");
        this.showCustomActionParams("output", outputParams);
    }

    private void showCustomActionParams(String type, JSONArray params) {
        String grid = "";
        String prefix = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"input")) {
            grid = KEY_INPUT_ENTITY;
            prefix = KEY_VAR_INPUT_PREFIX;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"output")) {
            grid = KEY_OUTPUT_ENTITY;
            prefix = KEY_VAR_OUTPUT_PREFIX;
        }
        this.getModel().deleteEntryData(grid);
        DynamicObjectCollection billEntityCollection = this.getModel().getEntryEntity(grid);
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(grid).getDynamicObjectType();
        if (params != null && !params.isEmpty()) {
            for (int i = 0; i < params.size(); ++i) {
                JSONObject param = params.getJSONObject(i);
                String varName = param.getString("paramName");
                String varType = param.getString("paramType");
                String varDesc = param.getString("paramDesc");
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set(String.format("%s%s", prefix, KEY_VAR_NAME), (Object)varName);
                dynamicObject.set(String.format("%s%s", prefix, KEY_VAR_TYPE), (Object)varType);
                dynamicObject.set(String.format("%s%s", prefix, KEY_VAR_DESC), (Object)varDesc);
                billEntityCollection.add((Object)dynamicObject);
            }
            this.getModel().updateEntryCache(billEntityCollection);
            this.getView().updateView(grid);
        }
    }

    private void selectCustomAction() {
        this.getView().setEnable(Boolean.FALSE, new String[]{CONTROL_NUMBER});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_THD_OPENAPI_CONFIG});
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTROL_THD_AUTH});
        this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOM_ACTION_CONFIG});
    }

    private void initToolTypeSelectCombo() {
        ArrayList<ToolConstant.ToolType> types = new ArrayList<ToolConstant.ToolType>();
        types.add(ToolConstant.ToolType.THIRD_OPENAPI);
        types.add(ToolConstant.ToolType.COSMIC_ACTION);
        ComboEdit selector = (ComboEdit)this.getControl(CONTROL_AGENT_TYPE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(types.size());
        for (ToolConstant.ToolType type : types) {
            ComboItem ci = new ComboItem();
            ci.setCaption(new LocaleString(type.getTypeName()));
            ci.setValue(type.getType());
            items.add(ci);
        }
        selector.setComboItems(items);
    }

    private void initCosmicAction() {
        this.initToolTypeSelectCombo();
        this.selectCustomAction();
    }
}

