/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.agent.tool;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GaiToolDeleteOperationPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        ArrayList<ExtendedDataEntity> passDataEntitys = new ArrayList<ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : e.getSelectedRows()) {
            if (!this.toolRefValidate(dataEntity)) continue;
            passDataEntitys.add(dataEntity);
        }
        e.getSelectedRows().clear();
        if (passDataEntitys.isEmpty()) {
            e.cancel = true;
        } else {
            e.getSelectedRows().addAll(passDataEntitys);
        }
    }

    private boolean toolRefValidate(ExtendedDataEntity dataEntity) {
        Object toolId = dataEntity.getDataEntity().getPkValue();
        String toolProp = String.format("%s.%s", "gai_agent_tool", "tool");
        QFilter filter = new QFilter(toolProp, "=", toolId);
        DynamicObject assistant = BusinessDataServiceHelper.loadSingle((String)"gai_agent", (String)("id,number,name," + toolProp), (QFilter[])new QFilter[]{filter});
        if (assistant != null) {
            String number = assistant.getString("number");
            String name = assistant.getString("name");
            this.addErrMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5177\u5df2\u7ecf\u88ab\u52a9\u624b(%s)\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"GaiToolDeleteOperationPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]), name));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "BeforeExecuteOperationTransactionSample", "is relation", errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

