/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.bill;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import kd.ai.gai.plugin.common.FormPulginUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;

public class GaiSensitiveWordsEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_WORDS = "words";
    private static final String KEY_WORDS_TAG = "words_tag";
    private static final String KEY_LBLLINES = "lbllines";
    private static final int MAX_LINE_COUNT = 100;
    private static final int MAX_LEN_PER_LINE = 100;
    private boolean isSetValueInPropertyChanged = false;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            args.setCancel(!this.validateSensitiveWords());
            this.getModel().setValue("status", (Object)BillStatus.C);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.validateSensitiveWords();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_WORDS_TAG) && !this.isSetValueInPropertyChanged) {
            this.validateSensitiveWordsInProertyChanged(e);
        }
        this.isSetValueInPropertyChanged = false;
    }

    private boolean validateSensitiveWordsInProertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String wordsValue = changeData.getNewValue().toString();
        List<String> listWords = this.getNewSensitiveWords(wordsValue);
        String newWords = this.getSensitiveWordsString(listWords);
        if (!newWords.equals(wordsValue)) {
            this.isSetValueInPropertyChanged = true;
            this.getModel().setValue(KEY_WORDS_TAG, (Object)newWords);
            this.getView().updateView(KEY_WORDS);
        }
        return this.validateSensitiveWords(listWords);
    }

    private boolean validateSensitiveWords() {
        String wordsValue = this.getModel().getValue(KEY_WORDS_TAG).toString();
        List<String> listWords = this.getNewSensitiveWords(wordsValue);
        String newWords = this.getSensitiveWordsString(listWords);
        if (!newWords.equals(wordsValue)) {
            this.getModel().setValue(KEY_WORDS_TAG, (Object)newWords);
            this.getView().updateView(KEY_WORDS);
        }
        return this.validateSensitiveWords(listWords);
    }

    private boolean validateSensitiveWords(List<String> listWords) {
        Label label = (Label)this.getControl(KEY_LBLLINES);
        label.setText(String.format("%s/%s\u884c", listWords.size(), 100));
        boolean bPass = listWords.size() <= 100;
        this.updateControlColor(bPass);
        if (!bPass) {
            this.getView().showTipNotification("\u8d85\u51fa\u654f\u611f\u8bcd\u884c\u6570\u9650\u5236\uff0c\u8bf7\u6309\u8981\u6c42\u586b\u5199\u3002");
        }
        return bPass;
    }

    private void updateControlColor(boolean bValidateStatus) {
        if (bValidateStatus) {
            FormPulginUtil.setForeColor(this.getView(), KEY_LBLLINES, Color.decode("#999999"));
            String sCustomStyleFieldBoderGray = "$>div.kd-cq-field-value-wrap{  border:1px solid #d9d9d9 }";
            FormPulginUtil.setCustomStyle(this.getView(), KEY_WORDS, sCustomStyleFieldBoderGray);
        } else {
            FormPulginUtil.setForeColor(this.getView(), KEY_LBLLINES, Color.red);
            String sCustomStyleFieldBoderRed = "$>div.kd-cq-field-value-wrap{  border:1px solid #ff0000 }";
            FormPulginUtil.setCustomStyle(this.getView(), KEY_WORDS, sCustomStyleFieldBoderRed);
        }
    }

    private List<String> getNewSensitiveWords(String wordsValue) {
        String[] words = wordsValue.split("\n");
        ArrayList listWords = new ArrayList(words.length);
        Collections.addAll(listWords, words);
        ListIterator iterator = listWords.listIterator();
        ArrayList<String> listNewWords = new ArrayList<String>(listWords.size());
        while (iterator.hasNext()) {
            String word = (String)iterator.next();
            if (!StringUtils.isNotEmpty((CharSequence)word)) continue;
            if (word.length() > 100) {
                word = word.substring(0, 100);
            }
            if (listNewWords.contains(word)) continue;
            listNewWords.add(word);
        }
        return listNewWords;
    }

    private String getSensitiveWordsString(List<String> listWords) {
        StringBuilder sbNewWords = new StringBuilder();
        for (String newWord : listWords) {
            sbNewWords.append(String.format("%s%s", newWord, "\n"));
        }
        return sbNewWords.toString();
    }
}

