/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.card;

import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.plugin.card.CardCustomStyle;
import kd.ai.gai.plugin.card.NavigationButtonKey;
import kd.ai.gai.plugin.card.NavigationCardData;
import kd.ai.gai.plugin.card.action.NavigationAction;
import kd.ai.gai.plugin.card.action.ShowFormAction;
import kd.ai.gai.plugin.common.FormPulginUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GaiCardNavigationPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
ClickListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiCardNavigationPlugin.class);
    private static final String KEY_ENTRY_NAVIGATION = "entry_navigation";
    private static final String KEY_CARDENTRYROWAP = "cardentryrowap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_NAVIGATION);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addClickListener((ClickListener)this);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{NavigationButtonKey.BUTTONAP_ONE.getFlexkey(), NavigationButtonKey.BUTTONAP_ONE.getButtonKey(), NavigationButtonKey.BUTTONAP_ONE.getVectorkey(), NavigationButtonKey.BUTTONAP_ONE.getFlexTxtButtonKey(), NavigationButtonKey.BUTTONAP_TWO.getFlexkey(), NavigationButtonKey.BUTTONAP_TWO.getButtonKey(), NavigationButtonKey.BUTTONAP_TWO.getVectorkey(), NavigationButtonKey.BUTTONAP_TWO.getFlexTxtButtonKey(), NavigationButtonKey.BUTTONAP_THREE.getFlexkey(), NavigationButtonKey.BUTTONAP_THREE.getButtonKey(), NavigationButtonKey.BUTTONAP_THREE.getVectorkey(), NavigationButtonKey.BUTTONAP_THREE.getFlexTxtButtonKey()});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadNavigation();
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put("createOrg", String.valueOf(orgId));
    }

    private void loadNavigation() {
        CardCustomStyle cardCustomStyle = new CardCustomStyle();
        List<NavigationCardData> navigationCardDataList = NavigationCardData.getNavigationCardDataList();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_NAVIGATION);
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_NAVIGATION);
        rows.clear();
        for (int i = 0; i < navigationCardDataList.size(); ++i) {
            NavigationCardData cardData = navigationCardDataList.get(i);
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("name", (Object)cardData.getName());
            row.set("desc", (Object)cardData.getDesc());
            row.set("txt_button_one", (Object)cardData.getButtonName(NavigationButtonKey.BUTTONAP_ONE));
            row.set("txt_button_two", (Object)cardData.getButtonName(NavigationButtonKey.BUTTONAP_TWO));
            row.set("txt_button_three", (Object)cardData.getButtonName(NavigationButtonKey.BUTTONAP_THREE));
            rows.add((Object)row);
            cardCustomStyle.setCardRowStyle(i, cardData);
        }
        FormPulginUtil.setCustomStyle(this.getView(), KEY_CARDENTRYROWAP, cardCustomStyle.getStyle());
    }

    public void entryRowClick(RowClickEvent evt) {
        int iRowIndex = evt.getRow();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_NAVIGATION);
        DynamicObject row = (DynamicObject)rows.get(iRowIndex);
        NavigationCardData cardData = NavigationCardData.getNavigationCardData(row.getString("name"));
        if (cardData != null && cardData.getCardAction() != null) {
            cardData.getCardAction().operate(this.getView());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Container || evt.getSource() instanceof Button || evt.getSource() instanceof Vector) {
            String key = ((Control)evt.getSource()).getKey();
            this.cardEntryOperate(key);
        }
    }

    private void cardEntryOperate(String key) {
        NavigationButtonKey buttonKey = NavigationButtonKey.parse(key);
        if (buttonKey == null) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY_NAVIGATION);
        int[] selRowIndex = cardEntry.getSelectRows();
        if (selRowIndex.length == 0) {
            return;
        }
        String cardname = cardEntry.getEntryData().getDataEntitys()[selRowIndex[0]].getString("name");
        NavigationCardData cardData = NavigationCardData.getNavigationCardData(cardname);
        if (cardData == null) {
            return;
        }
        NavigationAction buttonAction = cardData.getButtonAction(buttonKey);
        if (buttonAction != null) {
            if (buttonAction instanceof ShowFormAction) {
                ShowFormAction showFormAction = (ShowFormAction)buttonAction;
                if (StringUtils.equalsIgnoreCase((CharSequence)showFormAction.getFormId(), (CharSequence)GaiFormIdEnum.GAI_AGENT_BASE.getId())) {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.getOpenStyle().setShowType(ShowType.Modal);
                    fsp.setFormId(GaiFormIdEnum.GAI_AGENT_BASE.getId());
                    fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
                    this.getView().showForm(fsp);
                } else {
                    buttonAction.operate(this.getView());
                }
            } else {
                buttonAction.operate(this.getView());
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.cardEntryOperate(hyperLinkClickEvent.getFieldName());
    }
}

