/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.card.action;

import kd.ai.gai.plugin.card.action.ShowFormAction;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;

public class ShowBillAction
extends ShowFormAction {
    private Object pkId;
    private OperationStatus operationStatus;

    public ShowBillAction(String formId, ShowType showType) {
        super(formId, showType);
        this.operationStatus = OperationStatus.ADDNEW;
    }

    public ShowBillAction(String formId, ShowType showType, Object pkId, OperationStatus status) {
        super(formId, showType);
        this.pkId = pkId;
        if (status == OperationStatus.ADDNEW) {
            status = OperationStatus.VIEW;
        }
        this.operationStatus = status;
    }

    @Override
    public void operate(IFormView view) {
        this.showForm(view);
    }

    private void showForm(IFormView view) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(this.formId);
        billShowParameter.getOpenStyle().setShowType(this.showType);
        billShowParameter.setStatus(this.operationStatus);
        if (StringUtils.isNotEmpty((CharSequence)this.targetKey)) {
            billShowParameter.getOpenStyle().setTargetKey(this.targetKey);
        }
        if (this.pkId != null) {
            billShowParameter.setPkId(this.pkId);
            billShowParameter.setPageId(this.getBillPageId(view));
        }
        view.showForm((FormShowParameter)billShowParameter);
    }

    private String getBillPageId(IFormView currentView) {
        String pkValue = this.pkId.toString().replace("/", "");
        return currentView.getPageId() + "_" + this.formId + "_" + pkValue;
    }
}

