/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.services.FlowEventService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;

public class FlowDesigner {
    private static final String INPUTS_NODE = "inputs";
    private static final String OUTPUTS_NODE = "outputs";
    private ModelService modelService;
    private FlowEditingContext flowEditingContext;
    private FlowEventService eventService;

    public FlowEditingContext getEditingContext() {
        return this.flowEditingContext;
    }

    public FlowDesigner(IFormView processView) {
        FlowEditingContext.initContext(processView, processView);
        this.flowEditingContext = FlowEditingContext.get();
        this.modelService = this.flowEditingContext.getService(ModelService.class);
        this.eventService = this.flowEditingContext.getService(FlowEventService.class);
    }

    public void handleFlowEvent(String eventName, String eventArgs) {
        this.eventService.invokeEvent(eventName, eventArgs);
    }

    public void initFlow() {
        Flow flow = this.modelService.getFlow();
        if (flow == null) {
            flow = new Flow();
            flow.initNewFlow();
            this.initSystemVar(flow);
            flow.getStart().setName(ResManager.loadKDString((String)"\u8f93\u5165", (String)"GaiProcessPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            flow.getStart().setDesc(ResManager.loadKDString((String)"\u8f93\u5165", (String)"GaiProcessPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            flow.getEnd().setName(ResManager.loadKDString((String)"\u8f93\u51fa", (String)"GaiProcessPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
            flow.getEnd().setDesc(ResManager.loadKDString((String)"\u8f93\u51fa", (String)"GaiProcessPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
            this.modelService.updateFlow(flow);
        } else {
            this.initSystemVar(flow);
            this.compatibleWithOldData(flow);
            this.modelService.updateFlow(flow);
        }
    }

    private void initSystemVar(Flow flow) {
        ArrayList<Var> inputVars = flow.getStart().getInputVars();
        if (inputVars == null) {
            inputVars = new ArrayList<Var>(10);
        }
        if (!this.containsVar((List<Var>)inputVars, "system.chat_sessionid")) {
            inputVars.add(0, new Var("system.chat_sessionid", VarFieldType.STRING.getType(), ResManager.loadKDString((String)"\u4f1a\u8bddID", (String)"GaiProcessPlugin_9", (String)"ai-gai-plugin", (Object[])new Object[0])));
        }
        if (!this.containsVar(inputVars, "system.chat_history")) {
            inputVars.add(0, new Var("system.chat_history", VarFieldType.STRING.getType(), ResManager.loadKDString((String)"\u5bf9\u8bdd\u5386\u53f2", (String)"GaiProcessPlugin_10", (String)"ai-gai-plugin", (Object[])new Object[0])));
        }
        if (!this.containsVar(inputVars, "system.user_input")) {
            inputVars.add(0, new Var("system.user_input", VarFieldType.STRING.getType(), ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165", (String)"GaiProcessPlugin_11", (String)"ai-gai-plugin", (Object[])new Object[0])));
        }
        flow.getStart().setInputVars(inputVars);
    }

    private boolean containsVar(List<Var> inputVars, String key) {
        if (inputVars == null || inputVars.isEmpty() || StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        for (Var var : inputVars) {
            if (!key.equals(var.getName())) continue;
            return true;
        }
        return false;
    }

    private void compatibleWithOldData(Flow flow) {
        if ("start".equals(flow.getStart().getName())) {
            flow.getStart().setName(INPUTS_NODE);
            flow.getStart().setDesc(INPUTS_NODE);
        }
        if ("end".equals(flow.getEnd().getName())) {
            flow.getEnd().setName(OUTPUTS_NODE);
            flow.getEnd().setDesc(OUTPUTS_NODE);
        }
    }

    public void release() {
        FlowEditingContext.release();
    }

    public void lockFlow() {
        this.getEditingContext().getService(ViewService.class).lockFlow();
    }
}

