/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Condition;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.FlowEditingContext;
import kd.ai.gai.plugin.flow.model.NodeDataManager;
import kd.ai.gai.plugin.flow.model.RefrenceParamManager;
import kd.ai.gai.plugin.flow.model.ValidateInfoManager;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ValidateService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;

public class NodePropertyDesigner {
    private static final String KEY_NAME = "name";
    private static final String KEY_DESC = "desc";
    private AbstractGaiProcessSetPlugin designerPlugin;
    private FlowEditingContext flowEditingContext;
    private NodeDataManager nodeDataManager;
    private ValidateService validateService;
    private boolean isDataLoadedFromCache;
    private IFormView nodePropertyView;
    private int nodeId;
    private ProcessNodeType nodeType;

    public NodePropertyDesigner(IFormView view) {
        this.initialize(view);
    }

    final void initialize(IFormView view) {
        this.nodePropertyView = view;
        this.designerPlugin = this.getNodeDesignerPlugin(this.nodePropertyView);
        this.nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        int type = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeType");
        this.nodeType = ProcessNodeType.valueOf((int)type);
    }

    private AbstractGaiProcessSetPlugin getNodeDesignerPlugin(IFormView view) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof AbstractGaiProcessSetPlugin)) continue;
            return (AbstractGaiProcessSetPlugin)plugin;
        }
        return null;
    }

    public IFormView getView() {
        return this.nodePropertyView;
    }

    public IDataModel getModel() {
        return this.nodePropertyView.getModel();
    }

    public FlowEditingContext getFlowEditingContext() {
        if (this.flowEditingContext == null) {
            FlowEditingContext.initContext(this.getView().getParentView(), this.getView());
            this.flowEditingContext = FlowEditingContext.get();
        }
        return this.flowEditingContext;
    }

    public NodeDataManager getNodeDataManager() {
        if (this.nodeDataManager == null) {
            this.nodeDataManager = this.getFlowEditingContext().getService(ModelService.class).getNodeDataManager();
        }
        return this.nodeDataManager;
    }

    public RefrenceParamManager getRefrenceParamManager() {
        return this.getFlowEditingContext().getService(ModelService.class).getRefrenceParamManager();
    }

    public ValidateInfoManager getValidateInfoManager() {
        return this.getFlowEditingContext().getService(ModelService.class).getValidateInfoManager();
    }

    public ValidateService getValidateService() {
        if (this.validateService == null) {
            this.validateService = this.getFlowEditingContext().getService(ValidateService.class);
        }
        return this.validateService;
    }

    public Flow getFlow() {
        return this.getFlowEditingContext().getService(ModelService.class).getFlow();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public ProcessNodeType getNodeType() {
        return this.nodeType;
    }

    public DynamicObject loadEntityFromCache() {
        NodeConfigData data = this.getNodeDataManager().get(this.getNodeId());
        DynamicObject nodeEntity = null;
        if (data != null) {
            nodeEntity = data.deSerializeDataEntity();
        }
        this.isDataLoadedFromCache = nodeEntity != null;
        return nodeEntity;
    }

    public void initData() {
        if (this.isDataLoadedFromCache) {
            return;
        }
        Flow flow = this.getFlow();
        int nodeId = this.getNodeId();
        String nodeName = "";
        String desc = "";
        if (this.getNodeType() == ProcessNodeType.Condition) {
            if (!flow.isExistsTransfer(nodeId)) {
                return;
            }
            Transfer transfer = flow.findTransferById(nodeId);
            nodeName = ResManager.loadKDString((String)"\u6761\u4ef6", (String)"GaiProcessPlugin_5", (String)"ai-gai-plugin", (Object[])new Object[0]);
            if (transfer.getCondition() != null) {
                nodeName = transfer.getCondition().getName();
                desc = transfer.getCondition().getDesc();
            }
        } else {
            if (!flow.isExistsNode(nodeId)) {
                return;
            }
            Node node = flow.findNodeById(nodeId);
            nodeName = node.getName();
            desc = node.getDesc();
        }
        this.getModel().setValue(KEY_NAME, (Object)nodeName);
        this.getModel().setValue(KEY_DESC, (Object)desc);
        this.designerPlugin.initData();
    }

    public void saveNodeData() {
        NodeValidateInfo validateInfo = this.designerPlugin.nodeValidate(this.getNodeType(), this.getNodeId());
        this.getValidateInfoManager().addNodeValidateInfo(validateInfo);
        if (!validateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) {
            NodeConfigData nodeConfigData = new NodeConfigData();
            nodeConfigData.setNodeId(this.getNodeId());
            nodeConfigData.setConfigViewPageId(this.getView().getPageId());
            nodeConfigData.setDataEntityToBase64(this.getModel().getDataEntity(true));
            this.getNodeDataManager().add(nodeConfigData);
        } else {
            if (!this.getModel().getDataChanged()) {
                return;
            }
            this.getNodeDataManager().remove(this.getNodeId());
            Flow flow = this.getFlow();
            this.designerPlugin.saveDataToFlow(flow);
            this.updateNodeName(flow);
            this.getFlowEditingContext().getService(ModelService.class).updateFlow(flow);
        }
        this.getValidateService().sendNodeValidateInfos();
    }

    private void updateNodeName(Flow flow) {
        if (this.getNodeType() == ProcessNodeType.Condition) {
            Transfer transfer = flow.findTransferById(this.getNodeId());
            Condition condition = transfer.getCondition();
            if (condition != null) {
                condition.setName(this.getModel().getDataEntity().getString(KEY_NAME));
                condition.setDesc(this.getModel().getDataEntity().getString(KEY_DESC));
            }
        } else {
            Node node = flow.findNodeById(this.getNodeId());
            if (node != null) {
                node.setName(this.getModel().getDataEntity().getString(KEY_NAME));
                node.setDesc(this.getModel().getDataEntity().getString(KEY_DESC));
            }
        }
    }

    public void sendModifyNameAction(String nodeName) {
        CustomControlAction action = new CustomControlAction("modifyName");
        JSONObject jsonValue = new JSONObject();
        jsonValue.put("nodeId", (Object)this.getNodeId());
        jsonValue.put("nodeName", (Object)nodeName);
        action.setValue(jsonValue);
        this.getFlowEditingContext().getService(FlowActionService.class).sendAction(action);
    }

    public void release() {
        FlowEditingContext.release();
    }
}

