/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.model;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;

public class NodeDataManager {
    private static final String CACHEKEY_NODECACHE_PREFIX = "nodecache";
    private IPageCache pageCache;
    private IDataModel processModel;

    public IDataModel getProcessModel() {
        return this.processModel;
    }

    public NodeDataManager(IPageCache pageCache, IDataModel processModel) {
        this.pageCache = pageCache;
        this.processModel = processModel;
    }

    public void add(NodeConfigData data) {
        this.pageCache.put(NodeDataManager.getNodeCacheKey(data.getNodeId()), JSON.toJSONString((Object)data));
    }

    public void clear() {
        Map allCache = this.pageCache.getAll();
        ArrayList toRemoveKeyList = new ArrayList(allCache.size());
        for (Map.Entry entry : allCache.entrySet()) {
            if (!((String)entry.getKey()).startsWith(CACHEKEY_NODECACHE_PREFIX)) continue;
            toRemoveKeyList.add(entry.getKey());
        }
        this.pageCache.batchRemove(toRemoveKeyList);
    }

    public void remove(List<Integer> nodeIdList) {
        for (Integer nodeId : nodeIdList) {
            this.remove(nodeId);
        }
    }

    public void remove(int nodeId) {
        this.pageCache.remove(NodeDataManager.getNodeCacheKey(nodeId));
    }

    public NodeConfigData get(int nodeId) {
        String node = this.pageCache.get(NodeDataManager.getNodeCacheKey(nodeId));
        if (StringUtils.isNotEmpty((CharSequence)node)) {
            return (NodeConfigData)JSON.parseObject((String)node, NodeConfigData.class);
        }
        return null;
    }

    private static String getNodeCacheKey(int nodeId) {
        return String.format("%s-%s", CACHEKEY_NODECACHE_PREFIX, nodeId);
    }
}

