/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ProcessNode;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.CusOptionNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.EndNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.LLMNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.MessageNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.StartNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.TransferRefrence;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;

public class RefrenceParamManager {
    private static final Map<ProcessNodeType, String> nodeRefrenceMap = new EnumMap<ProcessNodeType, String>(ProcessNodeType.class);
    private ModelService modelService;
    private RefrenceDataConfig refrenceDataConfig;

    public RefrenceParamManager(ModelService modelService, RefrenceDataConfig refrenceDataConfig) {
        this.modelService = modelService;
        this.refrenceDataConfig = refrenceDataConfig;
    }

    public List<RefrenceParam> getCanRefrenceParamList(int nodeId) {
        return this.getCanRefrenceParamList(nodeId, this.refrenceDataConfig);
    }

    public List<RefrenceParam> getCanRefrenceParamList(int nodeId, RefrenceDataConfig config) {
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>(10);
        Flow flow = this.modelService.getFlow();
        boolean includeSelfNode = false;
        if (flow.isExistsTransfer(nodeId)) {
            Transfer transfer = flow.findTransferById(nodeId);
            nodeId = transfer.getFromNodeId();
            includeSelfNode = true;
        }
        List upNodesList = flow.allUpProcessNodes(nodeId, includeSelfNode);
        if (config == null) {
            config = this.refrenceDataConfig;
        }
        for (ProcessNode processNode : upNodesList) {
            Node node = flow.findNodeById(processNode.getNodeId());
            List<ProcessNodeType> onlyNodeType = config.getOnlyNodeTypeList();
            if (onlyNodeType != null && !onlyNodeType.isEmpty() && !onlyNodeType.contains(node.getNodeType())) continue;
            AbstractNodeRefrence abstractNodeRefrence = RefrenceParamManager.getNodeRefrenceInstance(node.getNodeType());
            abstractNodeRefrence.setModelService(this.modelService);
            abstractNodeRefrence.setNode(node);
            List<RefrenceParam> nodeRefrenceParam = abstractNodeRefrence.getOutRefrenceParams(config);
            List<String> onlyParamType = config.getOnlyParamTypeList();
            if (onlyParamType != null && !onlyParamType.isEmpty()) {
                nodeRefrenceParam.removeIf(param -> !onlyParamType.contains(param.getParamType()));
            }
            refrenceParamList.addAll(nodeRefrenceParam);
        }
        return refrenceParamList;
    }

    private NodeValidateInfo validateOneNodeRefrenceParam(Node node) {
        AbstractNodeRefrence abstractNodeRefrence = RefrenceParamManager.getNodeRefrenceInstance(node.getNodeType());
        abstractNodeRefrence.setModelService(this.modelService);
        abstractNodeRefrence.setNode(node);
        String sValidateMessage = abstractNodeRefrence.validateInRefrenceParams();
        return this.createNodeValidateInfo(node.getId(), sValidateMessage);
    }

    private NodeValidateInfo createNodeValidateInfo(int nodeId, String sValidMessage) {
        if (!StringUtils.isEmpty((CharSequence)sValidMessage)) {
            NodeValidateInfo nodeValidateInfo = new NodeValidateInfo();
            nodeValidateInfo.setNodeId(nodeId);
            nodeValidateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            nodeValidateInfo.setValidMessage(sValidMessage);
            return nodeValidateInfo;
        }
        NodeValidateInfo nodeValidateInfo = new NodeValidateInfo();
        nodeValidateInfo.setNodeId(nodeId);
        nodeValidateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        nodeValidateInfo.setValidMessage("");
        return nodeValidateInfo;
    }

    public List<NodeValidateInfo> validateOneNodeRefrenceParam(int nodeId) {
        Flow flow = this.modelService.getFlow();
        if (!flow.isExistsNode(nodeId)) {
            return Collections.emptyList();
        }
        Node node = flow.findNodeById(nodeId);
        ArrayList<NodeValidateInfo> validateInfoList = new ArrayList<NodeValidateInfo>(1);
        NodeValidateInfo nodeValidateInfo = this.validateOneNodeRefrenceParam(node);
        validateInfoList.add(nodeValidateInfo);
        List outTransferIdList = node.getTransferOutList();
        if (outTransferIdList != null && !outTransferIdList.isEmpty()) {
            for (Integer transferId : outTransferIdList) {
                if (!flow.isExistsTransfer(transferId.intValue())) continue;
                Transfer transfer = flow.findTransferById(transferId.intValue());
                NodeValidateInfo transferValidateInfo = this.validateTransferRefrenceParam(transfer);
                validateInfoList.add(transferValidateInfo);
            }
        }
        return validateInfoList;
    }

    public List<NodeValidateInfo> validateNodesRefrenceParam(int parentNodeId) {
        Flow flow = this.modelService.getFlow();
        if (!flow.isExistsNode(parentNodeId)) {
            return Collections.emptyList();
        }
        Node parentNode = flow.findNodeById(parentNodeId);
        List childNodes = flow.getAllChildNodes(parentNodeId);
        childNodes.add(0, parentNode);
        return this.validateSpecifyNodesRefrenceParam(childNodes);
    }

    public List<NodeValidateInfo> validateSpecifyNodesRefrenceParam(List<Node> nodes) {
        ArrayList<NodeValidateInfo> validateInfoList = new ArrayList<NodeValidateInfo>(nodes.size());
        for (Node node : nodes) {
            List<NodeValidateInfo> list = this.validateOneNodeRefrenceParam(node.getId());
            validateInfoList.addAll(list);
        }
        return validateInfoList;
    }

    public NodeValidateInfo validateTransferRefrenceParam(Transfer transfer) {
        TransferRefrence transferRefrence = new TransferRefrence();
        transferRefrence.setModelService(this.modelService);
        transferRefrence.setTransfer(transfer);
        String sValidateMessage = transferRefrence.validateInRefrenceParams();
        return this.createNodeValidateInfo(transfer.getId(), sValidateMessage);
    }

    private static AbstractNodeRefrence getNodeRefrenceInstance(ProcessNodeType nodeType) {
        String className = nodeRefrenceMap.get(nodeType);
        if (className == null) {
            throw new KDBizException(String.format("\u8282\u70b9\u7c7b\u578b[%s]\u5bf9\u5e94\u7684\u8282\u70b9\u53c2\u6570\u5904\u7406\u5668\u5b9e\u73b0\u672a\u627e\u5230", nodeType.getName()));
        }
        return (AbstractNodeRefrence)TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        nodeRefrenceMap.put(ProcessNodeType.Start, StartNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.End, EndNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Llm, LLMNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.CusOption, CusOptionNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.Message, MessageNodeRefrence.class.getName());
        nodeRefrenceMap.put(ProcessNodeType.PresetOption, CusOptionNodeRefrence.class.getName());
    }
}

