/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;

public class ValidateInfoManager {
    private static final String CACHEKEY_NODE_VALIDATE_INFO_MAP = "node_validate_info_map";
    private static final String CACHEKEY_NODE_REFRENCE_PARAM_VALIDATE_INFO_MAP = "node_refrence_param_validate_info_map";
    private Map<Integer, NodeValidateInfo> nodeValidateInfoMap = new HashMap<Integer, NodeValidateInfo>();
    private Map<Integer, NodeValidateInfo> nodeRefrenceParamValidateInfoMap = new HashMap<Integer, NodeValidateInfo>();
    private Map<Integer, NodeValidateInfo> newNodeValidateInfoMap = new HashMap<Integer, NodeValidateInfo>();
    private Map<Integer, NodeValidateInfo> newNodeRefrenceParamValidateInfoMap = new HashMap<Integer, NodeValidateInfo>();
    private IPageCache pageCache;

    public ValidateInfoManager(IPageCache pageCache) {
        this.pageCache = pageCache;
        this.initValidateInfos();
    }

    private void initValidateInfos() {
        String sCache;
        String sNodeValidateInfoCache = this.pageCache.get(CACHEKEY_NODE_VALIDATE_INFO_MAP);
        if (StringUtils.isNotEmpty((CharSequence)sNodeValidateInfoCache)) {
            this.nodeValidateInfoMap = (Map)JSON.parseObject((String)sNodeValidateInfoCache, (TypeReference)new TypeReference<Map<Integer, NodeValidateInfo>>(){}, (Feature[])new Feature[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sCache = this.pageCache.get(CACHEKEY_NODE_REFRENCE_PARAM_VALIDATE_INFO_MAP)))) {
            this.nodeRefrenceParamValidateInfoMap = (Map)JSON.parseObject((String)sCache, (TypeReference)new TypeReference<Map<Integer, NodeValidateInfo>>(){}, (Feature[])new Feature[0]);
        }
    }

    public NodeValidateInfo getNodeValidateInfo(int nodeId) {
        NodeValidateInfo nodeValidateInfo = this.newNodeValidateInfoMap.getOrDefault(nodeId, null);
        if (nodeValidateInfo == null) {
            nodeValidateInfo = this.nodeValidateInfoMap.getOrDefault(nodeId, null);
        }
        NodeValidateInfo nodeRefrenceParamValidateInfo = this.nodeRefrenceParamValidateInfoMap.getOrDefault(nodeId, null);
        return this.mergeOneNodeValidateInfo(nodeValidateInfo, nodeRefrenceParamValidateInfo);
    }

    public void addNodeValidateInfo(NodeValidateInfo newValidateInfo) {
        if (newValidateInfo == null) {
            return;
        }
        NodeValidateInfo oldValidateInfo = this.newNodeValidateInfoMap.getOrDefault(newValidateInfo.getNodeId(), null);
        if (oldValidateInfo != null) {
            newValidateInfo = this.mergeOneNodeValidateInfo(newValidateInfo, oldValidateInfo);
        }
        this.newNodeValidateInfoMap.put(newValidateInfo.getNodeId(), newValidateInfo);
    }

    public void addNodeRefrenceParamValidateInfo(NodeValidateInfo newValidateInfo) {
        if (newValidateInfo == null) {
            return;
        }
        this.newNodeRefrenceParamValidateInfoMap.put(newValidateInfo.getNodeId(), newValidateInfo);
    }

    public void addNodeRefrenceParamValidateInfo(List<NodeValidateInfo> newValidateInfoList) {
        for (NodeValidateInfo newValidateInfo : newValidateInfoList) {
            this.addNodeRefrenceParamValidateInfo(newValidateInfo);
        }
    }

    public void remove(List<Integer> nodeIdList) {
        for (Integer nodeId : nodeIdList) {
            this.nodeValidateInfoMap.remove(nodeId);
            this.nodeRefrenceParamValidateInfoMap.remove(nodeId);
            this.newNodeValidateInfoMap.remove(nodeId);
            this.newNodeRefrenceParamValidateInfoMap.remove(nodeId);
            this.save();
        }
    }

    public void clear() {
        this.pageCache.remove(CACHEKEY_NODE_VALIDATE_INFO_MAP);
        this.pageCache.remove(CACHEKEY_NODE_REFRENCE_PARAM_VALIDATE_INFO_MAP);
    }

    public List<NodeValidateInfo> mergeAllValidateInfos() {
        int nodeId;
        ArrayList<NodeValidateInfo> mergeNodeValidateInfoList = new ArrayList<NodeValidateInfo>(this.newNodeValidateInfoMap.size() + this.newNodeRefrenceParamValidateInfoMap.size());
        ArrayList<Integer> nodeIdList = new ArrayList<Integer>(mergeNodeValidateInfoList.size());
        for (Map.Entry<Integer, NodeValidateInfo> entry : this.newNodeValidateInfoMap.entrySet()) {
            NodeValidateInfo nodeValidateInfo = entry.getValue();
            nodeId = entry.getKey();
            NodeValidateInfo nodeRefrenceParamValidateInfo = this.newNodeRefrenceParamValidateInfoMap.getOrDefault(nodeId, null);
            NodeValidateInfo mergeNodeValidateInfo = this.mergeOneNodeValidateInfo(nodeValidateInfo, nodeRefrenceParamValidateInfo);
            mergeNodeValidateInfoList.add(mergeNodeValidateInfo);
            nodeIdList.add(nodeId);
        }
        for (Map.Entry<Integer, NodeValidateInfo> entry : this.newNodeRefrenceParamValidateInfoMap.entrySet()) {
            NodeValidateInfo nodeRefrenceParamValidateInfo = entry.getValue();
            nodeId = entry.getKey();
            if (nodeIdList.contains(nodeId)) continue;
            NodeValidateInfo mergeNodeValidateInfo = this.mergeOneNodeValidateInfo(this.nodeValidateInfoMap.getOrDefault(nodeId, null), nodeRefrenceParamValidateInfo);
            mergeNodeValidateInfoList.add(mergeNodeValidateInfo);
            nodeIdList.add(nodeId);
        }
        ListIterator listIterator = mergeNodeValidateInfoList.listIterator();
        while (listIterator.hasNext()) {
            NodeValidateInfo validateInfo = (NodeValidateInfo)listIterator.next();
            NodeValidateInfo oldMergeValidateInfo = this.mergeOneNodeValidateInfo(this.nodeValidateInfoMap.getOrDefault(validateInfo.getNodeId(), null), this.nodeRefrenceParamValidateInfoMap.getOrDefault(validateInfo.getNodeId(), null));
            if (oldMergeValidateInfo == null) {
                if (!validateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) continue;
                listIterator.remove();
                continue;
            }
            if (!validateInfo.getStatus().equals(oldMergeValidateInfo.getStatus()) || !validateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue()) && !validateInfo.getValidMessage().equals(oldMergeValidateInfo.getValidMessage())) continue;
            listIterator.remove();
        }
        this.save();
        return mergeNodeValidateInfoList;
    }

    private NodeValidateInfo mergeOneNodeValidateInfo(NodeValidateInfo nodeValidateInfo1, NodeValidateInfo nodeValidateInfo2) {
        NodeValidateInfo nodeRefrenceParamValidateInfo;
        NodeValidateInfo nodeValidateInfo = nodeValidateInfo1 == null ? null : nodeValidateInfo1.copy();
        NodeValidateInfo nodeValidateInfo3 = nodeRefrenceParamValidateInfo = nodeValidateInfo2 == null ? null : nodeValidateInfo2.copy();
        if (nodeValidateInfo == null) {
            return nodeRefrenceParamValidateInfo;
        }
        if (nodeRefrenceParamValidateInfo == null) {
            return nodeValidateInfo;
        }
        if (nodeValidateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) {
            return nodeRefrenceParamValidateInfo;
        }
        if (!nodeRefrenceParamValidateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) {
            String sValidMessage = String.format("%s\n%s", nodeValidateInfo.getValidMessage(), nodeRefrenceParamValidateInfo.getValidMessage());
            nodeValidateInfo.setValidMessage(sValidMessage);
        }
        return nodeValidateInfo;
    }

    private void save() {
        for (Map.Entry<Integer, NodeValidateInfo> entry : this.newNodeValidateInfoMap.entrySet()) {
            this.nodeValidateInfoMap.put(entry.getKey(), entry.getValue());
        }
        ArrayList<Integer> removeKeyList = new ArrayList<Integer>(this.newNodeRefrenceParamValidateInfoMap.size());
        for (Map.Entry<Integer, NodeValidateInfo> entry : this.newNodeRefrenceParamValidateInfoMap.entrySet()) {
            this.nodeRefrenceParamValidateInfoMap.put(entry.getKey(), entry.getValue());
            if (!entry.getValue().getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) continue;
            removeKeyList.add(entry.getKey());
        }
        for (Integer key : removeKeyList) {
            this.nodeRefrenceParamValidateInfoMap.remove(key);
        }
        this.pageCache.put(CACHEKEY_NODE_VALIDATE_INFO_MAP, JSON.toJSONString(this.nodeValidateInfoMap));
        this.pageCache.put(CACHEKEY_NODE_REFRENCE_PARAM_VALIDATE_INFO_MAP, JSON.toJSONString(this.nodeRefrenceParamValidateInfoMap));
    }
}

