/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.INodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateResult;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateStatus;
import kd.ai.gai.plugin.flow.services.ModelService;

public class AbstractNodeRefrence
implements INodeRefrence {
    private ModelService modelService;
    private Node node;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    protected ModelService getModelService() {
        return this.modelService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    protected List<String> getCanRefrenceParamValueList() {
        List<RefrenceParam> canRefrenceParamList = this.getModelService().getRefrenceParamManager().getCanRefrenceParamList(this.getNode().getId());
        ArrayList<String> canRefrenceParamsValue = new ArrayList<String>(canRefrenceParamList.size());
        for (RefrenceParam param : canRefrenceParamList) {
            canRefrenceParamsValue.add(param.getParamValue());
        }
        return canRefrenceParamsValue;
    }

    @Override
    public List<RefrenceParam> getOutRefrenceParams(RefrenceDataConfig config) {
        return Collections.emptyList();
    }

    @Override
    public String validateInRefrenceParams() {
        return "";
    }

    protected RefrenceParamValidateResult validateRefrenceParam(int refrenceNodeId, String paramName) {
        RefrenceParamValidateResult result = new RefrenceParamValidateResult();
        Node refrenceNode = null;
        Flow flow = this.modelService.getFlow();
        boolean bNodeDelete = false;
        if (flow.isExistsNode(refrenceNodeId)) {
            refrenceNode = flow.findNodeById(refrenceNodeId);
            RefrenceParam param = RefrenceParam.create(refrenceNode, paramName);
            result.setRefrenceParam(param);
            result.setRefrenceNode(refrenceNode);
        } else {
            bNodeDelete = true;
        }
        if (bNodeDelete) {
            result.setStatus(RefrenceParamValidateStatus.NODE_NOTEXISTS);
        } else {
            List<String> canRefrenceParamsValue = this.getCanRefrenceParamValueList();
            if (canRefrenceParamsValue.contains(result.getRefrenceParam().getParamValue())) {
                result.setStatus(RefrenceParamValidateStatus.PASS);
            } else if (this.isChildOfParent(result.getRefrenceNode())) {
                result.setStatus(RefrenceParamValidateStatus.PARAM_NOTEXISTS);
            } else {
                result.setStatus(RefrenceParamValidateStatus.NODE_NOTPARENT);
            }
        }
        return result;
    }

    private boolean isChildOfParent(Node parentNode) {
        Flow flow = this.modelService.getFlow();
        List childNodes = flow.getAllChildNodes(parentNode.getId());
        for (Node childNode : childNodes) {
            if (childNode.getId() != this.getNode().getId()) continue;
            return true;
        }
        return false;
    }
}

