/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateResult;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CusOptionNodeRefrence
extends AbstractNodeRefrence {
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_OUTPUT_NAME = "output_name";
    protected static final String KEY_OUTPUT_TYPE = "output_type";

    @Override
    public List<RefrenceParam> getOutRefrenceParams(RefrenceDataConfig config) {
        DynamicObjectCollection outEntry;
        long actionId = ((JavaPluginAction)this.getNode()).getActionId();
        DynamicObject operation = null;
        NodeConfigData nodeConfigData = this.getModelService().getNodeDataManager().get(this.getNode().getId());
        if (nodeConfigData != null && nodeConfigData.deSerializeData() != null) {
            operation = nodeConfigData.deSerializeData();
        } else if (actionId > 0L) {
            operation = BusinessDataServiceHelper.loadSingleFromCache((Object)actionId, (String)ENTITY_OPERATION);
        }
        DynamicObjectCollection dynamicObjectCollection = outEntry = operation == null ? null : operation.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTPUT);
        if (outEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>(outEntry.size());
        for (DynamicObject out : outEntry) {
            String name = out.getString(KEY_OUTPUT_NAME);
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            RefrenceParam param = RefrenceParam.create(this.getNode(), name);
            param.setParamType(out.getString(KEY_OUTPUT_TYPE));
            refrenceParamList.add(param);
        }
        return refrenceParamList;
    }

    @Override
    public String validateInRefrenceParams() {
        List varMapperList = ((JavaPluginAction)this.getNode()).getInParamMap();
        if (varMapperList == null || varMapperList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < varMapperList.size(); ++i) {
            String sRefrenceValue;
            VarMapper varMapper = (VarMapper)varMapperList.get(i);
            RefrenceParamValidateResult result = this.validateRefrenceParam(varMapper.getOutNodeId(), varMapper.getOutVarName());
            String sRefrenceDisplayName = sRefrenceValue = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
            if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
                sRefrenceValue = result.getRefrenceParam().getParamValue();
                sRefrenceDisplayName = result.getRefrenceParam().getParamDisplayName();
            }
            switch (result.getStatus()) {
                case NODE_NOTEXISTS: {
                    sb.append(String.format("\u7b2c%s\u884c\uff0c\u53c2\u6570\u540d(%s)\u7684\u6765\u6e90\u53c2\u6570(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", i + 1, varMapper.getInVarName(), sRefrenceValue));
                    sb.append("\n");
                    continue block5;
                }
                case PARAM_NOTEXISTS: {
                    sb.append(String.format("\u7b2c%s\u884c\uff0c\u53c2\u6570\u540d(%s)\u7684\u6765\u6e90\u53c2\u6570(%s)\u4e0d\u5b58\u5728\u3002", i + 1, varMapper.getInVarName(), sRefrenceDisplayName));
                    sb.append("\n");
                    continue block5;
                }
                case NODE_NOTPARENT: {
                    sb.append(String.format("\u7b2c%s\u884c\uff0c\u53c2\u6570\u540d(%s)\u7684\u6765\u6e90\u53c2\u6570(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", i + 1, varMapper.getInVarName(), sRefrenceDisplayName));
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }
}

