/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateResult;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LLMNodeRefrence
extends AbstractNodeRefrence {
    private static final String ENTITY_SERVICEINFO = "gai_prompt";
    private static final String KEY_ENTRYENTITY_OUTVARCONFIG = "out_var_configs";

    @Override
    public List<RefrenceParam> getOutRefrenceParams(RefrenceDataConfig config) {
        DynamicObjectCollection outVarConfig;
        long actionId = ((LLMAction)this.getNode()).getLlmPromptId();
        if (actionId <= 0L) {
            return Collections.emptyList();
        }
        DynamicObject serviceInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)actionId, (String)ENTITY_SERVICEINFO);
        DynamicObjectCollection dynamicObjectCollection = outVarConfig = serviceInfo == null ? null : serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTVARCONFIG);
        if (outVarConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>(outVarConfig.size());
        for (DynamicObject var : outVarConfig) {
            String name = var.getString("out_var");
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            refrenceParamList.add(RefrenceParam.create(this.getNode(), name));
        }
        return refrenceParamList;
    }

    @Override
    public String validateInRefrenceParams() {
        String sRefrenceDisplayName;
        String sRefrenceValue;
        RefrenceParamValidateResult result;
        VarMapper varMapper = ((LLMAction)this.getNode()).getUserInputMapper();
        VarMapper varRepoMapper = ((LLMAction)this.getNode()).getRepoMapper();
        StringBuilder sb = new StringBuilder();
        if (varMapper != null) {
            result = this.validateRefrenceParam(varMapper.getOutNodeId(), varMapper.getOutVarName());
            sRefrenceDisplayName = sRefrenceValue = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
            if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
                sRefrenceValue = result.getRefrenceParam().getParamValue();
                sRefrenceDisplayName = result.getRefrenceParam().getParamDisplayName();
            }
            switch (result.getStatus()) {
                case NODE_NOTEXISTS: {
                    sb.append(String.format("\u7528\u6237\u8f93\u5165\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", sRefrenceValue));
                    sb.append("\n");
                    break;
                }
                case PARAM_NOTEXISTS: {
                    sb.append(String.format("\u7528\u6237\u8f93\u5165\u6765\u6e90(%s)\u4e0d\u5b58\u5728\u3002", sRefrenceDisplayName));
                    sb.append("\n");
                    break;
                }
                case NODE_NOTPARENT: {
                    sb.append(String.format("\u7528\u6237\u8f93\u5165\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", sRefrenceDisplayName));
                    sb.append("\n");
                }
            }
        }
        if (varRepoMapper != null) {
            result = this.validateRefrenceParam(varRepoMapper.getOutNodeId(), varRepoMapper.getOutVarName());
            sRefrenceDisplayName = sRefrenceValue = RefrenceParam.getParamValue(varRepoMapper.getOutNodeId(), varRepoMapper.getOutVarName());
            if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
                sRefrenceValue = result.getRefrenceParam().getParamValue();
                sRefrenceDisplayName = result.getRefrenceParam().getParamDisplayName();
            }
            switch (result.getStatus()) {
                case NODE_NOTEXISTS: {
                    sb.append(String.format("\u52a8\u6001\u77e5\u8bc6\u5e93(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", sRefrenceValue));
                    sb.append("\n");
                    break;
                }
                case PARAM_NOTEXISTS: {
                    sb.append(String.format("\u52a8\u6001\u77e5\u8bc6\u5e93(%s)\u4e0d\u5b58\u5728\u3002", sRefrenceDisplayName));
                    sb.append("\n");
                    break;
                }
                case NODE_NOTPARENT: {
                    sb.append(String.format("\u52a8\u6001\u77e5\u8bc6\u5e93(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", sRefrenceDisplayName));
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }
}

