/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.refrence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.ai.gai.plugin.flow.refrence.AbstractNodeRefrence;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateResult;
import kd.ai.gai.plugin.flow.refrence.RefrenceParamValidateStatus;
import kd.bos.dataentity.utils.StringUtils;

public class MessageNodeRefrence
extends AbstractNodeRefrence {
    @Override
    public List<RefrenceParam> getOutRefrenceParams(RefrenceDataConfig config) {
        List varList = ((MessageAction)this.getNode()).getVarList();
        if (varList == null) {
            return Collections.emptyList();
        }
        ArrayList<RefrenceParam> refrenceParamList = new ArrayList<RefrenceParam>(varList.size());
        for (Var var : varList) {
            String name = var.getName();
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            refrenceParamList.add(RefrenceParam.create(this.getNode(), name));
        }
        return refrenceParamList;
    }

    @Override
    public String validateInRefrenceParams() {
        List varMapperList = ((MessageAction)this.getNode()).getInParamMap();
        if (varMapperList == null || varMapperList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < varMapperList.size(); ++i) {
            String sRefrenceValue;
            VarMapper varMapper = (VarMapper)varMapperList.get(i);
            RefrenceParamValidateResult result = this.validateRefrenceParam(varMapper.getOutNodeId(), varMapper.getOutVarName());
            String sRefrenceDisplayName = sRefrenceValue = RefrenceParam.getParamValue(varMapper.getOutNodeId(), varMapper.getOutVarName());
            if (result.getStatus() != RefrenceParamValidateStatus.NODE_NOTEXISTS) {
                sRefrenceValue = result.getRefrenceParam().getParamValue();
                sRefrenceDisplayName = result.getRefrenceParam().getParamDisplayName();
            }
            switch (result.getStatus()) {
                case NODE_NOTEXISTS: {
                    sb.append(String.format("\u7b2c%s\u884c\u7684\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u5df2\u88ab\u5220\u9664\u3002", i + 1, sRefrenceValue));
                    sb.append("\n");
                    continue block5;
                }
                case PARAM_NOTEXISTS: {
                    sb.append(String.format("\u7b2c%s\u884c\u7684\u6765\u6e90(%s)\u4e0d\u5b58\u5728\u3002", i + 1, sRefrenceDisplayName));
                    sb.append("\n");
                    continue block5;
                }
                case NODE_NOTPARENT: {
                    sb.append(String.format("\u7b2c%s\u884c\u7684\u6765\u6e90(%s)\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u7236\u8282\u70b9\u3002", i + 1, sRefrenceDisplayName));
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }
}

