/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.services;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.enuz.FlowRequestActionType;
import kd.ai.gai.plugin.flow.event.DeleteNodeEventHandler;
import kd.ai.gai.plugin.flow.event.EditFlowEventHandler;
import kd.ai.gai.plugin.flow.event.EditNodeEventHandler;
import kd.ai.gai.plugin.flow.event.IEventHandler;
import kd.ai.gai.plugin.flow.event.InitEventHandler;
import kd.ai.gai.plugin.flow.event.NewNodeEventHandler;
import kd.ai.gai.plugin.flow.event.SaveFlowEventHandler;
import kd.ai.gai.plugin.flow.services.AbstractService;
import kd.bos.dataentity.TypesContainer;
import kd.bos.exception.KDBizException;

public class FlowEventService
extends AbstractService {
    private static final Map<FlowRequestActionType, String> eventHandlerMap = new HashMap<FlowRequestActionType, String>();

    public void invokeEvent(String eventName, String eventArgs) {
        FlowRequestActionType requestActionType = FlowRequestActionType.valueOf((String)eventName);
        IEventHandler eventHandler = FlowEventService.getEventHandler(requestActionType);
        eventHandler.handleEvent(eventArgs);
    }

    public static IEventHandler getEventHandler(FlowRequestActionType requestActionType) {
        String className = eventHandlerMap.get(requestActionType);
        if (className == null) {
            throw new KDBizException(String.format("\u4efb\u52a1\u7f16\u6392\u524d\u7aef\u4e8b\u4ef6[%s]\u5bf9\u5e94\u7684\u4e8b\u4ef6\u5904\u7406\u5668\u5b9e\u73b0\u672a\u627e\u5230", requestActionType.toString()));
        }
        return (IEventHandler)TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        eventHandlerMap.put(FlowRequestActionType.editFlow, EditFlowEventHandler.class.getName());
        eventHandlerMap.put(FlowRequestActionType.editNode, EditNodeEventHandler.class.getName());
        eventHandlerMap.put(FlowRequestActionType.newNode, NewNodeEventHandler.class.getName());
        eventHandlerMap.put(FlowRequestActionType.delNode, DeleteNodeEventHandler.class.getName());
        eventHandlerMap.put(FlowRequestActionType.init, InitEventHandler.class.getName());
        eventHandlerMap.put(FlowRequestActionType.saveFlow, SaveFlowEventHandler.class.getName());
    }
}

