/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.services;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.flow.NodePropertyDesigner;
import kd.ai.gai.plugin.flow.model.CurrentNodeInfo;
import kd.ai.gai.plugin.flow.model.DeleteDataManager;
import kd.ai.gai.plugin.flow.model.NodeDataManager;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParamManager;
import kd.ai.gai.plugin.flow.model.ValidateInfoManager;
import kd.ai.gai.plugin.flow.services.AbstractService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ModelService
extends AbstractService {
    private static final String FORMID_PROCESS = "gai_process";
    private static final String KEY_PROCESS_FLOWSTR = "flow";
    private IDataModel processModel;
    private Flow flow;
    private IPageCache cache;
    private NodeDataManager nodeDataManager;
    private RefrenceParamManager refrenceParamManager;
    private ValidateInfoManager validateInfoManager;
    private DeleteDataManager deleteDataManager;

    public IDataModel getProcessModel() {
        return this.processModel;
    }

    public Flow getFlow() {
        String sFlow = this.getProcessModel().getValue(KEY_PROCESS_FLOWSTR).toString();
        if (StringUtils.isNotEmpty((CharSequence)sFlow)) {
            this.flow = JsonUtil.fromBase64String((String)sFlow);
        }
        return this.flow;
    }

    public NodeDataManager getNodeDataManager() {
        return this.nodeDataManager;
    }

    public RefrenceParamManager getRefrenceParamManager() {
        return this.refrenceParamManager;
    }

    public ValidateInfoManager getValidateInfoManager() {
        return this.validateInfoManager;
    }

    public DeleteDataManager getDeleteDataManager() {
        return this.deleteDataManager;
    }

    public ModelService(IFormView processView) {
        this.cache = processView.getPageCache();
        this.processModel = processView.getModel();
        this.nodeDataManager = new NodeDataManager(this.cache, this.processModel);
        this.refrenceParamManager = new RefrenceParamManager(this, new RefrenceDataConfig());
        this.validateInfoManager = new ValidateInfoManager(this.cache);
        this.deleteDataManager = new DeleteDataManager(this.cache);
    }

    public IPageCache getCache() {
        return this.cache;
    }

    public void setCurrentNodeInfo(CurrentNodeInfo currentNodeInfo) {
        this.getCache().put("CurrentNodeInfo", JSON.toJSONString((Object)currentNodeInfo));
    }

    public CurrentNodeInfo getCurrentNodeInfo() {
        String jsonCurrentNodeInfo = this.getCache().get("CurrentNodeInfo");
        if (StringUtils.isEmpty((CharSequence)jsonCurrentNodeInfo)) {
            return null;
        }
        return (CurrentNodeInfo)JsonUtil.fromJson((String)jsonCurrentNodeInfo, CurrentNodeInfo.class);
    }

    public void saveCurrentNodeData(boolean bRemoveCurrentNode) {
        IFormView designerView = this.getFlowEditingContext().getService(ViewService.class).getDesignerView();
        IFormView nodeConfigView = this.getFlowEditingContext().getService(ViewService.class).getNodePropertyView();
        if (nodeConfigView != null && nodeConfigView.getModel().isDataLoaded()) {
            NodePropertyDesigner nodePropertyDesigner = new NodePropertyDesigner(nodeConfigView);
            nodePropertyDesigner.saveNodeData();
        }
        if (bRemoveCurrentNode) {
            this.getCache().remove("CurrentNodeInfo");
        }
    }

    public void updateFlow(Flow flow) {
        String flowStr = JsonUtil.toBase64String((Flow)flow);
        this.getProcessModel().setValue(KEY_PROCESS_FLOWSTR, (Object)flowStr);
    }

    public void newTransfers(List<Transfer> newTransfers) {
        Flow newFlow = this.getFlow();
        newFlow.appendNewTransfersInFlowDesignMode(newTransfers);
        if (!newTransfers.isEmpty()) {
            this.updateFlow(newFlow);
        }
    }

    public void newNodes(List<Node> newNodes) {
        Flow newFlow = this.getFlow();
        newFlow.appendNewNodesInFlowDesignMode(newNodes);
        if (!newNodes.isEmpty()) {
            this.updateFlow(newFlow);
        }
    }

    public void deleteNodes(List<Integer> nodeIdList, boolean bIsTransfer) {
        Flow flowNew = this.getFlow();
        if (bIsTransfer) {
            flowNew.deleteTransfersInFlowDesignMode(nodeIdList);
        } else {
            flowNew.deleteNodesInFlowDesignMode(nodeIdList);
        }
        this.updateFlow(flowNew);
        this.getValidateInfoManager().remove(nodeIdList);
    }

    public void save() {
        DynamicObject process = this.getProcessModel().getDataEntity(true);
        OperateOption option = OperateOption.create();
        option.setVariableValue("flowdesignersave", Boolean.TRUE.toString());
        List<Long> toDeleteCustomOperationIDs = this.getToDeleteCustomOperationIDs();
        option.setVariableValue("CustomOperationListToDelete", JSON.toJSONString(toDeleteCustomOperationIDs));
        Flow flowSave = this.getFlow();
        List actions = flowSave.getActions();
        HashMap<String, String> mapToSaveCusOperationData = new HashMap<String, String>(actions.size());
        for (Action action : actions) {
            NodeConfigData nodeConfigData;
            if (action.getNodeType() != ProcessNodeType.CusOption || (nodeConfigData = this.getNodeDataManager().get(action.getId())) == null || StringUtils.isEmpty((CharSequence)nodeConfigData.getData())) continue;
            mapToSaveCusOperationData.put(String.valueOf(action.getId()), nodeConfigData.getData());
        }
        option.setVariableValue("CustomOperationDataToSave", JSON.toJSONString(mapToSaveCusOperationData));
        OperationResult result = SaveServiceHelper.saveOperate((String)"save", (String)FORMID_PROCESS, (DynamicObject[])new DynamicObject[]{process}, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder sbMessage = new StringBuilder();
            sbMessage.append(result.getMessage());
            List infoList = result.getAllErrorOrValidateInfo();
            if (infoList != null) {
                for (IOperateInfo operateInfo : infoList) {
                    sbMessage.append(operateInfo.getMessage());
                }
            }
            this.getFlowEditingContext().getService(ViewService.class).getDesignerView().showErrorNotification(sbMessage.toString());
            return;
        }
        List pkIds = result.getSuccessPkIds();
        if (pkIds != null && !pkIds.isEmpty()) {
            this.getNodeDataManager().clear();
            this.getValidateInfoManager().clear();
            this.getDeleteDataManager().clear();
            this.getProcessModel().setDataChanged(false);
            this.getFlowEditingContext().getService(ViewService.class).getDesignerView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GaiProcessPlugin_6", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
    }

    private List<Long> getToDeleteCustomOperationIDs() {
        List<Node> cusOptionNodeList = this.getDeleteDataManager().getNodes(ProcessNodeType.CusOption);
        ArrayList<Long> toDeleteCustomOperationPkIds = new ArrayList<Long>(cusOptionNodeList.size());
        for (Node node : cusOptionNodeList) {
            Long actionId = ((JavaPluginAction)node).getActionId();
            if (actionId <= 0L) continue;
            toDeleteCustomOperationPkIds.add(actionId);
        }
        return toDeleteCustomOperationPkIds;
    }
}

