/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.services;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.common.FrontErrorCode;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceParamManager;
import kd.ai.gai.plugin.flow.model.ValidateInfoManager;
import kd.ai.gai.plugin.flow.services.AbstractService;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;

public class ValidateService
extends AbstractService {
    private static final String KEY_DESC = "desc";
    private static final String KEY_SERVICE_DESC = "servicedesc";
    private static final String KEY_PROCESS_FLOWSTR = "flow";

    public boolean validateFlowSaveFrontErrors(String eventArgs) {
        if (eventArgs.contains("errorCodes")) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            JSONArray jsonArray = jsonObject.getJSONArray("errorCodes");
            for (int i = 0; i < jsonArray.size(); ++i) {
                FrontErrorCode errorCode = FrontErrorCode.parse(jsonArray.getInteger(i));
                if (errorCode == null) continue;
                sb.append(errorCode.getMessage().getDescription());
            }
            IFormView designerView = this.getFlowEditingContext().getService(ViewService.class).getDesignerView();
            if (sb.length() > 0) {
                designerView.showErrorNotification(sb.toString());
            } else {
                designerView.showErrorNotification(FrontErrorCode.OTHER.getMessage().loadKDString());
            }
            return false;
        }
        return true;
    }

    public boolean validateFlow() {
        ModelService modelService = this.getFlowEditingContext().getService(ModelService.class);
        ViewService viewService = this.getFlowEditingContext().getService(ViewService.class);
        modelService.saveCurrentNodeData(false);
        return !this.validateAllNodes();
    }

    private boolean validateAllNodes() {
        ModelService modelService = this.getFlowEditingContext().getService(ModelService.class);
        ViewService viewService = this.getFlowEditingContext().getService(ViewService.class);
        Flow flow = modelService.getFlow();
        int nodeId = flow.getStart().getId();
        NodeValidateInfo nodeValidateInfo = modelService.getValidateInfoManager().getNodeValidateInfo(nodeId);
        if (nodeValidateInfo != null && !nodeValidateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) {
            viewService.getDesignerView().showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u8282\u70b9\u7684\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"GaiProcessPlugin_12", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return false;
        }
        nodeId = flow.getEnd().getId();
        nodeValidateInfo = modelService.getValidateInfoManager().getNodeValidateInfo(nodeId);
        if (nodeValidateInfo != null && !nodeValidateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) {
            viewService.getDesignerView().showErrorNotification(ResManager.loadKDString((String)"\u8f93\u51fa\u8282\u70b9\u7684\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"GaiProcessPlugin_13", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return false;
        }
        List actionList = flow.getActions();
        for (Action action : actionList) {
            nodeId = action.getId();
            nodeValidateInfo = modelService.getValidateInfoManager().getNodeValidateInfo(nodeId);
            if (nodeValidateInfo == null || nodeValidateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) continue;
            viewService.getDesignerView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8282\u70b9\u7684\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"GaiProcessPlugin_14", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return false;
        }
        List transferList = flow.getTransfers();
        for (Transfer transfer : transferList) {
            nodeId = transfer.getId();
            nodeValidateInfo = modelService.getValidateInfoManager().getNodeValidateInfo(nodeId);
            if (nodeValidateInfo == null || nodeValidateInfo.getStatus().equals(NodeValidateInfo.ValidateStatus.PASS.getValue())) continue;
            viewService.getDesignerView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8fde\u63a5\u7ebf\u6761\u4ef6\u7684\u6821\u9a8c\u672a\u901a\u8fc7\u3002", (String)"GaiProcessPlugin_15", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void validateNodeRefrenceParams(int nodeId, ProcessNodeType nodeType, boolean includeChildNodes) {
        RefrenceParamManager refrenceParamManager = this.getFlowEditingContext().getService(ModelService.class).getRefrenceParamManager();
        ValidateInfoManager validateInfoManager = this.getFlowEditingContext().getService(ModelService.class).getValidateInfoManager();
        if (nodeType != ProcessNodeType.Condition) {
            if (includeChildNodes) {
                List<NodeValidateInfo> nodeRefrenParamValidateInfoList = refrenceParamManager.validateNodesRefrenceParam(nodeId);
                validateInfoManager.addNodeRefrenceParamValidateInfo(nodeRefrenParamValidateInfoList);
            } else {
                List<NodeValidateInfo> validateInfoList = refrenceParamManager.validateOneNodeRefrenceParam(nodeId);
                validateInfoManager.addNodeRefrenceParamValidateInfo(validateInfoList);
            }
        } else {
            Flow flow = this.getFlowEditingContext().getService(ModelService.class).getFlow();
            Transfer transfer = flow.findTransferById(nodeId);
            NodeValidateInfo transferRefrenceParamValidateInfo = refrenceParamManager.validateTransferRefrenceParam(transfer);
            validateInfoManager.addNodeRefrenceParamValidateInfo(transferRefrenceParamValidateInfo);
        }
    }

    public void validateSpecifyNodeRefrenceParams(List<Node> nodes) {
        RefrenceParamManager refrenceParamManager = this.getFlowEditingContext().getService(ModelService.class).getRefrenceParamManager();
        ValidateInfoManager validateInfoManager = this.getFlowEditingContext().getService(ModelService.class).getValidateInfoManager();
        List<NodeValidateInfo> nodeRefrenParamValidateInfoList = refrenceParamManager.validateSpecifyNodesRefrenceParam(nodes);
        validateInfoManager.addNodeRefrenceParamValidateInfo(nodeRefrenParamValidateInfoList);
    }

    public void validateAllNodesRefrenceParams() {
        Flow flow = this.getFlowEditingContext().getService(ModelService.class).getFlow();
        ArrayList<Node> nodes = new ArrayList<Node>(1);
        for (Action action : flow.getActions()) {
            nodes.add((Node)action);
        }
        nodes.add((Node)flow.getEnd());
        this.validateSpecifyNodeRefrenceParams(nodes);
    }

    public void sendNodeValidateInfos() {
        List<NodeValidateInfo> validateInfoList = this.getFlowEditingContext().getService(ModelService.class).getValidateInfoManager().mergeAllValidateInfos();
        ArrayList<CustomControlAction> actionList = new ArrayList<CustomControlAction>(validateInfoList.size());
        for (NodeValidateInfo nodeValidateInfo : validateInfoList) {
            CustomControlAction action = new CustomControlAction("nodeValidate");
            action.setValue(nodeValidateInfo);
            actionList.add(action);
        }
        this.getFlowEditingContext().getService(FlowActionService.class).sendActionList(actionList);
    }

    public void validateNodeOutTransfers(int nodeId) {
        Flow flow = this.getFlowEditingContext().getService(ModelService.class).getFlow();
        if (!flow.isExistsNode(nodeId)) {
            return;
        }
        Node fromNode = flow.findNodeById(nodeId);
        List outTranfersIdList = fromNode.getTransferOutList();
        ArrayList<Transfer> noConditionTransferList = new ArrayList<Transfer>(outTranfersIdList.size());
        Iterator iterator = outTranfersIdList.iterator();
        while (iterator.hasNext()) {
            int iTransferId = (Integer)iterator.next();
            Transfer outTransfer = flow.findTransferById(iTransferId);
            if (outTransfer.getCondition() != null && outTransfer.getCondition().getConditionRows() != null && !outTransfer.getCondition().getConditionRows().isEmpty()) continue;
            noConditionTransferList.add(outTransfer);
        }
        int size = noConditionTransferList.size();
        ValidateInfoManager validateInfoManager = this.getFlowEditingContext().getService(ModelService.class).getValidateInfoManager();
        for (Transfer tmpTransfer : noConditionTransferList) {
            NodeValidateInfo nodeValidateInfo = new NodeValidateInfo();
            nodeValidateInfo.setNodeId(tmpTransfer.getId());
            if (size > 1) {
                nodeValidateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
                nodeValidateInfo.setValidMessage("\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u8fde\u63a5\u7ebf\u7684\u6761\u4ef6\u4e3a\u7a7a\u3002");
            } else {
                nodeValidateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
                nodeValidateInfo.setValidMessage("");
            }
            validateInfoManager.addNodeValidateInfo(nodeValidateInfo);
        }
    }
}

