/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.flow.services;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.Transfer;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.flow.model.CurrentNodeInfo;
import kd.ai.gai.plugin.flow.services.AbstractService;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ModelService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;

public class ViewService
extends AbstractService {
    private static final String KEY_FLEX_CONFIG = "flexconfig";
    private static final String KEY_FLEX_BASEINFO = "flexbaseinfo";
    private static final String KEY_LABEL_CONFIGTITLE = "lblconfigtitle";
    private static final String KEY_DESC = "desc";
    private static final String KEY_SERVICE_DESC = "servicedesc";
    private static final String KEY_PROCESS_FLOWSTR = "flow";
    private IFormView designerView;
    private IFormView currentRequestView;

    public IFormView getCurrentRequestView() {
        return this.currentRequestView;
    }

    public ViewService(IFormView processView, IFormView requestView) {
        this.designerView = processView;
        this.currentRequestView = requestView;
    }

    public IFormView getDesignerView() {
        return this.designerView;
    }

    public IFormView getNodePropertyView() {
        ModelService modelService = this.getFlowEditingContext().getService(ModelService.class);
        CurrentNodeInfo currentNodeInfo = modelService.getCurrentNodeInfo();
        IFormView nodePropertyView = currentNodeInfo != null ? this.getDesignerView().getView(currentNodeInfo.getPageId()) : null;
        return nodePropertyView;
    }

    public boolean showTransferConfigView(int transferId) {
        Flow flow = this.getFlowEditingContext().getService(ModelService.class).getFlow();
        if (!flow.isExistsTransfer(transferId)) {
            return false;
        }
        Transfer transfer = flow.findTransferById(transferId);
        Node fromNode = flow.findNodeById(transfer.getFromNodeId());
        List nodes = flow.allUpProcessNodes(fromNode.getId(), true);
        ProcessNodeType nodeType = ProcessNodeType.Condition;
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(KEY_FLEX_CONFIG);
        parameter.setCustomParam("nodeType", (Object)nodeType.getValue());
        parameter.setCustomParam("nodeId", (Object)transferId);
        parameter.setCustomParam("processNodes", (Object)SerializationUtils.toJsonString((Object)nodes));
        parameter.setFormId("gai_process_transfer");
        this.getDesignerView().showForm(parameter);
        CurrentNodeInfo currentNodeInfo = new CurrentNodeInfo(transferId, nodeType.getValue(), parameter.getPageId());
        this.getFlowEditingContext().getService(ModelService.class).setCurrentNodeInfo(currentNodeInfo);
        return true;
    }

    public boolean showNodeConfigView(int nodeId) {
        Flow flow = this.getFlowEditingContext().getService(ModelService.class).getFlow();
        if (!flow.isExistsNode(nodeId)) {
            return false;
        }
        Node currentNode = flow.findNodeById(nodeId);
        List nodes = new ArrayList(10);
        nodes = currentNode.getTransferInList().isEmpty() ? flow.allUpProcessNodes(flow.getStart().getId(), true) : flow.allUpProcessNodes(currentNode.getId());
        ProcessNodeType nodeType = currentNode.getNodeType();
        FormShowParameter parameter = new FormShowParameter();
        if (nodeType == null) {
            this.getDesignerView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6d41\u7a0b\u8282\u70b9\u7c7b\u578b\u3002", (String)"GaiProcessPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6d41\u7a0b\u8282\u70b9\u7c7b\u578b", (String)"GaiProcessPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
        }
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(KEY_FLEX_CONFIG);
        parameter.setCustomParam("nodeType", (Object)nodeType.getValue());
        parameter.setCustomParam("nodeId", (Object)nodeId);
        parameter.setCustomParam("processNodes", (Object)SerializationUtils.toJsonString(nodes));
        parameter.setFormId(nodeType.getNodeDesignerFormId());
        this.getDesignerView().showForm(parameter);
        CurrentNodeInfo currentNodeInfo = new CurrentNodeInfo(nodeId, nodeType.getValue(), parameter.getPageId());
        this.getFlowEditingContext().getService(ModelService.class).setCurrentNodeInfo(currentNodeInfo);
        return true;
    }

    public void setCurrentEditFlow() {
        this.getFlowEditingContext().getService(ModelService.class).saveCurrentNodeData(true);
        IFormView designerView = this.getDesignerView();
        designerView.setVisible(Boolean.FALSE, new String[]{KEY_FLEX_CONFIG});
        designerView.setVisible(Boolean.TRUE, new String[]{KEY_FLEX_BASEINFO});
        Label label = (Label)designerView.getControl(KEY_LABEL_CONFIGTITLE);
        label.setText(ResManager.loadKDString((String)"\u4efb\u52a1\u914d\u7f6e", (String)"GaiProcessPlugin_16", (String)"ai-gai-plugin", (Object[])new Object[0]));
    }

    public void setCurrentEditNode(int nodeID, int nodeType) {
        ModelService modelService = this.getFlowEditingContext().getService(ModelService.class);
        modelService.saveCurrentNodeData(true);
        boolean bShowNodeViewResult = nodeType == ProcessNodeType.Condition.getValue() ? this.showTransferConfigView(nodeID) : this.showNodeConfigView(nodeID);
        if (!bShowNodeViewResult) {
            return;
        }
        this.getDesignerView().setVisible(Boolean.FALSE, new String[]{KEY_FLEX_BASEINFO});
        this.getDesignerView().setVisible(Boolean.TRUE, new String[]{KEY_FLEX_CONFIG});
        Label label = (Label)this.getDesignerView().getControl(KEY_LABEL_CONFIGTITLE);
        label.setText(ResManager.loadKDString((String)"\u8be6\u60c5\u914d\u7f6e - %s", (String)"GaiProcessPlugin_17", (String)"ai-gai-plugin", (Object[])new Object[]{ProcessNodeType.valueOf((int)nodeType).getName()}));
    }

    public void lockFlow() {
        ModelService modelService = this.getFlowEditingContext().getService(ModelService.class);
        boolean bLock = modelService.getProcessModel().getValue("enable").toString().equals("1");
        CustomControlAction action = new CustomControlAction("lockFlow");
        action.setValue(bLock);
        this.getFlowEditingContext().getService(FlowActionService.class).sendAction(action);
    }
}

