/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.operation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class GaiProcessSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(GaiProcessSaveOpPlugin.class);
    private static final String KEY_PROCESS_FLOWSTR = "flow";
    private static final String GAI_OPERATION = "gai_operation";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_MUSTINPUT = "input_mustinput";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String SEPERATOR = "#";

    public String getOperationResultMessage(OperationResult opResult) {
        StringBuilder sbMessage = new StringBuilder();
        sbMessage.append(opResult.getMessage());
        List operateInfos = opResult.getAllErrorOrValidateInfo();
        for (IOperateInfo info : operateInfos) {
            sbMessage.append('\n');
            sbMessage.append(info.getMessage());
        }
        return sbMessage.toString();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_PROCESS_FLOWSTR);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption operateOption = this.getOption();
        if (!operateOption.containsVariable("flowdesignersave")) {
            return;
        }
        List listToDeleteCustomOperationPkIds = new ArrayList(10);
        String sToDelete = operateOption.getVariableValue("CustomOperationListToDelete");
        if (StringUtils.isNotEmpty((CharSequence)sToDelete)) {
            listToDeleteCustomOperationPkIds = JSON.parseArray((String)sToDelete).toJavaList(Long.class);
        }
        if (!listToDeleteCustomOperationPkIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)GAI_OPERATION), (Object[])listToDeleteCustomOperationPkIds.toArray());
        }
        DynamicObject dObjProcess = e.getDataEntities()[0];
        Flow flow = null;
        String flowStr = dObjProcess.get(KEY_PROCESS_FLOWSTR).toString();
        if (StringUtils.isNotBlank((CharSequence)flowStr)) {
            flow = JsonUtil.fromBase64String((String)flowStr);
        }
        if (flow == null) {
            return;
        }
        Map mapToSaveCusOperationData = new HashMap();
        String sToSave = operateOption.getVariableValue("CustomOperationDataToSave");
        if (StringUtils.isNotEmpty((CharSequence)sToSave)) {
            mapToSaveCusOperationData = (Map)JSON.parseObject((String)sToSave, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        }
        for (Map.Entry entry : mapToSaveCusOperationData.entrySet()) {
            int nodeId = Integer.parseInt((String)entry.getKey());
            if (!flow.isExistsNode(nodeId)) continue;
            DynamicObject dObjCusOperation = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)entry.getValue()));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)GAI_OPERATION, (DynamicObject[])new DynamicObject[]{dObjCusOperation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(this.getOperationResultMessage(result));
            }
            JavaPluginAction pluginAction = (JavaPluginAction)flow.findActionById(nodeId);
            pluginAction.setActionId(Long.parseLong(result.getSuccessPkIds().get(0).toString()));
        }
        Object id = dObjProcess.getPkValue();
        if (id == null || (Long)id == 0L) {
            id = DB.genGlobalLongId();
            dObjProcess.set("id", id);
        }
        flow.setId(((Long)id).longValue());
        dObjProcess.set(KEY_PROCESS_FLOWSTR, (Object)JsonUtil.toBase64String((Flow)flow));
    }
}

