/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.portal;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PortalListenerPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log log = LogFactory.getLog(PortalListenerPlugin.class);
    private static final String CACHED_APP_ID_KEY = "gai_current_tab_appId";
    private static final String WORK_BEN = "qing_workbench";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String lastAppId = this.getView().getPageCache().get(CACHED_APP_ID_KEY);
        String newAppId = this.getAppIdByPageId(tabKey);
        log.info("\u5207\u6362 tab: {},appId {}", (Object)tabKey, (Object)newAppId);
        if (newAppId == null && WORK_BEN.equals(lastAppId) || newAppId != null && !newAppId.equals(lastAppId) && (WORK_BEN.equals(newAppId) || WORK_BEN.equals(lastAppId))) {
            log.info("\u5207\u5165\u6216\u8005\u5207\u51faworkBench tab: {}", (Object)tabKey);
            this.getView().getPageCache().put(CACHED_APP_ID_KEY, newAppId);
            this.tabChangeTo(newAppId);
        }
    }

    private String getAppIdByPageId(String pageId) {
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return null;
        }
        IFormView view = this.getView().getViewNoPlugin(pageId);
        if (view == null) {
            return null;
        }
        return view.getModel().getDataEntityType().getBizAppNumber();
    }

    public void tabChangeTo(String tabChangeTo) {
        IFormView iFormView = this.getView().getMainView();
        if (iFormView == null) {
            iFormView = this.getView().getParentView();
        }
        String rootPageId = iFormView.getPageId();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("tabChangeTo", tabChangeTo);
        try {
            DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSON.toJSONString(configMap)});
        }
        catch (Exception e) {
            log.error("\u8c03\u7528gai\u7684\u5fae\u670d\u52a1\u62a5\u9519\uff0c\u53ef\u80fd\u8fd8\u6ca1\u6709\u521d\u59cb\u5316\u5b8c\u6210");
        }
    }
}

