/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.rag.service.RepoDispatchService;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.Donothing;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class GaiRepoInfoPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final String op_newfile = "newfile";
    private static final String op_viewentry = "viewentry";
    private static final String op_delentry = "delentry";
    private static final String PAGE_ID = "pageId";
    private static final String ACTION_ID = "gai_upload_file";
    private static final String toolbar = "tbmain";
    private static final String bar_save = "bar_save";
    private static final String bar_handle = "bar_handle";
    private static Log LOGGER = LogFactory.getLog(GaiRepoInfoPlugin.class);

    public void registerListener(EventObject e) {
        Toolbar tbmain = (Toolbar)this.getView().getControl(toolbar);
        tbmain.addItemClickListener((ItemClickListener)this);
    }

    public void afterBindData(EventObject e) {
        List indexMethodomboItem = GaiFieldTypeInitUtils.createEmbeddingComboItem();
        ComboEdit indexMethod = (ComboEdit)this.getView().getControl("index_method");
        indexMethod.setComboItems(indexMethodomboItem);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("useorg", (Object)orgId);
        String repoStatus = (String)this.getModel().getValue("status");
        if ("D".equals(repoStatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{bar_handle, bar_save});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldName = e.getKey();
        if ("index_method".equals(fieldName)) {
            String language_model = (String)e.getValue();
            List instanceList = AiccService.getAiccInstanceList();
            if (!instanceList.contains(language_model)) {
                this.getView().updateView(fieldName);
                e.setCancel(true);
                this.getView().showConfirm("\u672a\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u8fdb\u5165\u3010AI\u80fd\u529b\u4e2d\u5fc3\u3011\u2192\u3010\u670d\u52a1\u5b9e\u4f8b\u3011\u5217\u8868\u4e2d\u914d\u7f6e\u6a21\u578bAPI\u53c2\u6570\u3002", MessageBoxOptions.OK);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String item;
        switch (item = evt.getItemKey()) {
            case "bar_save": 
            case "bar_handle": {
                Object pkValue;
                boolean exists;
                DynamicObject entity = this.getModel().getDataEntity(true);
                boolean failed = this.checkFailed(entity);
                if (failed) {
                    evt.setCancel(true);
                    return;
                }
                String repoType = entity.getString("type");
                boolean codeGen = "kd_code_gen".equals(repoType);
                DynamicObjectCollection files = this.getModel().getEntryEntity("doc_manage");
                if (Objects.nonNull(files) && files.size() > 0) {
                    for (DynamicObject f : files) {
                        boolean noJson;
                        String fileType = f.getString("file_type");
                        boolean bl = noJson = !"json".equals(fileType);
                        if (!codeGen || !noJson) continue;
                        this.getView().showTipNotification("\u4fdd\u5b58\u5931\u8d25\uff0c\u77e5\u8bc6\u5e93-\u4ee3\u7801\u751f\u6210\u7c7b\u578b\uff0c\u6587\u6863\u7c7b\u578b\u6709\u8bef\uff0c\u8bf7\u4e0a\u4f20Json\u7c7b\u578b\u3002");
                        evt.setCancel(true);
                        return;
                    }
                    long[] pkIds = ORM.create().genLongIds("gai_repo_info", files.size());
                    for (int i = 0; i < files.size(); ++i) {
                        DynamicObject f = (DynamicObject)files.get(i);
                        if (!"E".equals(f.getString("file_status"))) continue;
                        String tmpUrl = f.getString("file_tmp_path");
                        String fileName = f.getString("file_name");
                        long pkId = pkIds[i];
                        String filePath = AttachmentServiceHelper.saveTempToFileService((String)tmpUrl, (String)"gai", (String)"gai_repo_info", (Object)pkId, (String)fileName);
                        this.getModel().setValue("file_path", (Object)filePath, i);
                        this.getModel().setValue("file_status", (Object)"A", i);
                    }
                    entity.set("file_total", (Object)files.size());
                }
                if (!(exists = QueryServiceHelper.exists((String)"gai_repo_info", (Object)(pkValue = entity.getPkValue())))) {
                    pkValue = DB.genLongId((String)"gai_repo_info");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_repo_info");
                    CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)entity.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
                    String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
                    entity.set("id", pkValue);
                    entity.set("status", (Object)"A");
                    entity.set("number", (Object)number);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String item;
        switch (item = evt.getItemKey()) {
            case "bar_handle": {
                DynamicObject entity = this.getModel().getDataEntity(true);
                long pkValue = (Long)entity.getPkValue();
                boolean addStatus = RepoDispatchService.dispatchTask((long)pkValue);
                if (addStatus) {
                    this.getModel().setValue("id", (Object)pkValue);
                    this.getModel().setValue("status", (Object)"B");
                    entity = this.getModel().getDataEntity(true);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
                    LOGGER.info("\u3010AI\u5f00\u53d1\u5e73\u53f0-\u77e5\u8bc6\u5e93\u3011\u521b\u5efa\u5206\u5757\u4efb\u52a1\u6210\u529f");
                } else {
                    LOGGER.info("\u3010AI\u5f00\u53d1\u5e73\u53f0-\u77e5\u8bc6\u5e93\u3011\u521b\u5efa\u5206\u5757\u4efb\u52a1\u5931\u8d25");
                }
                BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
                billShowParameter.setPkId((Object)pkValue);
                billShowParameter.setBillStatus(BillOperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String operate;
            Donothing donothing = (Donothing)source;
            switch (operate = donothing.getOperateKey()) {
                case "newfile": {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("gai_repo_upload_files");
                    showParameter.setCustomParam(PAGE_ID, (Object)this.getView().getPageId());
                    showParameter.setCustomParam("type", this.getModel().getValue("type"));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_ID));
                    this.getView().showForm(showParameter);
                    break;
                }
                case "viewentry": {
                    if (this.isRunning(args)) {
                        return;
                    }
                    Object repoId = this.getModel().getDataEntity(true).getPkValue();
                    int index = this.getModel().getEntryCurrentRowIndex("doc_manage");
                    DynamicObject entity = this.getModel().getEntryRowEntity("doc_manage", index);
                    Object currnFileId = entity.getPkValue();
                    FormShowParameter parameter = new FormShowParameter();
                    parameter.setFormId("gai_repo_show_chunk");
                    parameter.setCustomParam(PAGE_ID, (Object)this.getView().getPageId());
                    parameter.setCustomParam("showRepoId", repoId);
                    parameter.setCustomParam("showFileId", currnFileId);
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    this.getView().showForm(parameter);
                    break;
                }
                case "delentry": {
                    int index = this.getModel().getEntryCurrentRowIndex("doc_manage");
                    DynamicObject entity = this.getModel().getEntryRowEntity("doc_manage", index);
                    String fileStatus = entity.getString("file_status");
                    if ("E".equals(fileStatus)) {
                        String fileTmpUrl = entity.getString("file_tmp_path");
                        CacheFactory.getCommonCacheFactory().getTempFileCache().remove(fileTmpUrl);
                        this.getModel().deleteEntryRow("doc_manage", index);
                        this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f\u3002");
                        break;
                    }
                    if (this.isRunning(args)) {
                        return;
                    }
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6587\u6863\u6570\u636e\u5c06\u4f1a\u88ab\u6e05\u7406\uff0c\u662f\u5426\u5220\u9664?", (String)"GaiRepoInfoPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delDocCallBack"));
                }
            }
        }
    }

    private void delDocInfo() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("doc_manage");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("doc_manage", rowIndex);
        Object fileId = rowEntity.getPkValue();
        String path = rowEntity.getString("file_path");
        String fileStatus = rowEntity.getString("file_status");
        String indexMethod = entity.getString("index_method");
        LLM llm = LLM.parse((String)indexMethod);
        try {
            switch (fileStatus) {
                case "C": 
                case "G": {
                    List ids;
                    DynamicObjectCollection dids = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id", (QFilter[])new QFilter[]{new QFilter("fileid", "=", fileId)});
                    if (dids != null && !(ids = dids.stream().map(o -> o.getLong("id")).collect(Collectors.toList())).isEmpty()) {
                        MilvusService.getExecutor((LLM)llm).delByIdList(ids);
                    }
                    DeleteServiceHelper.delete((String)"gai_text_chunk", (QFilter[])new QFilter[]{new QFilter("fileid", "=", fileId)});
                }
                case "D": 
                case "A": {
                    FileServiceFactory.getAttachmentFileService().delete(path);
                    DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"delete t_gai_repo_doc_manage  where fentryid=?", (Object[])new Object[]{fileId});
                    this.getModel().deleteEntryRow("doc_manage", rowIndex);
                    this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f\u3002");
                    break;
                }
                case "E": {
                    TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    String tmpPath = (String)this.getModel().getValue("file_tmp_path");
                    tempFile.remove(tmpPath);
                    this.getModel().deleteEntryRow("doc_manage", rowIndex);
                    this.getView().showSuccessNotification("\u5220\u9664\u6210\u529f\u3002");
                    break;
                }
                case "F": 
                case "B": {
                    this.getView().showTipNotification("\u3010\u77e5\u8bc6\u5e93\u3011\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u3010\u77e5\u8bc6\u5e93\u3011\u6587\u6863\u5220\u9664\u5f02\u5e38 msg:%s", e.getMessage()), (Throwable)e);
            this.getModel().setValue("file_status", (Object)"H");
            entity.set("file_status", (Object)"H");
            SaveServiceHelper.update((DynamicObject)entity);
            this.getView().showTipNotification("\u3010\u77e5\u8bc6\u5e93\u3011\u6863\u5220\u9664\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002");
        }
        this.getView().updateView("doc_manage");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("delDocCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.delDocInfo();
            this.updateRepoStatus();
        }
    }

    private void updateRepoStatus() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        Object repoId = entity.getPkValue();
        boolean noSuccess = QueryServiceHelper.exists((String)"gai_repo_info", (QFilter[])new QFilter[]{new QFilter("id", "=", repoId).and(String.format("%s.%s", "doc_manage", "file_status"), "!=", (Object)"C")});
        if (!noSuccess) {
            this.getModel().setValue("status", (Object)"C");
            entity = this.getModel().getDataEntity(true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
            SaveServiceHelper.update((DynamicObject)entity);
        }
    }

    private boolean isRunning(BeforeDoOperationEventArgs args) {
        String repoStatus;
        int index = this.getModel().getEntryCurrentRowIndex("doc_manage");
        DynamicObject entity = this.getModel().getEntryRowEntity("doc_manage", index);
        switch (repoStatus = entity.getString("file_status")) {
            case "B": 
            case "F": {
                args.setCancel(true);
                this.getView().showTipNotification("\u3010\u77e5\u8bc6\u5e93\u3011\u5f53\u524d\u6587\u4ef6\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                return true;
            }
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        IFormView view = evt.getView();
        try {
            List uploadFiles;
            if (ACTION_ID.equals(actionId) && Objects.nonNull(uploadFiles = (List)evt.getReturnData()) && uploadFiles.size() > 0) {
                String repoType = (String)this.getModel().getValue("type");
                int docCount = this.getModel().getEntryRowCount("doc_manage");
                this.getModel().batchCreateNewEntryRow("doc_manage", uploadFiles.size());
                for (int i = 0; i < uploadFiles.size(); ++i) {
                    int index = docCount + i;
                    Map f = (Map)uploadFiles.get(i);
                    String attFileType = (String)f.get("type");
                    for (String type : Constant.RepoInfo.handle_file_type) {
                        if (!attFileType.contains(type)) continue;
                        this.getModel().setValue("file_type", (Object)type, index);
                        break;
                    }
                    String currenFileSource = "kd_code_gen".equals(repoType) ? "code" : ("qa".equals(repoType) && attFileType.contains("json") ? "html" : "doc");
                    this.getModel().setValue("file_source", (Object)currenFileSource, index);
                    this.getModel().setValue("file_name", f.get("name"), index);
                    this.getModel().setValue("file_size", f.get("size"), index);
                    this.getModel().setValue("file_tmp_path", f.get("url"), index);
                    this.getModel().setValue("create_date", (Object)new Date((Long)f.get("createdate")), index);
                }
            }
        }
        catch (Exception e) {
            view.showTipNotification("OCR Exception ");
            LOGGER.error("AI\u5f00\u53d1\u5e73\u53f0,\u77e5\u8bc6\u5e93\u6587\u4ef6\u4e0a\u4f20,\u64cd\u4f5c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean checkFailed(DynamicObject repo) {
        StringBuilder msg = new StringBuilder();
        String repoNumber = repo.getString("number");
        String repoName = repo.getString("name");
        String indexMethod = repo.getString("index_method");
        DynamicObject userOrg = repo.getDynamicObject("useorg");
        if (StringUtils.isEmpty((String)repoName)) {
            msg.append("\u540d\u79f0,");
        }
        if (StringUtils.isEmpty((String)repoNumber)) {
            msg.append("\u7f16\u7801,");
        }
        if (StringUtils.isEmpty((String)indexMethod)) {
            msg.append("\u7d22\u5f15\u65b9\u5f0f,");
        }
        if (Objects.isNull(userOrg)) {
            msg.append("\u4f7f\u7528\u7ec4\u7ec7,");
        }
        if (StringUtils.isNotEmpty((String)msg.toString())) {
            msg.append("\u4e0d\u80fd\u4e3a\u7a7a");
            this.getView().showTipNotification(msg.toString());
            return true;
        }
        return false;
    }
}

