/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.EventObject;
import java.util.Objects;
import kd.ai.gai.plugin.repo.GaiRepoInfoPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GaiRepoShowChunkInfo
extends AbstractFormPlugin
implements RowClickEventListener {
    private static Log LOGGER = LogFactory.getLog(GaiRepoInfoPlugin.class);
    private static final String chunk_id = "chunkid";
    private static final String chunk_content = "chunk_content";
    private static final String chunk_order = "chunk_order";
    private static final String chunk_info = "chunk_info";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(chunk_info);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        String order;
        QFilter filter;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object repoId = parameter.getCustomParam("showRepoId");
        Object fileId = parameter.getCustomParam("showFileId");
        String selectFields = String.join((CharSequence)",", "id", "order");
        DynamicObjectCollection chunkInfos = QueryServiceHelper.query((String)"gai_text_chunk", (String)selectFields, (QFilter[])new QFilter[]{filter = new QFilter("repoid", "=", repoId).and("fileid", "=", fileId)}, (String)(order = String.format("%s,%s ASC ", "pageid", "order")));
        if (Objects.nonNull(chunkInfos) && chunkInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(chunk_info, chunkInfos.size());
            for (int i = 0; i < chunkInfos.size(); ++i) {
                DynamicObject chunkInfo = (DynamicObject)chunkInfos.get(i);
                this.getModel().setValue(chunk_id, (Object)chunkInfo.getLong("id"), i);
                this.getModel().setValue(chunk_order, (Object)(i + 1), i);
            }
            this.getView().updateView(chunk_info);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        Object chunkIdO = this.getModel().getValue(chunk_id, row);
        if (chunkIdO != null) {
            long chunkId = (Long)chunkIdO;
            DynamicObject textInfo = QueryServiceHelper.queryOne((String)"gai_text_chunk", (String)"content_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)chunkId)});
            String contenTag = textInfo.getString("content_tag");
            this.getModel().setValue(chunk_content, (Object)contenTag);
        }
    }
}

