/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.repo;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class GaiRepoUploadPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener,
BeforeAttachmentUploadListener {
    private static final String btnok = "btnok";
    private static final String btncancel = "btncancel";
    private static final String file_upload = "file_upload";
    private static final int file_max_size = 0x3200000;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btnok});
        this.addClickListeners(new String[]{btncancel});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(file_upload);
        attachmentPanel.addUploadListener((UploadListener)this);
        attachmentPanel.addBeforeUploadListener((BeforeAttachmentUploadListener)this);
    }

    public void beforeAttachmentUpload(BeforeAttachmentUploadEvent e) {
        String repoType = (String)this.getView().getFormShowParameter().getCustomParam("type");
        boolean codeGen = "kd_code_gen".equals(repoType);
        if (codeGen) {
            List attachments = e.getSourceAttachments();
            for (Map a : attachments) {
                String fileType = (String)a.get("type");
                boolean is = fileType.contains("json");
                if (is) continue;
                e.getCancelAttachments().add(a);
            }
            int size = e.getCancelAttachments().size();
            if (size > 0) {
                e.setCancel(true);
                e.setMsg("\u3010\u77e5\u8bc6\u5e93-\u4ee3\u7801\u751f\u6210\u3011\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u6709\u8bef\uff0c\u8bf7\u4e0a\u4f20Json\u7c7b\u578b\u3002");
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (Objects.nonNull(urls) && urls.length > 0) {
            for (Object url : urls) {
                if (!(url instanceof LinkedHashMap)) continue;
                Map attUrl = (Map)url;
                boolean no_status = !this.checkFileSize(attUrl);
                evt.setCancel(no_status);
                evt.setCancelMsg("\u4e0a\u4f20\u7684\u9644\u4ef6\u6587\u4ef6\u5927\u4e8e50M,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
        }
    }

    private boolean checkFileSize(Map<String, Object> attUrl) {
        Integer size = (Integer)attUrl.get("size");
        return size <= 0x3200000;
    }

    public void click(EventObject evt) {
        AttachmentPanel panel = (AttachmentPanel)this.getControl(file_upload);
        List files = panel.getAttachmentData();
        Button button = (Button)evt.getSource();
        String buttonOp = button.getKey();
        if (btnok.equals(buttonOp) && Objects.nonNull(files)) {
            for (Map file : files) {
                boolean no_status = !this.checkFileSize(file);
                if (!no_status) continue;
                this.getView().showTipNotification("\u4e0a\u4f20\u7684\u9644\u4ef6\u6587\u4ef6\u5927\u4e8e50M,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return;
            }
            this.getView().returnDataToParent((Object)files);
            this.getView().close();
        } else if (btncancel.equals(buttonOp)) {
            for (Map file : files) {
                String url = (String)file.get("url");
                CacheFactory.getCommonCacheFactory().getTempFileCache().remove(url);
            }
            this.getView().close();
        }
    }
}

