/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.session;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GaiSessionTabPlugin
extends AbstractFormPlugin
implements BeforeBindDataListener,
FilterContainerInitListener,
SearchClickListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiSessionTabPlugin.class);
    private String SESSION_BILL_LIST = "sessionbilllist";
    private String SESSION_FILTER_CONTROL = "sessionfiltercontainerap";
    private String ITEM_CLICK_REFRESH = "sessionrefresh";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(this.SESSION_FILTER_CONTROL);
        if (filterContainer != null) {
            filterContainer.setBillFormId("gai_log");
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
            filterContainer.addSearchClickListener((SearchClickListener)this);
        }
        BillList billList = (BillList)this.getControl(this.SESSION_BILL_LIST);
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(this.SESSION_BILL_LIST);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"sessiontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String keyName = evt.getItemKey();
        if (keyName.equals(this.ITEM_CLICK_REFRESH)) {
            BillList billList = (BillList)this.getControl(this.SESSION_BILL_LIST);
            this.getView().updateView(billList.getKey());
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        super.beforeBindData((EventObject)beforeBindDataEvent);
        BillList billList = (BillList)this.getControl(this.SESSION_BILL_LIST);
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
                args.setListDataProvider((IListDataProvider)new BillListDataProvider());
            }
        });
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        List commonFilterColumn = filterContainerInitEvent.getCommonFilterColumns();
        List fastFilterColumn = filterContainerInitEvent.getFastFilterColumns();
        MainEntityType mainEntityType = ((FilterColumn)fastFilterColumn.get(0)).getEntityType();
        fastFilterColumn.clear();
        final ArrayList deleteFilters = new ArrayList();
        final ArrayList<QFilter> listFilter = new ArrayList<QFilter>();
        commonFilterColumn.stream().forEach(new Consumer<FilterColumn>(){

            @Override
            public void accept(FilterColumn filterColumn) {
                if (!filterColumn.getFieldName().equals("createtime")) {
                    deleteFilters.add(filterColumn);
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    QFilter toDayQFilter = new QFilter("createtime", ">=", (Object)calendar.getTime());
                    calendar.add(5, 1);
                    QFilter toDayEndQFilter = new QFilter("createtime", "<", (Object)calendar.getTime());
                    QFilter andToDayFilter = toDayQFilter.and(toDayEndQFilter);
                    listFilter.add(andToDayFilter);
                }
            }
        });
        commonFilterColumn.removeAll(deleteFilters);
        FilterColumn sessionFastFilterColumn = new FilterColumn();
        sessionFastFilterColumn.setCaption(new LocaleString("\u4f1a\u8bddID"));
        sessionFastFilterColumn.setParentViewKey("fastsearchgridview");
        sessionFastFilterColumn.setEntityType(mainEntityType);
        sessionFastFilterColumn.setKey("filtercolumnap2");
        sessionFastFilterColumn.setFieldName("sessionid");
        fastFilterColumn.add(sessionFastFilterColumn);
        this.refreshSessionMetricListByFilters(listFilter);
    }

    public void refreshSessionMetricListByFilters(List<QFilter> filters) {
        BillList billList = (BillList)this.getControl(this.SESSION_BILL_LIST);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(filters);
        billList.setQueryFilterParameter(filterParameter);
        this.getView().updateView(billList.getKey());
        billList.clearSelection();
    }

    public void click(SearchClickEvent searchClickEvent) {
        BillList billList = (BillList)this.getControl(this.SESSION_BILL_LIST);
        Map data = searchClickEvent.getCurrentCommonFilter();
        int size = ((List)data.get("Value")).size();
        List qFilters = searchClickEvent.getFastQFilters();
        if (size < 2) {
            if (data != null && !data.isEmpty()) {
                String fieldName = (String)((List)data.get("FieldName")).get(0);
                String value = "";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                if (fieldName.equals("createtime") && size == 1) {
                    value = (String)((List)data.get("Value")).get(0);
                    Calendar calendar = Calendar.getInstance();
                    switch (value) {
                        case "13": {
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                            calendar.set(14, 0);
                            QFilter toDayQFilter = new QFilter(fieldName, ">=", (Object)calendar.getTime());
                            calendar.add(5, 1);
                            QFilter toDayEndQFilter = new QFilter(fieldName, "<", (Object)calendar.getTime());
                            QFilter andToDayFilter = toDayQFilter.and(toDayEndQFilter);
                            qFilters.add(andToDayFilter);
                            break;
                        }
                        case "63": {
                            calendar.set(5, 1);
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                            calendar.set(14, 0);
                            QFilter monthStartQFilter = new QFilter(fieldName, ">=", (Object)calendar.getTime());
                            calendar.add(2, 1);
                            QFilter monthEndQFilter = new QFilter(fieldName, "<", (Object)calendar.getTime());
                            QFilter andFilter = monthStartQFilter.and(monthEndQFilter);
                            qFilters.add(andFilter);
                            break;
                        }
                        case "24": {
                            calendar.setTime(KDDateUtils.today());
                            calendar.add(2, -3);
                            QFilter lastThreeMonthQFilter = new QFilter(fieldName, ">=", (Object)calendar.getTime());
                            qFilters.add(lastThreeMonthQFilter);
                        }
                    }
                }
            }
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String fieldName = (String)((List)data.get("FieldName")).get(0);
            List valueList = (List)data.get("Value");
            String value1 = valueList.get(0).toString();
            if (!value1.equals("")) {
                String value2 = valueList.get(1).toString();
                try {
                    Date date1 = sdf.parse(value1);
                    Date date2 = sdf.parse(value2);
                    if (date1.compareTo(date2) > 0) {
                        QFilter minFilter = new QFilter(fieldName, ">", (Object)date2);
                        QFilter maxFilter = new QFilter(fieldName, "<", (Object)date1);
                        QFilter resultQfilter = minFilter.and(maxFilter);
                        qFilters.add(resultQfilter);
                    } else {
                        QFilter minFilter = new QFilter(fieldName, ">", (Object)date1);
                        QFilter maxFilter = new QFilter(fieldName, "<", (Object)date2);
                        QFilter resultQfilter = minFilter.and(maxFilter);
                        qFilters.add(resultQfilter);
                    }
                }
                catch (ParseException e) {
                    logger.error("\u81ea\u5b9a\u4e49\u65e5\u671f\u8fc7\u6ee4\u5668\u5f02\u5e38...");
                }
            }
        }
        FilterParameter filterParameter = new FilterParameter(qFilters, "desc");
        billList.setQueryFilterParameter(filterParameter);
        this.getView().updateView(billList.getKey());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"sessionid")) {
            BillList billList = (BillList)hyperLinkClickEvent.getSource();
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            String pkId = selectedRow.toString().replace("[", "").replace("]", "").replaceAll("\"", "");
            DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_log");
            long sessionId = rowData.getLong("sessionid");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gai_log_view");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("id", (Object)sessionId);
            showParameter.setCustomParam("origin", (Object)"session");
            showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", sessionId));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            List qFilters = super.getQFilters();
            QFilter dataQFilter = PermissionServiceHelper.getOperationRuleFilter((String)"gai", (String)"gai_log", (String)"view", (StringBuilder)new StringBuilder("\u65e0\u6743\u9650\u8bbf\u95ee"));
            QFilter[] filters = null;
            int filterSize = qFilters.size();
            switch (filterSize) {
                case 2: {
                    QFilter sessionFilter;
                    String beforeValue;
                    String fieldName;
                    ArrayList<Object> newQFilter = new ArrayList<Object>();
                    for (int i = 0; i < qFilters.size(); ++i) {
                        fieldName = ((QFilter)qFilters.get(i)).getProperty();
                        if (fieldName.equals("1")) {
                            beforeValue = ((QFilter)qFilters.get(i)).getValue().toString();
                            String value = beforeValue.substring(beforeValue.indexOf("#") + 1);
                            sessionFilter = new QFilter("sessionid", "=", (Object)Long.valueOf(value));
                            newQFilter.add(sessionFilter);
                            continue;
                        }
                        newQFilter.add(qFilters.get(i));
                    }
                    filters = new QFilter[]{(QFilter)newQFilter.get(0), (QFilter)newQFilter.get(1), dataQFilter};
                    break;
                }
                case 1: {
                    QFilter sessionFilter;
                    String beforeValue;
                    QFilter oneFilter = (QFilter)qFilters.get(0);
                    String fieldName = oneFilter.getProperty();
                    if (fieldName.equals("1")) {
                        beforeValue = oneFilter.getValue().toString();
                        String value = beforeValue.substring(beforeValue.indexOf("#") + 1);
                        sessionFilter = new QFilter("sessionid", "=", (Object)Long.valueOf(value));
                        filters = new QFilter[]{sessionFilter, dataQFilter};
                        break;
                    }
                    filters = new QFilter[]{oneFilter, dataQFilter};
                    break;
                }
                case 0: {
                    filters = new QFilter[]{dataQFilter};
                    break;
                }
                case 3: {
                    ArrayList<Object> threeQFilter = new ArrayList<Object>();
                    for (int i = 0; i < 3; ++i) {
                        String threeFieldName = ((QFilter)qFilters.get(i)).getProperty();
                        if (threeFieldName.equals("1")) {
                            String beforeValue = ((QFilter)qFilters.get(i)).getValue().toString();
                            String value = beforeValue.substring(beforeValue.indexOf("#") + 1);
                            QFilter sessionFilter = new QFilter("sessionid", "=", (Object)Long.valueOf(value));
                            threeQFilter.add(sessionFilter);
                            continue;
                        }
                        threeQFilter.add(qFilters.get(i));
                    }
                    filters = new QFilter[]{(QFilter)threeQFilter.get(0), (QFilter)threeQFilter.get(1), (QFilter)threeQFilter.get(2), dataQFilter};
                }
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gai_log", (String)"sessionid, cloudid, appid,createtime,createorg.name,creator.name ", (QFilter[])filters, (String)"createtime desc");
            String sql = "select sessionid, cloudid, appid,createorg.name,creator.name,count(1) as tracenum,min(createtime) as createtime  group by sessionid, cloudid, appid,createorg.name,creator.name org order by createtime desc";
            DataSet metricDataSet = dataSet.executeSql(sql).orderBy(new String[]{"createtime desc"});
            DataSet countDataset = metricDataSet.copy();
            int totalSize = countDataset.count("sessionid", false);
            if (start > totalSize) {
                double pageHandle = totalSize / limit;
                int page = (int)Math.ceil(pageHandle);
                start = page * limit;
                BillList billList = (BillList)GaiSessionTabPlugin.this.getControl(GaiSessionTabPlugin.this.SESSION_BILL_LIST);
                billList.getEntryState().setCurrentPageIndex(Integer.valueOf(page + 1));
            }
            DynamicObjectCollection resultCollection = this.datasetToDynamicObjectCollection(metricDataSet, start, limit);
            for (DynamicObject dynamicObject : resultCollection) {
                long sessionid = (Long)dynamicObject.get("sessionid");
                QFilter qFilter = new QFilter("sessionid", "=", (Object)sessionid);
                DynamicObject newObject = QueryServiceHelper.queryOne((String)"gai_log", (String)"id", (QFilter[])qFilter.toArray());
                long pkId = (Long)newObject.get("id");
                dynamicObject.set("id", (Object)pkId);
            }
            if (resultCollection.size() == 0) {
                QFilter nullFilter = new QFilter("sessionid", "=", (Object)1111);
                resultCollection = QueryServiceHelper.query((String)"gai_log", (String)"sessionid, cloudid, appid", (QFilter[])nullFilter.toArray());
            }
            this.getQueryResult().setNumberFormatProvider(new NumberFormatProvider(new ArrayList(), resultCollection));
            this.getQueryResult().setCollection(resultCollection);
            this.getQueryResult().setDataCount(totalSize);
            return resultCollection;
        }

        public DynamicObjectCollection datasetToDynamicObjectCollection(DataSet dataSet, int start, int limit) {
            Field[] fields = dataSet.getRowMeta().getFields();
            DynamicObjectCollection collection = new DynamicObjectCollection();
            int fieldLength = fields.length;
            int index = 0;
            int dataCount = 0;
            for (Row rowData : dataSet) {
                if (++index <= start) continue;
                if (dataCount >= limit) break;
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gai_log");
                for (int i = 0; i < fieldLength; ++i) {
                    String key = fields[i].getName();
                    if (key.equals("createorg.name")) {
                        dynamicObject.set("tracetoken", rowData.get(key));
                        continue;
                    }
                    if (key.equals("creator.name")) {
                        dynamicObject.set("traceinput", rowData.get(key));
                        continue;
                    }
                    Object value = rowData.get(key);
                    dynamicObject.set(key, value);
                }
                collection.add((Object)dynamicObject);
                ++dataCount;
            }
            return collection;
        }
    }
}

