/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.session;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiTraceTabPlugin
extends AbstractFormPlugin
implements BeforeBindDataListener,
FilterContainerInitListener,
SearchClickListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(GaiTraceTabPlugin.class);
    private String TRACE_BILL_LIST = "tracebilllistap";
    private String TRACE_FILTER_CONTAILER = "tracefiltercontainerap";
    private String ITEM_CLICK_REFRESH = "tracerefresh";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
        FilterContainer filterContainer = (FilterContainer)this.getControl(this.TRACE_FILTER_CONTAILER);
        if (filterContainer != null) {
            filterContainer.setBillFormId("gai_log");
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
            filterContainer.addSearchClickListener((SearchClickListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tracetoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals(this.ITEM_CLICK_REFRESH)) {
            BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
            this.getView().updateView(billList.getKey());
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
                beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new TraceBillListDataProvider());
            }
        });
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        List commonFilterColumn = filterContainerInitEvent.getCommonFilterColumns();
        List fastFilterColumn = filterContainerInitEvent.getFastFilterColumns();
        MainEntityType mainEntityType = ((FilterColumn)fastFilterColumn.get(0)).getEntityType();
        fastFilterColumn.clear();
        final ArrayList deleteFilters = new ArrayList();
        final ArrayList<QFilter> listFilter = new ArrayList<QFilter>();
        commonFilterColumn.stream().forEach(new Consumer<FilterColumn>(){

            @Override
            public void accept(FilterColumn filterColumn) {
                if (!filterColumn.getFieldName().equals("createtime")) {
                    deleteFilters.add(filterColumn);
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    QFilter toDayQFilter = new QFilter("createtime", ">=", (Object)calendar.getTime());
                    calendar.add(5, 1);
                    QFilter toDayEndQFilter = new QFilter("createtime", "<", (Object)calendar.getTime());
                    QFilter andToDayFilter = toDayQFilter.and(toDayEndQFilter);
                    listFilter.add(andToDayFilter);
                }
            }
        });
        commonFilterColumn.removeAll(deleteFilters);
        FilterColumn sessionFastFilterColumn = new FilterColumn();
        sessionFastFilterColumn.setCaption(new LocaleString("\u4f1a\u8bddID"));
        sessionFastFilterColumn.setParentViewKey("fastsearchgridview");
        sessionFastFilterColumn.setEntityType(mainEntityType);
        sessionFastFilterColumn.setKey("filtercolumnap2");
        sessionFastFilterColumn.setFieldName("sessionid");
        fastFilterColumn.add(sessionFastFilterColumn);
        FilterColumn traceFastFilterColumn = new FilterColumn();
        traceFastFilterColumn.setCaption(new LocaleString("TraceID"));
        traceFastFilterColumn.setParentViewKey("fastsearchgridview");
        traceFastFilterColumn.setEntityType(mainEntityType);
        traceFastFilterColumn.setKey("filtercolumnap3");
        traceFastFilterColumn.setFieldName("traceid");
        fastFilterColumn.add(traceFastFilterColumn);
        this.refreshSessionMetricListByFilters(listFilter);
    }

    public void refreshSessionMetricListByFilters(List<QFilter> filters) {
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(filters);
        billList.setQueryFilterParameter(filterParameter);
        this.getView().updateView(billList.getKey());
        billList.clearSelection();
    }

    public void click(SearchClickEvent searchClickEvent) {
        FilterParameter filterParameter;
        BillList billList = (BillList)this.getControl(this.TRACE_BILL_LIST);
        Map data = searchClickEvent.getCurrentCommonFilter();
        List qFilters = searchClickEvent.getFastQFilters();
        int size = ((List)data.get("Value")).size();
        if (size < 2) {
            if (data != null && !data.isEmpty()) {
                String fieldName = (String)((List)data.get("FieldName")).get(0);
                String value = (String)((List)data.get("Value")).get(0);
                Calendar calendar = Calendar.getInstance();
                switch (value) {
                    case "13": {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        QFilter toDayQFilter = new QFilter(fieldName, ">=", (Object)calendar.getTime());
                        calendar.add(5, 1);
                        QFilter toDayEndQFilter = new QFilter(fieldName, "<", (Object)calendar.getTime());
                        QFilter andToDayFilter = toDayQFilter.and(toDayEndQFilter);
                        qFilters.add(andToDayFilter);
                        break;
                    }
                    case "63": {
                        calendar.set(5, 1);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        QFilter monthStartQFilter = new QFilter(fieldName, ">=", (Object)calendar.getTime());
                        calendar.add(2, 1);
                        QFilter monthEndQFilter = new QFilter(fieldName, "<", (Object)calendar.getTime());
                        QFilter andFilter = monthStartQFilter.and(monthEndQFilter);
                        qFilters.add(andFilter);
                        break;
                    }
                    case "24": {
                        calendar.setTime(KDDateUtils.today());
                        calendar.add(2, -3);
                        QFilter lastThreeMonthQFilter = new QFilter(fieldName, ">=", (Object)calendar.getTime());
                        qFilters.add(lastThreeMonthQFilter);
                    }
                }
            }
            filterParameter = new FilterParameter(qFilters, "desc");
            billList.setQueryFilterParameter(filterParameter);
            this.getView().updateView(billList.getKey());
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String fieldName = (String)((List)data.get("FieldName")).get(0);
            List valueList = (List)data.get("Value");
            String value1 = valueList.get(0).toString();
            if (!value1.equals("")) {
                String value2 = valueList.get(1).toString();
                try {
                    Date date1 = sdf.parse(value1);
                    Date date2 = sdf.parse(value2);
                    if (date1.compareTo(date2) > 0) {
                        QFilter minFilter = new QFilter(fieldName, ">", (Object)date2);
                        QFilter maxFilter = new QFilter(fieldName, "<", (Object)date1);
                        QFilter resultQfilter = minFilter.and(maxFilter);
                        qFilters.add(resultQfilter);
                    } else {
                        QFilter minFilter = new QFilter(fieldName, ">", (Object)date1);
                        QFilter maxFilter = new QFilter(fieldName, "<", (Object)date2);
                        QFilter resultQfilter = minFilter.and(maxFilter);
                        qFilters.add(resultQfilter);
                    }
                }
                catch (ParseException e) {
                    logger.error("\u81ea\u5b9a\u4e49\u65e5\u671f\u8fc7\u6ee4\u5668\u5f02\u5e38...");
                }
            }
        }
        filterParameter = new FilterParameter(qFilters, "desc");
        billList.setQueryFilterParameter(filterParameter);
        this.getView().updateView(billList.getKey());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"traceid") || StringUtils.equals((CharSequence)fieldName, (CharSequence)"sessionid")) {
            BillList traceBillList = (BillList)hyperLinkClickEvent.getSource();
            ListSelectedRow selectedRow = traceBillList.getCurrentSelectedRowInfo();
            String pkId = selectedRow.toString().replace("[", "").replace("]", "").replaceAll("\"", "");
            DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"gai_log");
            long Id = rowData.getLong(fieldName);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("gai_log_view");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("id", (Object)Id);
            switch (fieldName) {
                case "traceid": {
                    showParameter.setCustomParam("origin", (Object)"trace");
                    showParameter.setCaption(String.format("Trace\u8be6\u60c5-%s", Id));
                    break;
                }
                case "sessionid": {
                    showParameter.setCustomParam("origin", (Object)"session");
                    showParameter.setCaption(String.format("\u4f1a\u8bdd\u8be6\u60c5-%s", Id));
                }
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public class TraceBillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dynamicObjects;
            String properties = this.buildProperties();
            List qFilters = super.getQFilters();
            QFilter dataQFilter = PermissionServiceHelper.getOperationRuleFilter((String)"gai", (String)"gai_log", (String)"view", (StringBuilder)new StringBuilder("\u65e0\u6743\u9650\u8bbf\u95ee"));
            QFilter[] filters = null;
            int fileSize = qFilters.size();
            switch (fileSize) {
                case 2: {
                    QFilter sessionFilter;
                    String beforeValue;
                    String fieldName;
                    ArrayList<Object> newQFilter = new ArrayList<Object>();
                    for (int i = 0; i < qFilters.size(); ++i) {
                        fieldName = ((QFilter)qFilters.get(i)).getProperty();
                        if (fieldName.equals("1")) {
                            beforeValue = ((QFilter)qFilters.get(i)).getValue().toString();
                            String value = beforeValue.substring(beforeValue.indexOf("#") + 1);
                            sessionFilter = new QFilter("sessionid", "=", (Object)Long.valueOf(value));
                            QFilter traceFilter = new QFilter("traceid", "=", (Object)Long.valueOf(value));
                            QFilter orFilter = sessionFilter.or(traceFilter);
                            newQFilter.add(orFilter);
                            continue;
                        }
                        newQFilter.add(qFilters.get(i));
                    }
                    filters = new QFilter[]{(QFilter)newQFilter.get(0), (QFilter)newQFilter.get(1), dataQFilter};
                    break;
                }
                case 1: {
                    QFilter sessionFilter;
                    String beforeValue;
                    QFilter oneFilter = (QFilter)qFilters.get(0);
                    String fieldName = oneFilter.getProperty();
                    if (fieldName.equals("1")) {
                        beforeValue = oneFilter.getValue().toString();
                        String value = beforeValue.substring(beforeValue.indexOf("#") + 1);
                        sessionFilter = new QFilter("sessionid", "=", (Object)Long.valueOf(value));
                        QFilter traceFilter = new QFilter("traceid", "=", (Object)Long.valueOf(value));
                        QFilter orFilter = sessionFilter.or(traceFilter);
                        filters = new QFilter[]{orFilter, dataQFilter};
                        break;
                    }
                    filters = new QFilter[]{oneFilter, dataQFilter};
                    break;
                }
                case 0: {
                    filters = new QFilter[]{dataQFilter};
                    break;
                }
                case 3: {
                    ArrayList<Object> threeQFilter = new ArrayList<Object>();
                    for (int i = 0; i < 3; ++i) {
                        String threeFieldName = ((QFilter)qFilters.get(i)).getProperty();
                        if (threeFieldName.equals("1")) {
                            String beforeValue = ((QFilter)qFilters.get(i)).getValue().toString();
                            String value = beforeValue.substring(beforeValue.indexOf("#") + 1);
                            QFilter sessionFilter = new QFilter("sessionid", "=", (Object)Long.valueOf(value));
                            QFilter traceFilter = new QFilter("traceid", "=", (Object)Long.valueOf(value));
                            QFilter orFilter = sessionFilter.or(traceFilter);
                            threeQFilter.add(orFilter);
                            continue;
                        }
                        threeQFilter.add(qFilters.get(i));
                    }
                    filters = new QFilter[]{(QFilter)threeQFilter.get(0), (QFilter)threeQFilter.get(1), (QFilter)threeQFilter.get(2), dataQFilter};
                }
            }
            DynamicObject[] tracesObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)properties, filters, (String)"createtime desc");
            int totalSize = tracesObjects.length;
            if (start > totalSize) {
                double pageHandle = totalSize / limit;
                int page = (int)Math.ceil(pageHandle);
                start = page * limit;
                BillList billList = (BillList)GaiTraceTabPlugin.this.getControl(GaiTraceTabPlugin.this.TRACE_BILL_LIST);
                billList.getEntryState().setCurrentPageIndex(Integer.valueOf(page + 1));
            }
            if ((dynamicObjects = this.CustomPageByDynamicObjectCollection(tracesObjects, start, limit)).size() == 0) {
                QFilter nullFilter = new QFilter("sessionid", "=", (Object)1111);
                dynamicObjects = QueryServiceHelper.query((String)"gai_log", (String)"sessionid, cloudid, appid", (QFilter[])nullFilter.toArray());
            }
            this.getQueryResult().setNumberFormatProvider(new NumberFormatProvider(new ArrayList(), dynamicObjects));
            this.getQueryResult().setCollection(dynamicObjects);
            this.getQueryResult().setDataCount(totalSize);
            return dynamicObjects;
        }

        public DynamicObjectCollection CustomPageByDynamicObjectCollection(DynamicObject[] tracesObjects, int start, int limit) {
            int fieldLength = tracesObjects.length;
            int index = 0;
            int dataCount = 0;
            DynamicObjectCollection newCollection = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : tracesObjects) {
                DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("entryentity");
                if (++index <= start) continue;
                if (dataCount >= limit) break;
                String inputContent = "";
                Date tmpMinTime = null;
                Date tmpMaxTime = null;
                int totalToken = 0;
                long tracelatency = 0L;
                for (DynamicObject subObject : collection) {
                    int childToken = (Integer)subObject.get("totaltoken");
                    totalToken += childToken;
                    Date beginDate = (Date)subObject.get("stepbegintime");
                    Date finishDate = (Date)subObject.get("stepfinishtime");
                    if (beginDate == null || finishDate == null) continue;
                    if (tmpMinTime == null || beginDate.compareTo(tmpMinTime) < 0) {
                        tmpMinTime = beginDate;
                        inputContent = subObject.get("stepinput_tag").toString();
                    }
                    if (tmpMaxTime != null && finishDate.compareTo(tmpMaxTime) <= 0) continue;
                    tmpMaxTime = finishDate;
                }
                if (tmpMaxTime != null && tmpMinTime != null) {
                    tracelatency = TimeUnit.MILLISECONDS.toSeconds(tmpMaxTime.getTime() - tmpMinTime.getTime());
                }
                dynamicObject.set("tracetoken", (Object)totalToken);
                dynamicObject.set("tracelatency", (Object)tracelatency);
                dynamicObject.set("traceinput", (Object)inputContent);
                dynamicObject.set("name", dynamicObject.get("createorg.name"));
                dynamicObject.set("chatsessionid", dynamicObject.get("creator.name"));
                newCollection.add((Object)dynamicObject);
                ++dataCount;
            }
            return newCollection;
        }

        public String buildProperties() {
            String traceProperties = StringUtils.join((Object[])new String[]{"traceid", "sessionid", "appid", "cloudid", "userid", "createtime", "tracetoken", "tracelatency", "traceinput", "name", "chatsessionid", "createorg.name", "creator.name"}, (String)",");
            String stepProperties = StringUtils.join((Object[])new String[]{String.format("%s.%s", "entryentity", "totaltoken"), String.format("%s.%s", "entryentity", "stepinput_tag"), String.format("%s.%s", "entryentity", "stepinput"), String.format("%s.%s", "entryentity", "stepbegintime"), String.format("%s.%s", "entryentity", "stepfinishtime")}, (String)",");
            StringUtils.join((Object[])new String[]{traceProperties, stepProperties}, (String)",");
            return StringUtils.join((Object[])new String[]{traceProperties, stepProperties}, (String)",");
        }
    }
}

