/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin.trace;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.ai.gai.core.trace.cache.TracePageCache;
import kd.ai.gai.core.trace.constant.Constant;
import kd.ai.gai.core.trace.entity.TraceNode;
import kd.ai.gai.core.trace.util.SessionLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public class GaiMonitorLogViewPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private TracePageCache cache;
    public static final String KEY_TREEVIEW = "treeviewap";
    public static final String TOOLBAR = "toolbarap";
    public static final String TREE_SEARCH_CONTROL = "searchap";
    public static final String TRACE_CACHE_KEY = "trace_cache";
    private static final String CUSTOM_CONTROL_TRACE = "ai_gai_monitor_trace";
    public static String LABEL_SESSION_PRE = "session_";
    public static String LABEL_TRACE_PRE = "trace_";
    public static String LABEL_STEP_PRE = "step_";
    public static String LABEL_SESSION_ID = "sessionid";
    public static String LABEL_TRACE_ID = "traceid";
    public static String LABEL_CLOUD_NAME = "cloudname";
    public static String LABEL_APP_NAME = "appname";
    public static String LABEL_TRACENUM = "tracenum";
    public static String LABEL_TOTAL_TOKEN = "totaltoken";
    public static String LABEL_LATENCY = "latency";
    public static String LABEL_CREATEORG = "createorg";
    public static String LABEL_USERID = "userid";
    public static String LABEL_CREATE_TIME = "createtime";
    public static String LABEL_STEPID = "step_stepid";
    public static String LABEL_GPT_PROCESS = "step_gpt_process";
    public static String LABEL_GPT_PROCESS_NODE = "step_gpt_process_node";
    public static String LABEL_STEP_TYPE = "step_steptype";
    public static String LABEL_STEP_MODELNAME = "step_modelname";
    public static String SESSION_AP = "session_ap";
    public static String TRACE_AP = "trace_ap";
    public static String STEP_AP = "step_ap";
    private static final String CUSTOM_EVENT_TRACE_VIEW = "showTraceView";
    private static final String TREE_NODE_CACHE_PRE = "tree_node_";
    public static TraceNode tree = new TraceNode();

    public TracePageCache getCache() {
        return this.cache;
    }

    public void initialize() {
        super.initialize();
        if (this.cache == null) {
            this.cache = new TracePageCache(this.getView().getPageId());
        }
    }

    public void destory() {
        super.destory();
        if (this.cache != null) {
            this.cache.saveChanges();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        if (this.cache != null) {
            this.cache.release();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBAR});
        Search search = (Search)this.getControl(TREE_SEARCH_CONTROL);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String origin = (String)formShowParameter.getCustomParam("origin");
        long id = (Long)formShowParameter.getCustomParam("id");
        if (StringUtils.isEmpty((CharSequence)origin)) {
            this.getView().showErrorNotification("\u7f3a\u5c11origin\u53c2\u6570");
            return;
        }
        if (id == 0L) {
            this.getView().showErrorNotification("\u7f3a\u5c11id\u53c2\u6570");
            return;
        }
        QFilter filter = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"session")) {
            filter = new QFilter("sessionid", "=", (Object)id);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"trace")) {
            long sessionId = this.findSessionIdByTrace(id);
            filter = new QFilter("sessionid", "=", (Object)sessionId);
        } else {
            return;
        }
        this.initTraceTree(new QFilter[]{filter});
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", id);
        data.put("origin", origin);
        this.getView().getPageCache().put(TRACE_CACHE_KEY, JSONObject.toJSONString(data));
        if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"session")) {
            this.focusNode(String.valueOf(id));
            this.showSessionDetail(id);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"trace")) {
            this.focusNode(String.valueOf(id));
            this.showTraceDetail(id);
        }
    }

    private long findSessionIdByTrace(long traceId) {
        DynamicObject dynamicObject = SessionLogUtil.queryTraceDetail((QFilter[])new QFilter[]{new QFilter("traceid", "=", (Object)traceId)});
        if (dynamicObject == null) {
            return 0L;
        }
        long sessionId = dynamicObject.getLong("sessionid");
        return sessionId;
    }

    private void initTraceTree(QFilter[] filters) {
        tree = this.buildTraceTree(filters);
        this.showTree(tree);
    }

    public void showTree(TraceNode tree) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode("", tree.getNodeId(), tree.getDisplayName());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("nodeType", Constant.NodeType.SESSION.toString());
        root.setData(data);
        JSONObject rootNodeData = this.buildTreeNode("", tree.getNodeId(), tree.getDisplayName(), Constant.NodeType.SESSION.toString());
        this.getCache().put(String.format("%s%s", TREE_NODE_CACHE_PRE, tree.getNodeId()), JSONObject.toJSONString((Object)rootNodeData));
        root.setIsOpened(Boolean.TRUE.booleanValue());
        treeView.addNode(root);
        treeView.setRootVisible(Boolean.TRUE.booleanValue());
        this.addTreeNodes(root, tree.getNodeId(), tree.getChilds());
        root.setExpend(Boolean.TRUE.booleanValue());
    }

    public void addTreeNodes(final TreeNode parentTreeNode, final String parentNodeId, List<TraceNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            nodes.stream().forEach(new Consumer<TraceNode>(){

                @Override
                public void accept(TraceNode node) {
                    String nodeId = node.getNodeId();
                    String nodeType = node.getNodeType();
                    String displayName = node.getDisplayName();
                    TreeNode treeNode = new TreeNode(parentNodeId, nodeId, displayName);
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("nodeType", nodeType);
                    treeNode.setData(data);
                    parentTreeNode.addChild(treeNode);
                    JSONObject treeNodeData = GaiMonitorLogViewPlugin.this.buildTreeNode(parentNodeId, nodeId, displayName, nodeType);
                    GaiMonitorLogViewPlugin.this.getCache().put(String.format("%s%s", GaiMonitorLogViewPlugin.TREE_NODE_CACHE_PRE, nodeId), JSONObject.toJSONString((Object)treeNodeData));
                    List subNodes = node.getChilds();
                    if (subNodes != null && subNodes.size() > 0) {
                        GaiMonitorLogViewPlugin.this.addTreeNodes(treeNode, nodeId, subNodes);
                    }
                }
            });
        }
    }

    private JSONObject buildTreeNode(String parentNodeId, String nodeId, String nodeName, String nodeType) {
        JSONObject data = new JSONObject();
        data.put("parentNodeId", (Object)parentNodeId);
        data.put("nodeId", (Object)nodeId);
        data.put("nodeName", (Object)nodeName);
        data.put("nodeType", (Object)nodeType);
        return data;
    }

    private TraceNode buildTraceTree(QFilter[] filters) {
        DynamicObject[] tracesObjects = SessionLogUtil.querySessionTraces((QFilter[])filters);
        final ArrayList nodes = new ArrayList();
        if (tracesObjects != null && tracesObjects.length > 0) {
            Arrays.stream(tracesObjects).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    String sessionId = String.valueOf(dynamicObject.getLong("sessionid"));
                    String traceId = String.valueOf(dynamicObject.getLong("traceid"));
                    TraceNode sessionNode = new TraceNode(sessionId, sessionId);
                    sessionNode.setNodeType(Constant.NodeType.SESSION.toString());
                    sessionNode.setDisplayName(String.format("\u4f1a\u8bdd\uff08ID:%s\uff09", sessionId));
                    TraceNode traceNode = new TraceNode(traceId, traceId, sessionId, Constant.NodeType.TRACE.toString());
                    traceNode.setDisplayName(String.format("Trace\uff08ID:%s\uff09", traceId));
                    if (!nodes.contains(sessionNode)) {
                        sessionNode.getChilds().add(traceNode);
                        nodes.add(sessionNode);
                    } else {
                        ((TraceNode)nodes.get(nodes.indexOf(sessionNode))).getChilds().add(traceNode);
                    }
                    DynamicObjectCollection steps = dynamicObject.getDynamicObjectCollection("entryentity");
                    steps.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return Long.compare(o1.getLong("id"), o2.getLong("id"));
                        }
                    });
                    for (DynamicObject step : steps) {
                        String stepId = String.valueOf(step.getLong("stepid"));
                        String stepType = step.getString("steptype");
                        TraceNode stepNode = new TraceNode(stepId, stepType, traceId, Constant.NodeType.STEP.toString());
                        stepNode.setDisplayName(String.format("%s(%s)", Constant.StepType.getStepTypeName((String)stepType), stepType));
                        traceNode.getChilds().add(stepNode);
                    }
                }
            });
        }
        return (TraceNode)nodes.get(0);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (!StringUtils.isEmpty((CharSequence)text)) {
            QFilter filter = this.getQFilterCache();
            this.initTraceTree(new QFilter[]{filter});
            List<String> nodes = this.searchTraceNodeByKeywords(text);
            if (nodes.isEmpty()) {
                return;
            }
            this.focusNodes(nodes);
        } else {
            QFilter filter = this.getQFilterCache();
            this.initTraceTree(new QFilter[]{filter});
        }
    }

    private void focusNode(String nodeId) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode node = new TreeNode();
        node.setId(nodeId);
        treeView.focusNode(node);
    }

    private void focusNodes(List<String> nodes) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        if (!nodes.isEmpty()) {
            ArrayList<TreeNode> updates = new ArrayList<TreeNode>(nodes.size());
            ArrayList<String> parents = new ArrayList<String>(nodes.size());
            for (String nodeId : nodes) {
                String nodeJson = this.getCache().get(String.format("%s%s", TREE_NODE_CACHE_PRE, nodeId));
                JSONObject nodeData = JSONObject.parseObject((String)nodeJson);
                String nodeName = nodeData.getString("nodeName");
                String parentNodeId = nodeData.getString("parentNodeId");
                parents.add(parentNodeId);
                TreeNode treeNode = new TreeNode();
                treeNode.setId(nodeId);
                treeNode.setText(nodeName);
                treeNode.setColor("#5582F3");
                updates.add(treeNode);
            }
            parents.stream().forEach(node -> treeView.expand(node));
            treeView.updateNodes(updates);
        }
    }

    public List<String> searchTraceNodeByKeywords(String key) {
        List nodes;
        ArrayList<String> res = new ArrayList<String>();
        if (tree != null && !(nodes = tree.getChilds()).isEmpty()) {
            res.addAll(this.searchTraceNodeByKeywords(key, nodes));
        }
        return res;
    }

    public List<String> searchTraceNodeByKeywords(String key, List<TraceNode> childs) {
        ArrayList<String> res = new ArrayList<String>();
        if (!childs.isEmpty()) {
            for (TraceNode catalog : childs) {
                String nodeName = catalog.getNodeName();
                String nodeId = catalog.getNodeId();
                String displayName = catalog.getDisplayName();
                String nodeJson = this.getCache().get(String.format("%s%s", TREE_NODE_CACHE_PRE, nodeId));
                JSONObject nodeData = JSONObject.parseObject((String)nodeJson);
                String nodeType = nodeData.getString("nodeType");
                if ((nodeName.contains(key) || displayName.contains(key)) && StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)Constant.NodeType.STEP.toString())) {
                    res.add(nodeId);
                }
                List subs = catalog.getChilds();
                List<String> result = this.searchTraceNodeByKeywords(key, subs);
                res.addAll(result);
            }
        }
        return res;
    }

    private QFilter getQFilterCache() {
        String filterJson = this.getView().getPageCache().get(TRACE_CACHE_KEY);
        Map data = (Map)JSONObject.parseObject((String)filterJson, HashMap.class);
        String origin = (String)data.get("origin");
        long id = (Long)data.get("id");
        QFilter filter = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"session")) {
            filter = new QFilter("sessionid", "=", (Object)id);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)origin, (CharSequence)"trace")) {
            long sessionId = this.findSessionIdByTrace(id);
            filter = new QFilter("sessionid", "=", (Object)sessionId);
        }
        return filter;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        TreeView treeView = (TreeView)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_TREEVIEW, (CharSequence)treeView.getKey())) {
            Object obj = evt.getNodeId();
            String nodeId = (String)obj;
            String nodeJson = this.getCache().get(String.format("%s%s", TREE_NODE_CACHE_PRE, nodeId));
            if (!StringUtils.isEmpty((CharSequence)nodeJson)) {
                JSONObject nodeData = JSONObject.parseObject((String)nodeJson);
                String nodeType = nodeData.getString("nodeType");
                if (StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)Constant.NodeType.SESSION.toString())) {
                    this.showSessionDetail(Long.parseLong(nodeId));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)Constant.NodeType.TRACE.toString())) {
                    this.showTraceDetail(Long.parseLong(nodeId));
                } else if (StringUtils.equalsIgnoreCase((CharSequence)nodeType, (CharSequence)Constant.NodeType.STEP.toString())) {
                    this.showStepDetail(Long.parseLong(nodeId));
                }
            }
        }
    }

    private void showSessionDetail(long sessionId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{SESSION_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{TRACE_AP, STEP_AP});
        JSONObject data = SessionLogUtil.querySessionDetail((long)sessionId);
        JSONArray sessionData = new JSONArray();
        Date sessionBeginDate = null;
        if (data != null && data.containsKey((Object)"traces")) {
            JSONArray traces = data.getJSONArray("traces");
            for (int i = 0; i < traces.size(); ++i) {
                JSONObject trace = traces.getJSONObject(i);
                if (i == 0) {
                    sessionBeginDate = trace.getDate("createtime");
                }
                JSONObject traceControl = new JSONObject();
                String traceInput = trace.getString("traceinput");
                String traceOutput = trace.getString("traceoutput");
                traceControl.put("traceId", (Object)trace.getString("traceid"));
                traceControl.put("date", (Object)trace.getDate("createtime"));
                JSONArray messages = new JSONArray();
                traceControl.put("messages", (Object)messages);
                JSONObject user = new JSONObject();
                user.put("sender", (Object)"user");
                user.put("text", (Object)traceInput);
                user.put("avatar", (Object)data.getString("avatar"));
                JSONObject bot = new JSONObject();
                bot.put("sender", (Object)"bot");
                bot.put("text", (Object)traceOutput);
                messages.add((Object)user);
                messages.add((Object)bot);
                sessionData.add((Object)traceControl);
            }
            data.put("createtime", sessionBeginDate);
        }
        this.showSessionLabelInfo(data);
        this.showCustomControl(this.getCustomData(sessionData, Constant.LogType.SESSION.getKey()));
    }

    private void showTraceDetail(long traceId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{TRACE_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{SESSION_AP, STEP_AP});
        JSONObject data = SessionLogUtil.queryTraceDetail((long)traceId);
        JSONArray traceData = new JSONArray();
        if (data != null && data.containsKey((Object)"traces")) {
            JSONArray traces = data.getJSONArray("traces");
            for (int i = 0; i < traces.size(); ++i) {
                JSONObject trace = traces.getJSONObject(i);
                String tid = trace.getString("traceid");
                if (!StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(traceId), (CharSequence)tid)) continue;
                JSONObject traceInputObj = new JSONObject();
                traceInputObj.put("role", (Object)"input");
                traceInputObj.put("content", (Object)trace.getString("traceinput"));
                JSONObject traceOutputObj = new JSONObject();
                traceOutputObj.put("role", (Object)"output");
                traceOutputObj.put("content", (Object)trace.getString("traceoutput"));
                traceData.add((Object)traceInputObj);
                traceData.add((Object)traceOutputObj);
                this.showTraceLabelInfo(data, trace);
            }
        }
        this.showCustomControl(this.getCustomData(traceData, Constant.LogType.TRACE.getKey()));
    }

    private void showStepDetail(long stepId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{STEP_AP});
        this.getView().setVisible(Boolean.FALSE, new String[]{TRACE_AP, SESSION_AP});
        JSONObject data = SessionLogUtil.queryStepDetail((long)stepId);
        JSONArray stepData = new JSONArray();
        JSONObject stepInputObj = new JSONObject();
        stepInputObj.put("role", (Object)"input");
        stepInputObj.put("content", (Object)data.getString("stepinput"));
        JSONObject stepOutputObj = new JSONObject();
        stepOutputObj.put("role", (Object)"output");
        stepOutputObj.put("content", (Object)data.getString("stepoutput"));
        JSONObject stepMetadataObj = new JSONObject();
        stepMetadataObj.put("role", (Object)"metadata");
        stepMetadataObj.put("content", (Object)data.getString("metadata_tag"));
        JSONObject tagObj = new JSONObject();
        tagObj.put("role", (Object)"tags");
        tagObj.put("content", (Object)data.getString("tags"));
        stepData.add((Object)stepInputObj);
        stepData.add((Object)stepOutputObj);
        stepData.add((Object)tagObj);
        stepData.add((Object)stepMetadataObj);
        this.showStepLabelInfo(data);
        this.showCustomControl(this.getCustomData(stepData, Constant.LogType.STEP.getKey()));
    }

    private JSONObject getCustomData(JSONArray cdata, String type) {
        JSONObject data = new JSONObject();
        data.put("data", (Object)cdata);
        data.put("type", (Object)type);
        return data;
    }

    public void showSessionLabelInfo(JSONObject data) {
        if (data != null) {
            Label sessionLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_SESSION_ID));
            Label cloudLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_CLOUD_NAME));
            Label appLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_APP_NAME));
            Label traceLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_TRACENUM));
            Label tokenLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_TOTAL_TOKEN));
            Label latencyLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_LATENCY));
            Label createOrgLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_CREATEORG));
            Label userLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_USERID));
            Label createTimeLabel = (Label)this.getControl(String.format("%s%s", LABEL_SESSION_PRE, LABEL_CREATE_TIME));
            sessionLabel.setText(data.getString("sessionid"));
            appLabel.setText(data.getString("appid"));
            cloudLabel.setText(data.getString("cloudid"));
            traceLabel.setText(data.getString("tracenum"));
            tokenLabel.setText(data.getString("totaltoken"));
            latencyLabel.setText(this.formatLatency(data.getBigDecimal("latency")));
            createOrgLabel.setText(data.getString("createorg_name"));
            userLabel.setText(data.getString("username"));
            createTimeLabel.setText(data.getString("createtime"));
        }
    }

    public void showTraceLabelInfo(JSONObject data, JSONObject trace) {
        if (data != null) {
            Label cloudLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_CLOUD_NAME));
            Label appLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_APP_NAME));
            Label tokenLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_TOTAL_TOKEN));
            Label latencyLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_LATENCY));
            Label createOrgLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_CREATEORG));
            Label userLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_USERID));
            appLabel.setText(data.getString("appid"));
            cloudLabel.setText(data.getString("cloudid"));
            tokenLabel.setText(trace.getString("totaltoken"));
            latencyLabel.setText(this.formatLatency(trace.getBigDecimal("latency")));
            createOrgLabel.setText(data.getString("createorg_name"));
            userLabel.setText(data.getString("username"));
        }
        if (trace != null) {
            Label traceLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_TRACE_ID));
            Label createTimeLabel = (Label)this.getControl(String.format("%s%s", LABEL_TRACE_PRE, LABEL_CREATE_TIME));
            createTimeLabel.setText(trace.getString("createtime"));
            traceLabel.setText(trace.getString("traceid"));
        }
    }

    public void showStepLabelInfo(JSONObject data) {
        if (data != null) {
            Label stepIdLabel = (Label)this.getControl(LABEL_STEPID);
            Label stepTypeLabel = (Label)this.getControl(LABEL_STEP_TYPE);
            Label gptProcessLabel = (Label)this.getControl(LABEL_GPT_PROCESS);
            Label gptProcessNodeLabel = (Label)this.getControl(LABEL_GPT_PROCESS_NODE);
            Label modelNameLabel = (Label)this.getControl(LABEL_STEP_MODELNAME);
            Label tokenLabel = (Label)this.getControl(String.format("%s%s", LABEL_STEP_PRE, LABEL_TOTAL_TOKEN));
            Label latencyLabel = (Label)this.getControl(String.format("%s%s", LABEL_STEP_PRE, LABEL_LATENCY));
            Label createTimeLabel = (Label)this.getControl(String.format("%s%s", LABEL_STEP_PRE, LABEL_CREATE_TIME));
            stepIdLabel.setText(data.getString("stepid"));
            stepTypeLabel.setText(String.format("%s(%s)", data.getString("steptype_name"), data.getString("steptype")));
            gptProcessLabel.setText(data.getString("gptprocessname"));
            long gptNodeId = data.getLong("gptprocessnodeid");
            String gptNodeName = data.getString("gptprocessnodename");
            gptProcessNodeLabel.setText(StringUtils.isEmpty((CharSequence)gptNodeName) ? (gptNodeId == 0L ? "" : String.valueOf(gptNodeId)) : gptNodeName);
            modelNameLabel.setText(data.getString("modelname"));
            tokenLabel.setText(data.getString("totaltoken"));
            latencyLabel.setText(this.formatLatency(data.getBigDecimal("latency")));
            createTimeLabel.setText(data.getString("step_createtime"));
        }
    }

    private String formatLatency(BigDecimal latency) {
        if (latency != null && BigDecimal.ZERO.compareTo(latency) != 0) {
            return String.format("%s%s", latency.divide(new BigDecimal(1000)).setScale(3, RoundingMode.HALF_UP), "s");
        }
        return String.format("%s%s", 0, "s");
    }

    private void showCustomControl(JSONObject data) {
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("chartType", CUSTOM_CONTROL_TRACE);
        customData.put("containerId", CUSTOM_CONTROL_TRACE);
        customData.put("timestamp", new Date().getTime());
        customData.put("data", data);
        customData.put("eventName", Constant.CustomControlEventNameEnum.CREATE_NEW_DATA.getKey());
        customData.put("pageId", this.getView().getPageId());
        CustomControl customControl = (CustomControl)this.getControl(CUSTOM_CONTROL_TRACE);
        customControl.setData(customData);
    }

    public void customEvent(CustomEventArgs e) {
        String traceId;
        JSONObject info;
        String args;
        super.customEvent(e);
        String controlKey = e.getKey();
        String eventName = e.getEventName();
        if (CUSTOM_CONTROL_TRACE.equals(controlKey) && CUSTOM_EVENT_TRACE_VIEW.equals(eventName) && !StringUtils.isEmpty((CharSequence)(args = e.getEventArgs())) && (info = JSONObject.parseObject((String)args)) != null && !StringUtils.isEmpty((CharSequence)(traceId = info.getString("traceId")))) {
            this.focusNode(traceId);
            this.showTraceDetail(Long.parseLong(traceId));
        }
    }
}

