/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.cache;

import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;

public class AppCache {
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    private AppCache() {
    }

    public static AppCache get() {
        return Holder.instance;
    }

    private String getParentKey() {
        RequestContext rc = RequestContext.get();
        return CacheKeyUtil.getAcctId() + ".ids." + rc.getTenantId() + "_appcache_";
    }

    public void put(String key, String value, int timeoutSeconds) {
        this.cache.put(this.getParentKey(), key, value, timeoutSeconds, TimeUnit.SECONDS);
    }

    public String[] getList(String key) {
        return this.cache.getList(this.getParentKey() + key);
    }

    public String get(String key) {
        return (String)this.cache.get(this.getParentKey(), key);
    }

    public List<String> mget(String ... key) {
        return this.cache.get(this.getParentKey(), key);
    }

    public void remove(String key) {
        this.cache.remove(this.getParentKey(), key);
    }

    public void removeWithKeyPrefix(String keyPrefix) {
        String parentKey = this.getParentKey();
        List keyList = this.cache.getKeysWithPrefix(parentKey, keyPrefix);
        if (keyList != null && !keyList.isEmpty()) {
            this.cache.remove(parentKey, keyList.toArray(new String[0]));
        }
    }

    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.cache.addList(this.getParentKey() + key, values, timeout, timeUnit);
    }

    public int getListLength(String key) {
        return this.cache.getListLength(this.getParentKey() + key);
    }

    public int insertList(String key, int index, String[] values) {
        return this.cache.insertList(this.getParentKey() + key, index, values);
    }

    public void removeList(String key) {
        this.cache.remove(this.getParentKey() + key);
    }

    private static class Holder {
        private static final AppCache instance = new AppCache();

        private Holder() {
        }
    }
}

