/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.bos.dataentity.utils.StringUtils;

public class SessionCache {
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    private SessionCache() {
    }

    public static SessionCache get() {
        return Holder.instance;
    }

    private String getParentKey() {
        RequestContext rc = RequestContext.get();
        return CacheKeyUtil.getAcctId() + ".ids." + rc.getTenantId() + "." + rc.getGlobalSessionId() + "_appcache_";
    }

    public void put(String key, String value) {
        this.cache.put(this.getParentKey(), key, (Object)value);
    }

    public void put(String key, String value, int timeoutSeconds) {
        this.cache.put(this.getParentKey(), key, value, timeoutSeconds, TimeUnit.SECONDS);
    }

    public String get(String key) {
        return (String)this.cache.get(this.getParentKey(), key);
    }

    public List<String> mget(String ... key) {
        return this.cache.get(this.getParentKey(), key);
    }

    public void remove(String key) {
        this.cache.remove(this.getParentKey(), key);
    }

    public void clear() {
        this.cache.removeType(this.getParentKey());
    }

    public JSONObject getAsObject(String keyName) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return JSON.parseObject((String)s);
    }

    public <T> List<T> getAsList(String keyName, Class<T> clazz) {
        String s = this.get(keyName);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new ArrayList();
        }
        return JSON.parseArray((String)s, clazz);
    }

    private static class Holder {
        private static final SessionCache instance = new SessionCache();

        private Holder() {
        }
    }
}

