/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.entity.model.sf.std;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.ai.ids.core.entity.model.sf.std.AppConfig;
import kd.ai.ids.core.entity.model.sf.std.Fdatasources;
import kd.ai.ids.core.entity.model.sf.std.Fdim;
import kd.ai.ids.core.entity.model.sf.std.Freferfield;
import kd.ai.ids.core.entity.model.sf.std.Fschemetemplate;
import kd.ai.ids.core.entity.model.sf.std.Ftimegranularity;
import kd.ai.ids.core.entity.model.sf.std.Ftype;
import kd.ai.ids.core.entity.model.sf.std.Fvaluetype;
import kd.ai.ids.core.enumtype.DimEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SchemeConfig {
    private String fdatasource;
    private String ftimefield;
    private String fpricefield;
    private String fschemetemplate;
    private List<String> org;
    private List<String> cust;
    private List<String> product;
    private JSONObject custstandard;
    private JSONObject productstandard;
    private List<String> fvaluetype;
    private List<String> ftimegranularity;
    private int fpredictlength;
    private int fpredictstride;

    public void setFdatasource(String fdatasource) {
        this.fdatasource = fdatasource;
    }

    public String getFdatasource() {
        return this.fdatasource;
    }

    public void setFtimefield(String ftimefield) {
        this.ftimefield = ftimefield;
    }

    public String getFtimefield() {
        return this.ftimefield;
    }

    public void setFpricefield(String fpricefield) {
        this.fpricefield = fpricefield;
    }

    public String getFpricefield() {
        return this.fpricefield;
    }

    public void setFschemetemplate(String fschemetemplate) {
        this.fschemetemplate = fschemetemplate;
    }

    public String getFschemetemplate() {
        return this.fschemetemplate;
    }

    public void setOrg(List<String> org) {
        this.org = org;
    }

    public List<String> getOrg() {
        return this.org;
    }

    public void setCust(List<String> cust) {
        this.cust = cust;
    }

    public List<String> getCust() {
        return this.cust;
    }

    public void setProduct(List<String> product) {
        this.product = product;
    }

    public List<String> getProduct() {
        return this.product;
    }

    public void setCuststandard(JSONObject custstandard) {
        this.custstandard = custstandard;
    }

    public JSONObject getCuststandard() {
        return this.custstandard;
    }

    public void setProductstandard(JSONObject productstandard) {
        this.productstandard = productstandard;
    }

    public JSONObject getProductstandard() {
        return this.productstandard;
    }

    public void setFvaluetype(List<String> fvaluetype) {
        this.fvaluetype = fvaluetype;
    }

    public List<String> getFvaluetype() {
        return this.fvaluetype;
    }

    public void setFtimegranularity(List<String> ftimegranularity) {
        this.ftimegranularity = ftimegranularity;
    }

    public List<String> getFtimegranularity() {
        return this.ftimegranularity;
    }

    public void setFpredictlength(int fpredictlength) {
        this.fpredictlength = fpredictlength;
    }

    public int getFpredictlength() {
        return this.fpredictlength;
    }

    public void setFpredictstride(int fpredictstride) {
        this.fpredictstride = fpredictstride;
    }

    public int getFpredictstride() {
        return this.fpredictstride;
    }

    public String getDimName(AppConfig appConfig, DimEnum dimEnum) {
        String name = "";
        List<Fdatasources> fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFdatasource())).findFirst().get();
        List<Fschemetemplate> fschemetemplateList = fdatasources.getFschemetemplate();
        Fschemetemplate fschemetemplate = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFschemetemplate())).findFirst().get();
        List<Fdim> fdimList = fschemetemplate.getFdim();
        Optional<Fdim> fdim = fdimList.stream().filter(e -> e.getFid().equalsIgnoreCase(dimEnum.getId())).findFirst();
        if (fdim.isPresent()) {
            List<Ftype> ftypeList = fdim.get().getFtype();
            HashMap<String, String> idNameMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty(ftypeList)) {
                for (Ftype ftype : ftypeList) {
                    idNameMap.put(ftype.getFid(), ftype.getFname());
                }
            }
            List<String> fidList = null;
            if (dimEnum.getId().equalsIgnoreCase(DimEnum.ORG.getId())) {
                fidList = this.getOrg();
            } else if (dimEnum.getId().equalsIgnoreCase(DimEnum.CUST.getId())) {
                fidList = this.getCust();
            } else if (dimEnum.getId().equalsIgnoreCase(DimEnum.PRODUCT.getId())) {
                fidList = this.getProduct();
            }
            name = this.getNames(fidList, idNameMap);
        }
        return name;
    }

    public String getDimName(AppConfig appConfig, String dimfid) {
        String name = "";
        List<Fdatasources> fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFdatasource())).findFirst().get();
        List<Fschemetemplate> fschemetemplateList = fdatasources.getFschemetemplate();
        Fschemetemplate fschemetemplate = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFschemetemplate())).findFirst().get();
        List<Fdim> fdimList = fschemetemplate.getFdim();
        HashMap<String, String> idNameMap = new HashMap<String, String>();
        for (Fdim fdim : fdimList) {
            List<Ftype> ftypeList = fdim.getFtype();
            if (CollectionUtils.isEmpty(ftypeList)) continue;
            for (Ftype ftype : ftypeList) {
                idNameMap.put(ftype.getFid(), ftype.getFname());
            }
        }
        name = idNameMap.getOrDefault(dimfid, "\u672a\u77e5\u7ef4\u5ea6");
        return name;
    }

    public Ftype getFtype(AppConfig appConfig, String ftypeid) {
        Ftype ftype = null;
        List<Fdatasources> fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFdatasource())).findFirst().get();
        List<Fschemetemplate> fschemetemplateList = fdatasources.getFschemetemplate();
        Fschemetemplate fschemetemplate = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFschemetemplate())).findFirst().get();
        List<Fdim> fdimList = fschemetemplate.getFdim();
        for (Fdim fdim : fdimList) {
            Optional<Ftype> first;
            List<Ftype> ftypeList = fdim.getFtype();
            if (CollectionUtils.isEmpty(ftypeList) || !(first = ftypeList.stream().filter(e -> e.getFid().equalsIgnoreCase(ftypeid)).findFirst()).isPresent()) continue;
            ftype = first.get();
        }
        return ftype;
    }

    public String getFvaluetypeName(AppConfig appConfig) {
        String name = "";
        List<Fdatasources> fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFdatasource())).findFirst().get();
        List<Fschemetemplate> fschemetemplateList = fdatasources.getFschemetemplate();
        Fschemetemplate fschemetemplate = fschemetemplateList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFschemetemplate())).findAny().get();
        List<Fvaluetype> fvaluetypeList = fschemetemplate.getFvaluetype();
        HashMap<String, String> idNameMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(fvaluetypeList)) {
            for (Fvaluetype fvaluetype : fvaluetypeList) {
                idNameMap.put(fvaluetype.getFid(), fvaluetype.getFname());
            }
        }
        List<String> fidList = this.getFvaluetype();
        name = this.getNames(fidList, idNameMap);
        return name;
    }

    public String getFtimegranularityName(AppConfig appConfig) {
        String name = "";
        List<Ftimegranularity> ftimegranularityList = appConfig.getFtimegranularity();
        HashMap<String, String> idNameMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(ftimegranularityList)) {
            for (Ftimegranularity ftimegranularity : ftimegranularityList) {
                idNameMap.put(ftimegranularity.getFid(), ftimegranularity.getFname());
            }
        }
        List<String> fidList = this.getFtimegranularity();
        name = this.getNames(fidList, idNameMap);
        return name;
    }

    private String getNames(List<String> fidList, Map<String, String> idNameMap) {
        String name = "";
        if (!CollectionUtils.isEmpty(fidList)) {
            for (String fid : fidList) {
                name = StringUtils.isEmpty((CharSequence)name) ? idNameMap.get(fid) : String.format("%s\u3001%s", name, idNameMap.get(fid));
            }
        }
        return name;
    }

    public String getStandardId(JSONObject standardJo) {
        String fcuststandardid = null;
        if (standardJo != null) {
            for (String key : standardJo.keySet()) {
                JSONArray valueJa = standardJo.getJSONArray(key);
                if (valueJa == null || valueJa.size() <= 0) continue;
                fcuststandardid = String.valueOf(valueJa.getBigInteger(0));
            }
        }
        return fcuststandardid;
    }

    public List<String> getFidListByDim(String fdimid, AppConfig appConfig) {
        List<Object> ftypeidList = new ArrayList();
        if (fdimid.equalsIgnoreCase(DimEnum.ORG.getId())) {
            ftypeidList = this.getOrg();
        } else if (fdimid.equalsIgnoreCase(DimEnum.CUST.getId())) {
            ftypeidList = this.getCust();
        } else if (fdimid.equalsIgnoreCase(DimEnum.PRODUCT.getId()) && CollectionUtils.isNotEmpty(ftypeidList = this.getProduct())) {
            ArrayList<String> productFtypeidList = new ArrayList<String>();
            for (String string : ftypeidList) {
                Ftype ftype = this.getFtype(appConfig, string);
                if (ftype == null) continue;
                if (StringUtils.isEmpty((CharSequence)ftype.getFentityid()) && CollectionUtils.isNotEmpty(ftype.getFreferfield())) {
                    for (Freferfield freferfield : ftype.getFreferfield()) {
                        productFtypeidList.add(freferfield.getFid());
                    }
                    continue;
                }
                productFtypeidList.add(string);
            }
            ftypeidList = productFtypeidList;
        }
        return ftypeidList;
    }

    public List<String> getAllFtypeidList(AppConfig appConfig) {
        ArrayList<String> ftypeidList = new ArrayList<String>();
        List<String> orgList = this.getOrg();
        List<String> custList = this.getCust();
        List<String> productList = this.getProduct();
        if (!CollectionUtils.isEmpty(orgList)) {
            ftypeidList.addAll(orgList);
        }
        if (!CollectionUtils.isEmpty(custList)) {
            ftypeidList.addAll(custList);
        }
        if (!CollectionUtils.isEmpty(productList)) {
            ArrayList<String> productFtypeidList = new ArrayList<String>();
            for (String ftypeid : productList) {
                Ftype ftype = this.getFtype(appConfig, ftypeid);
                if (ftype == null) continue;
                if (StringUtils.isEmpty((CharSequence)ftype.getFentityid()) && CollectionUtils.isNotEmpty(ftype.getFreferfield())) {
                    for (Freferfield freferfield : ftype.getFreferfield()) {
                        productFtypeidList.add(freferfield.getFid());
                    }
                    continue;
                }
                productFtypeidList.add(ftypeid);
            }
            ftypeidList.addAll(productFtypeidList);
        }
        return ftypeidList;
    }

    public Map<String, Ftype> getFidFTypeMap(AppConfig appConfig) {
        List<Fschemetemplate> fschemetemplateList;
        Fschemetemplate fschemetemplate;
        Fdatasources fdatasources;
        HashMap<String, Ftype> map = new HashMap<String, Ftype>();
        List<Fdatasources> fdatasourcesList = appConfig.getFdatasources();
        Fdatasources fdatasources2 = fdatasources = CollectionUtils.isEmpty(fdatasourcesList = fdatasourcesList.stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFdatasource())).collect(Collectors.toList())) ? null : fdatasourcesList.get(0);
        if (fdatasources != null && (fschemetemplate = (fschemetemplateList = fdatasources.getFschemetemplate()).stream().filter(e -> e.getFid().equalsIgnoreCase(this.getFschemetemplate())).findFirst().get()) != null) {
            List<String> allFtypeidList = this.getAllFtypeidList(appConfig);
            List<Fdim> fdimList = fschemetemplate.getFdim();
            for (Fdim fdim : fdimList) {
                List<Ftype> ftypeList = fdim.getFtype();
                for (Ftype ftype : ftypeList) {
                    if (StringUtils.isEmpty((CharSequence)ftype.getFentityid()) && CollectionUtils.isNotEmpty(ftype.getFreferfield())) {
                        for (Freferfield freferfield : ftype.getFreferfield()) {
                            Ftype tempFtype = new Ftype();
                            tempFtype.setFid(freferfield.getFid());
                            tempFtype.setFname(freferfield.getFname());
                            tempFtype.setFentityid(freferfield.getFentityid());
                            map.put(tempFtype.getFid(), tempFtype);
                        }
                        continue;
                    }
                    map.put(ftype.getFid(), ftype);
                }
            }
        }
        return map;
    }
}

