/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.enumtype;

import org.apache.commons.lang3.StringUtils;

public enum ExecuteStatusEnum {
    INIT(0, "\u7b49\u5f85\u6267\u884c"),
    EXECUTING(10, "\u6267\u884c\u4e2d"),
    SUCCESS(20, "\u6267\u884c\u6210\u529f"),
    FAIL(30, "\u6267\u884c\u5931\u8d25");

    private final int key;
    private final String name;

    private ExecuteStatusEnum(int key, String name) {
        this.key = key;
        this.name = name;
    }

    public int getKey() {
        return this.key;
    }

    public static boolean isExecuting(String executeStatus) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)executeStatus, (CharSequence[])new CharSequence[]{INIT.getKeyStr(), EXECUTING.getKeyStr()});
    }

    public String getName() {
        return this.name;
    }

    public static ExecuteStatusEnum fromKey(int key) {
        for (ExecuteStatusEnum e : ExecuteStatusEnum.values()) {
            if (e.getKey() != key) continue;
            return e;
        }
        return null;
    }

    public static boolean isSuccess(String executeStatus) {
        return StringUtils.equalsIgnoreCase((CharSequence)executeStatus, (CharSequence)SUCCESS.getKeyStr());
    }

    public static boolean isFail(String executeStatus) {
        return StringUtils.equalsIgnoreCase((CharSequence)executeStatus, (CharSequence)FAIL.getKeyStr());
    }

    public String getKeyStr() {
        return String.valueOf(this.key);
    }
}

