/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.query.gpe;

import kd.ai.ids.core.query.gpe.CosmicRequestContext;
import kd.ai.ids.core.response.parameter.IdsParameter;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.Services;
import kd.ai.ids.core.utils.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class GpeRequestContext {
    private static final Log log = LogFactory.getLog(GpeRequestContext.class);
    private CosmicRequestContext requestContext;
    private String clientId;
    private String clientSecret;
    private String clientProxyUser;

    public GpeRequestContext() {
    }

    public GpeRequestContext(RequestContext rc) {
        long orgId = OrgUnitServiceHelper.getOrgService().getRootOrgId();
        IdsParameter idsParameter = this.idsParameterService().getIdsParameter(orgId);
        if (rc != null) {
            this.initRequestContext(rc, idsParameter);
        }
        this.clientId = idsParameter.getThirdAppId();
        this.clientProxyUser = idsParameter.getThirdProxyUsername();
    }

    private IIdsParameterService idsParameterService() {
        return Services.get(IIdsParameterService.class);
    }

    private void initRequestContext(RequestContext rc, IdsParameter idsParameter) {
        CosmicRequestContext crc = new CosmicRequestContext();
        crc.setRequestId(rc.getRequestId());
        crc.setTraceId(rc.getTraceId());
        crc.setClient(rc.getClient());
        crc.setUserAgent(rc.getUserAgent());
        crc.setTenantId(rc.getTenantId());
        crc.setTenantCode(rc.getTenantCode());
        crc.setOrgId(rc.getOrgId());
        crc.setUserName(rc.getUserName());
        crc.setUserOpenId(rc.getUserOpenId());
        crc.setUserType(rc.getUserType());
        crc.setQueryString(rc.getQueryString());
        crc.setLang(rc.getLang());
        crc.setLoginIP(rc.getLoginIP());
        crc.setLoginTime(rc.getLoginTime());
        crc.setAccountId(rc.getAccountId());
        crc.setUid(rc.getUid());
        crc.setLoginOrg(rc.getLoginOrg());
        crc.setApi3rdAppId(rc.getApi3rdAppId());
        crc.setClientImageServer(rc.getClientImageServer());
        crc.setOperationType(rc.getOperationType());
        crc.setAuthType(rc.getAuthType());
        String clientFullContextPath = rc.getClientFullContextPath();
        if (this.clientFullContextPathIsEmpty(clientFullContextPath)) {
            String domainContextUrl;
            clientFullContextPath = domainContextUrl = UrlService.getDomainContextUrl();
        }
        if (this.clientFullContextPathIsEmpty(clientFullContextPath)) {
            clientFullContextPath = idsParameter.getCosmicProxyIp();
        }
        clientFullContextPath = StrUtils.replaceProxyIp(clientFullContextPath, idsParameter.getCosmicProxyIp());
        crc.setClientFullContextPath(clientFullContextPath);
        this.requestContext = crc;
    }

    private boolean clientFullContextPathIsEmpty(String clientFullContextPath) {
        return StringUtils.isEmpty((CharSequence)clientFullContextPath) || StringUtils.equalsIgnoreCase((CharSequence)clientFullContextPath, (CharSequence)"null");
    }

    public CosmicRequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(CosmicRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientProxyUser() {
        return this.clientProxyUser;
    }

    public void setClientProxyUser(String clientProxyUser) {
        this.clientProxyUser = clientProxyUser;
    }
}

