/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;

public class BaseResult
implements Serializable {
    public static final Integer SUCCESS = 0;
    public static final Integer FAIL = -1;
    public static final Integer NO_PERMISSION = -401;
    public static final Integer SERVICE_UNAVAILABLE = -502;
    public static final Integer INVALID_ACCESS_TOKEN = 9507;
    private Integer errcode;
    private String description;
    private String descriptionCn;
    private Object data;

    public BaseResult() {
    }

    public BaseResult(Integer errcode) {
        this.errcode = errcode;
    }

    public BaseResult(Integer errcode, String description, String descriptionCn) {
        this(errcode, description, descriptionCn, null);
    }

    public BaseResult(Integer errcode, String description, String descriptionCn, Object data) {
        this.errcode = errcode;
        this.description = description;
        this.data = data;
        this.descriptionCn = descriptionCn;
    }

    public static BaseResult fail(String description, String descriptionCn) {
        return new BaseResult(FAIL, description, descriptionCn);
    }

    public static BaseResult success(String description, String descriptionCn) {
        return new BaseResult(SUCCESS, description, descriptionCn);
    }

    public static BaseResult passResult(JSONObject resultJo) {
        return new BaseResult(resultJo.getInteger("errcode"), resultJo.getString("description"), resultJo.getString("descriptionCn"), resultJo.get((Object)"data"));
    }

    public String toJSONString() {
        JSONObject jo = new JSONObject();
        jo.put("errcode", (Object)this.errcode);
        jo.put("description", (Object)this.description);
        jo.put("descriptionCn", (Object)this.descriptionCn);
        jo.put("data", this.data);
        return jo.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jo = new JSONObject();
        jo.put("errcode", (Object)this.errcode);
        jo.put("description", (Object)this.description);
        jo.put("descriptionCn", (Object)this.descriptionCn);
        jo.put("data", this.data);
        return jo;
    }

    public boolean isSuccess() {
        return this.getErrcode().intValue() == SUCCESS.intValue();
    }

    public Integer getErrcode() {
        return this.errcode;
    }

    public void setErrcode(Integer errcode) {
        this.errcode = errcode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getDescriptionCn() {
        return this.descriptionCn;
    }

    public void setDescriptionCn(String descriptionCn) {
        this.descriptionCn = descriptionCn;
    }

    @JSONField(serialize=false)
    public JSONObject getDataAsJSONObject() {
        if (this.data instanceof JSONObject) {
            return (JSONObject)this.data;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)this.data));
    }

    @JSONField(serialize=false)
    public JSONArray getDataAsJSONArray() {
        if (this.data instanceof JSONArray) {
            return (JSONArray)this.data;
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.data));
    }

    @JSONField(serialize=false)
    public String getDataAsJSONString() {
        if (this.data != null) {
            return JSON.toJSONString((Object)this.data);
        }
        return null;
    }
}

