/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.ids.core.service;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.ai.ids.core.service.IAgreementService;
import kd.ai.ids.core.service.IAnaResultService;
import kd.ai.ids.core.service.IAuthService;
import kd.ai.ids.core.service.ICommonService;
import kd.ai.ids.core.service.IDashboardService;
import kd.ai.ids.core.service.IDataAnalysisService;
import kd.ai.ids.core.service.IDataMarkService;
import kd.ai.ids.core.service.IDataModelService;
import kd.ai.ids.core.service.IDataOutlierAnaService;
import kd.ai.ids.core.service.IDataQualityService;
import kd.ai.ids.core.service.IDataappService;
import kd.ai.ids.core.service.IGPTService;
import kd.ai.ids.core.service.IGpeServerService;
import kd.ai.ids.core.service.IGpeTaskExecuteService;
import kd.ai.ids.core.service.IHelperService;
import kd.ai.ids.core.service.IIdsParameterService;
import kd.ai.ids.core.service.IIdsServerService;
import kd.ai.ids.core.service.ILabelService;
import kd.ai.ids.core.service.IMaterialSaleAnaService;
import kd.ai.ids.core.service.IModelResultService;
import kd.ai.ids.core.service.INewProductService;
import kd.ai.ids.core.service.IOpenAPIService;
import kd.ai.ids.core.service.IPredictObjService;
import kd.ai.ids.core.service.IPredictTargetSchemeService;
import kd.ai.ids.core.service.IRealtimePredictService;
import kd.ai.ids.core.service.IRequirePlanService;
import kd.ai.ids.core.service.IResultExportLogService;
import kd.ai.ids.core.service.ISalesPlanPeriodService;
import kd.ai.ids.core.service.IServiceInterceptor;
import kd.ai.ids.core.service.ISfStandardService;
import kd.ai.ids.core.service.ISupersetService;
import kd.ai.ids.core.service.ITaskExecuteService;
import kd.ai.ids.core.service.ITaskService;
import kd.ai.ids.core.service.ITenantModelService;
import kd.ai.ids.core.service.ITenantService;
import kd.ai.ids.core.service.impl.AgreementServiceImpl;
import kd.ai.ids.core.service.impl.AnaResultServiceImpl;
import kd.ai.ids.core.service.impl.AuthServiceImpl;
import kd.ai.ids.core.service.impl.CommonServiceImpl;
import kd.ai.ids.core.service.impl.DashboardServiceImpl;
import kd.ai.ids.core.service.impl.DataAnalysisServiceImpl;
import kd.ai.ids.core.service.impl.DataMarkServiceImpl;
import kd.ai.ids.core.service.impl.DataModelServiceImpl;
import kd.ai.ids.core.service.impl.DataOutlierAnaServiceImpl;
import kd.ai.ids.core.service.impl.DataQualityServiceImpl;
import kd.ai.ids.core.service.impl.DataappServiceImpl;
import kd.ai.ids.core.service.impl.GPTServiceImpl;
import kd.ai.ids.core.service.impl.GpeServerServiceImpl;
import kd.ai.ids.core.service.impl.GpeTaskExecuteServiceImpl;
import kd.ai.ids.core.service.impl.HelperServiceImpl;
import kd.ai.ids.core.service.impl.IdsParameterServiceImpl;
import kd.ai.ids.core.service.impl.IdsServerServiceImpl;
import kd.ai.ids.core.service.impl.LabelServiceImpl;
import kd.ai.ids.core.service.impl.MaterialSaleAnaServiceImpl;
import kd.ai.ids.core.service.impl.ModelResultServiceImpl;
import kd.ai.ids.core.service.impl.NewProductServiceImpl;
import kd.ai.ids.core.service.impl.OpenAPIServiceImpl;
import kd.ai.ids.core.service.impl.PredictObjServiceImpl;
import kd.ai.ids.core.service.impl.PredictTargetSchemeServiceImpl;
import kd.ai.ids.core.service.impl.RealtimePredictServiceImpl;
import kd.ai.ids.core.service.impl.RequirePlanServiceImpl;
import kd.ai.ids.core.service.impl.ResultExportLogServiceImpl;
import kd.ai.ids.core.service.impl.SalesPlanPeriodServiceImpl;
import kd.ai.ids.core.service.impl.SfStandardServiceImpl;
import kd.ai.ids.core.service.impl.SupersetServiceImpl;
import kd.ai.ids.core.service.impl.TaskExecuteServiceImpl;
import kd.ai.ids.core.service.impl.TaskServiceImpl;
import kd.ai.ids.core.service.impl.TenantModelServiceImpl;
import kd.ai.ids.core.service.impl.TenantServiceImpl;
import kd.ai.ids.core.utils.ConfigFileUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class Services {
    private static final String CONFIG_FILE_NAME = "META-INF/kd/ai/ids/config/kd.ai.ids.config.Service";
    private static final Log log = LogFactory.getLog(Services.class);
    private static final Services instance = new Services();
    private final Map<String, Object> instancesDict = new ConcurrentHashMap<String, Object>();
    private final AtomicBoolean inited = new AtomicBoolean();
    private final List<IServiceInterceptor> interceptorList = new ArrayList<IServiceInterceptor>(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(Class<T> clazz) {
        Services services = instance;
        synchronized (services) {
            if (!instance.isInited()) {
                instance.init();
            }
        }
        for (IServiceInterceptor interceptor : Services.instance.interceptorList) {
            T rtn = interceptor.get(clazz);
            if (rtn == null) continue;
            return rtn;
        }
        String serviceName = clazz.getName();
        return (T)Services.instance.instancesDict.get(serviceName);
    }

    private void init() {
        try {
            this.add(IAgreementService.class, AgreementServiceImpl.class);
            this.add(IAuthService.class, AuthServiceImpl.class);
            this.add(IDataappService.class, DataappServiceImpl.class);
            this.add(IIdsParameterService.class, IdsParameterServiceImpl.class);
            this.add(IIdsServerService.class, IdsServerServiceImpl.class);
            this.add(ILabelService.class, LabelServiceImpl.class);
            this.add(ITenantModelService.class, TenantModelServiceImpl.class);
            this.add(ITenantService.class, TenantServiceImpl.class);
            this.add(IDataQualityService.class, DataQualityServiceImpl.class);
            this.add(IPredictTargetSchemeService.class, PredictTargetSchemeServiceImpl.class);
            this.add(ITaskExecuteService.class, TaskExecuteServiceImpl.class);
            this.add(ITaskService.class, TaskServiceImpl.class);
            this.add(IAnaResultService.class, AnaResultServiceImpl.class);
            this.add(IDataAnalysisService.class, DataAnalysisServiceImpl.class);
            this.add(IModelResultService.class, ModelResultServiceImpl.class);
            this.add(IMaterialSaleAnaService.class, MaterialSaleAnaServiceImpl.class);
            this.add(IDataOutlierAnaService.class, DataOutlierAnaServiceImpl.class);
            this.add(IResultExportLogService.class, ResultExportLogServiceImpl.class);
            this.add(INewProductService.class, NewProductServiceImpl.class);
            this.add(IDataMarkService.class, DataMarkServiceImpl.class);
            this.add(ICommonService.class, CommonServiceImpl.class);
            this.add(IPredictObjService.class, PredictObjServiceImpl.class);
            this.add(IRealtimePredictService.class, RealtimePredictServiceImpl.class);
            this.add(IRequirePlanService.class, RequirePlanServiceImpl.class);
            this.add(ISalesPlanPeriodService.class, SalesPlanPeriodServiceImpl.class);
            this.add(IDataModelService.class, DataModelServiceImpl.class);
            this.add(IDashboardService.class, DashboardServiceImpl.class);
            this.add(ISupersetService.class, SupersetServiceImpl.class);
            this.add(IGPTService.class, GPTServiceImpl.class);
            this.add(IHelperService.class, HelperServiceImpl.class);
            this.add(ISfStandardService.class, SfStandardServiceImpl.class);
            this.add(IGpeServerService.class, GpeServerServiceImpl.class);
            this.add(IGpeTaskExecuteService.class, GpeTaskExecuteServiceImpl.class);
            this.add(IOpenAPIService.class, OpenAPIServiceImpl.class);
            this.loadByConfigFile();
        }
        finally {
            this.inited.set(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadByConfigFile() {
        List<String> fileDataList = ConfigFileUtil.loadFile(CONFIG_FILE_NAME);
        Iterator<String> iterator = fileDataList.iterator();
        block13: while (iterator.hasNext()) {
            String fileData = iterator.next();
            try {
                BufferedReader br = new BufferedReader(new StringReader(fileData));
                Throwable throwable = null;
                try {
                    while (true) {
                        String line;
                        if ((line = br.readLine()) == null) continue block13;
                        if (StringUtils.isEmpty((String)(line = line.trim()))) continue;
                        try {
                            Class<?> clazz = Class.forName(line);
                            if (!IServiceInterceptor.class.isAssignableFrom(clazz)) continue;
                            this.interceptorList.add((IServiceInterceptor)clazz.newInstance());
                            log.info("load service interceptor : " + line);
                        }
                        catch (Exception ex) {
                            log.info("load service interceptor error! " + line);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    public <T> void add(Class<T> clazz, Class<? extends T> implClass) {
        try {
            this.instancesDict.put(clazz.getName(), implClass.newInstance());
        }
        catch (Exception ex) {
            log.info("init service error: " + clazz.getSimpleName() + " msg:" + ex);
        }
    }

    public boolean isInited() {
        return this.inited.get();
    }
}

